/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer.parser;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.Target;
import net.minecraftforge.accesstransformer.TargetType;
import net.minecraftforge.accesstransformer.generated.AtLexer;
import net.minecraftforge.accesstransformer.generated.AtParser;
import net.minecraftforge.accesstransformer.parser.AccessTransformVisitor;
import net.minecraftforge.accesstransformer.parser.AtParserErrorListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.Type;

public class AccessTransformerList {
    private static final Logger LOGGER = LogManager.getLogger((String)"AXFORM");
    private static final Marker AXFORM_MARKER = MarkerManager.getMarker((String)"AXFORM");
    private final Map<Target<?>, AccessTransformer> accessTransformers = new HashMap();

    public void loadFromResource(String resourceName) throws URISyntaxException, IOException {
        Path path = Paths.get(this.getClass().getClassLoader().getResource(resourceName).toURI());
        this.loadFromPath(path, resourceName);
    }

    public void loadFromPath(Path path, String resourceName) throws IOException {
        LOGGER.debug(AXFORM_MARKER, "Loading access transformer {} from path {}", (Object)resourceName, (Object)path);
        CharStream stream = CharStreams.fromPath((Path)path);
        AtLexer lexer = new AtLexer(stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        AtParser parser = new AtParser((TokenStream)tokenStream);
        parser.addErrorListener((ANTLRErrorListener)new AtParserErrorListener());
        AtParser.FileContext file = parser.file();
        AccessTransformVisitor accessTransformVisitor = new AccessTransformVisitor(resourceName);
        file.accept(accessTransformVisitor);
        HashMap localATCopy = new HashMap(this.accessTransformers);
        this.mergeAccessTransformers(accessTransformVisitor.getAccessTransformers(), localATCopy, resourceName);
        List<AccessTransformer> invalidTransformers = this.invalidTransformers(localATCopy);
        if (!invalidTransformers.isEmpty()) {
            invalidTransformers.forEach(at -> LOGGER.error(AXFORM_MARKER, "Invalid access transform final state for target {}. Referred in resources {}.", at.getTarget(), at.getOrigins()));
            throw new IllegalArgumentException("Invalid AT final conflicts");
        }
        this.accessTransformers.clear();
        this.accessTransformers.putAll(localATCopy);
        LOGGER.debug(AXFORM_MARKER, "Loaded access transformer {} from path {}", (Object)resourceName, (Object)path);
    }

    private void mergeAccessTransformers(List<AccessTransformer> atList, Map<Target<?>, AccessTransformer> accessTransformers, String resourceName) {
        atList.forEach(at -> accessTransformers.merge(at.getTarget(), (AccessTransformer)at, (accessTransformer, at2) -> accessTransformer.mergeStates((AccessTransformer)at2, resourceName)));
    }

    private List<AccessTransformer> invalidTransformers(HashMap<Target<?>, AccessTransformer> accessTransformers) {
        return accessTransformers.values().stream().filter(e -> !e.isValid()).collect(Collectors.toList());
    }

    public Map<String, List<AccessTransformer>> getAccessTransformers() {
        return this.accessTransformers.entrySet().stream().collect(Collectors.groupingBy(e -> ((AccessTransformer)e.getValue()).getTarget().getClassName(), HashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public boolean containsClassTarget(Type type) {
        return this.accessTransformers.keySet().stream().anyMatch(k -> type.equals((Object)k.getASMType()));
    }

    public Map<TargetType, Map<String, AccessTransformer>> getTransformersForTarget(Type type) {
        return this.accessTransformers.entrySet().stream().filter(e -> type.equals((Object)((Target)e.getKey()).getASMType())).map(Map.Entry::getValue).collect(Collectors.groupingBy(o -> o.getTarget().getType(), HashMap::new, Collectors.toMap(at -> at.getTarget().targetName(), Function.identity())));
    }
}

