/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import net.minecraftforge.srg2source.api.InputSupplier;
import net.minecraftforge.srg2source.util.Util;

public class ZipInputSupplier
implements InputSupplier {
    private final String root;
    private final Map<String, byte[]> data;
    private final Charset encoding;

    public static ZipInputSupplier create(Path path, @Nullable Charset encoding) throws IOException {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);
             ZipInputStream zin = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                data.put(entry.getName(), Util.readStream(zin));
            }
        }
        return new ZipInputSupplier(path.toString(), data, encoding);
    }

    private ZipInputSupplier(String root, Map<String, byte[]> data, @Nullable Charset encoding) {
        this.root = root;
        this.data = data;
        this.encoding = encoding;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public InputStream getInput(String relPath) {
        try {
            return new ByteArrayInputStream(this.data.get(relPath));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<String> gatherAll(String endFilter) {
        LinkedList<String> out = new LinkedList<String>();
        for (String key : this.data.keySet()) {
            if (!key.endsWith(endFilter)) continue;
            out.add(key);
        }
        return out;
    }

    @Override
    public String getRoot(String resource) {
        return this.root;
    }

    @Override
    public Charset getEncoding(String resource) {
        return this.encoding;
    }
}

