/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.mixin;

import javax.annotation.Nullable;
import net.minecraftforge.srg2source.extract.ExtractUtil;
import net.minecraftforge.srg2source.extract.MixinProcessor;
import net.minecraftforge.srg2source.mixin.AnnotationBase;
import net.minecraftforge.srg2source.mixin.MixinAnnotation;
import net.minecraftforge.srg2source.mixin.MixinInfo;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class Accessor
extends AnnotationBase {
    private final String typeName;

    public Accessor(MixinProcessor processor) {
        this(processor, MixinAnnotation.ACCESSOR);
    }

    protected Accessor(MixinProcessor processor, MixinAnnotation type) {
        super(processor, type);
        this.typeName = type == MixinAnnotation.ACCESSOR ? "@Accessor" : "@Invoke";
    }

    private MethodDeclaration getMethod(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent.getNodeType() != 31) {
            this.error(parent, "Found " + this.typeName + " annotation on non-method declaration: " + node.toString());
            return null;
        }
        return (MethodDeclaration)parent;
    }

    @Override
    public boolean process(NormalAnnotation node) {
        StringLiteral value = null;
        block8: for (MemberValuePair mvp : node.values()) {
            switch (mvp.getName().toString()) {
                case "remap": {
                    continue block8;
                }
                case "value": {
                    if (mvp.getValue().getNodeType() != 45) {
                        return this.error((ASTNode)node, "Unknown " + this.typeName + " value type: " + mvp.getValue().toString());
                    }
                    value = (StringLiteral)mvp.getValue();
                    continue block8;
                }
            }
            return this.error((ASTNode)node, "Unknown " + this.typeName + " member: " + node.toString());
        }
        return this.process(this.getMethod((ASTNode)node), value);
    }

    @Override
    public boolean process(SingleMemberAnnotation node) {
        if (node.getValue().getNodeType() != 45) {
            return this.error((ASTNode)node, "Unknown " + this.typeName + " value type: " + node.getValue().toString());
        }
        return this.process(this.getMethod((ASTNode)node), (StringLiteral)node.getValue());
    }

    @Override
    public boolean process(MarkerAnnotation node) {
        return this.process(this.getMethod((ASTNode)node), null);
    }

    private boolean process(MethodDeclaration mtd, @Nullable StringLiteral value) {
        if (mtd == null) {
            return true;
        }
        IMethodBinding bind = mtd.resolveBinding();
        String owner = ExtractUtil.getInternalName(this.getFilename(), bind.getDeclaringClass(), (ASTNode)mtd);
        MixinInfo info = this.getInfo(owner);
        if (info == null) {
            return this.error((ASTNode)mtd, "Invalid " + this.typeName + " on " + bind.getName() + ExtractUtil.getDescriptor(bind) + " owner " + owner + " has no @Mixin");
        }
        MixinInfo.AccessorName name = MixinInfo.AccessorName.from(mtd.getName().toString(), info.getOwner(), value == null ? null : value.getLiteralValue());
        String desc = ExtractUtil.getDescriptor(bind);
        if (info.getTarget() == null) {
            return true;
        }
        if (name == null) {
            return this.error((ASTNode)value, "Invalid " + this.typeName + " on " + info.getOwner() + "." + bind.getName() + desc + " Does not match valid nameing format.");
        }
        switch (name.getType()) {
            case GETTER: 
            case SETTER: {
                String tDesc;
                String string = tDesc = name.getType() == MixinInfo.AccessorType.GETTER ? ExtractUtil.getInternalName(this.getFilename(), bind.getReturnType(), (ASTNode)mtd) : ExtractUtil.getInternalName(this.getFilename(), bind.getParameterTypes()[0], (ASTNode)mtd);
                if (value != null) {
                    this.getBuilder().addFieldLiteral(value.getStartPosition(), value.getLength(), value.getEscapedValue(), info.getTarget(), name.getTarget());
                    break;
                }
                this.getBuilder().addMixinAccessor(info.getOwner(), name.getMethod(), desc, info.getTarget(), name.getTarget(), tDesc, name.getPrefix());
                break;
            }
            case PROXY: {
                if (value != null) {
                    this.getBuilder().addMethodLiteral(value.getStartPosition(), value.getLength(), value.getEscapedValue(), info.getTarget(), name.getTarget(), desc);
                    break;
                }
                this.getBuilder().addMixinAccessor(info.getOwner(), name.getMethod(), desc, info.getTarget(), name.getTarget(), desc, name.getPrefix());
                break;
            }
            case FACTORY: {
                if (value != null) {
                    if ("<init>".equals(value.getLiteralValue())) break;
                    this.getBuilder().addClassLiteral(value.getStartPosition(), value.getLength(), value.getEscapedValue(), info.getTarget());
                    break;
                }
                String cDesc = desc.substring(0, desc.lastIndexOf(41) + 1) + "V";
                this.getBuilder().addMixinAccessor(info.getOwner(), name.getMethod(), desc, info.getTarget(), "<init>", cDesc, name.getPrefix());
            }
        }
        return true;
    }
}

