/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.range.entries;

import java.util.function.Consumer;
import net.minecraftforge.srg2source.range.entries.RangeEntry;

public class FieldReference
extends RangeEntry {
    private final String owner;

    public static FieldReference create(int start, int length, String text, String owner) {
        return new FieldReference(start, length, text, owner);
    }

    static FieldReference read(int spec, int start, int length, String text, String data) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Invalid Field reference Missing Owner");
        }
        return new FieldReference(start, length, text, data);
    }

    protected FieldReference(int start, int length, String text, String owner) {
        super(RangeEntry.Type.FIELD, start, length, text);
        this.owner = owner;
    }

    public String getName() {
        return this.getText();
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    protected String getExtraFields() {
        return "Owner: " + this.owner;
    }

    @Override
    protected void writeInternal(Consumer<String> out) {
        out.accept(this.owner);
    }
}

