/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.osgi.internal.debug.Debug;

public class StorageUtil {
    private static final boolean IS_WINDOWS = "\\\\.\\NUL".equals(StorageUtil.getDeviceName(new File("NUL")));
    private static HashSet<String> RESERVED_NAMES = new HashSet<String>(Arrays.asList("aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"));

    public static void copyDir(File inDir, File outDir) throws IOException {
        String[] files = inDir.list();
        if (files != null && files.length > 0) {
            outDir.mkdir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inFile = new File(inDir, file);
                File outFile = new File(outDir, file);
                if (inFile.isDirectory()) {
                    StorageUtil.copyDir(inFile, outFile);
                } else {
                    FileInputStream in = new FileInputStream(inFile);
                    StorageUtil.readFile(in, outFile);
                }
                ++n2;
            }
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean rm(File file, boolean DEBUG) {
        if (file.exists()) {
            String[] list;
            if (file.isDirectory() && (list = file.list()) != null) {
                int len = list.length;
                int i = 0;
                while (i < len) {
                    StorageUtil.rm(new File(file, list[i]), DEBUG);
                    ++i;
                }
            }
            if (DEBUG) {
                if (file.isDirectory()) {
                    Debug.println("rmdir " + file.getPath());
                } else {
                    Debug.println("rm " + file.getPath());
                }
            }
            boolean success = file.delete();
            if (DEBUG && !success) {
                Debug.println("  rm failed!");
            }
            return success;
        }
        return true;
    }

    public static boolean canWrite(File installDir) {
        if (!installDir.isDirectory()) {
            return false;
        }
        if (Files.isWritable(installDir.toPath())) {
            return true;
        }
        File fileTest = null;
        try {
            try {
                fileTest = File.createTempFile("writableArea", ".dll", installDir);
            }
            catch (IOException iOException) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    public static URL encodeFileURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static byte[] getBytes(InputStream in, int length, int BUF_SIZE) throws IOException {
        byte[] classbytes;
        int bytesread = 0;
        try {
            byte[] oldbytes;
            if (length > 0) {
                classbytes = new byte[length];
                while (bytesread < length) {
                    int readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount > 0) {
                        bytesread += readcount;
                        continue;
                    }
                    break;
                }
            } else {
                length = BUF_SIZE;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread < length) {
                        int readcount = in.read(classbytes, bytesread, length - bytesread);
                        if (readcount > 0) {
                            bytesread += readcount;
                            continue;
                        }
                        break;
                    }
                    oldbytes = classbytes;
                    classbytes = new byte[length += BUF_SIZE];
                    System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                }
            }
            if (classbytes.length > bytesread) {
                oldbytes = classbytes;
                classbytes = new byte[bytesread];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return classbytes;
    }

    public static void move(File from, File to, boolean DEBUG) throws IOException {
        try {
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                Debug.println("Failed to move atomically: " + from + " to " + to);
            }
            StorageUtil.rm(to, DEBUG);
            Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (DEBUG) {
            Debug.println("Successfully moved file: " + from + " to " + to);
        }
    }

    private static String getDeviceName(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isReservedFileName(File file) {
        String fileName = file.getName();
        return StorageUtil.isReservedFileName(fileName);
    }

    private static boolean isReservedFileName(String name) {
        if (!IS_WINDOWS) {
            return false;
        }
        int dot = name.indexOf(46);
        String basename = dot == -1 ? name : name.substring(0, dot);
        return RESERVED_NAMES.contains(basename.toLowerCase());
    }
}

