/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.sources;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;
import org.eclipse.osgi.util.ManifestElement;

public class FilteredSourcePackage
extends SingleSourcePackage {
    private final String[] includes;
    private final String[] excludes;

    public FilteredSourcePackage(String name, BundleLoader supplier, String includes, String excludes) {
        super(name, supplier);
        this.includes = includes != null ? ManifestElement.getArrayFromList(includes) : null;
        this.excludes = excludes != null ? ManifestElement.getArrayFromList(excludes) : null;
    }

    @Override
    public URL getResource(String name) {
        if (this.isFiltered(name, this.getId())) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        if (this.isFiltered(name, this.getId())) {
            return null;
        }
        return super.getResources(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isFiltered(name, this.getId())) {
            return null;
        }
        return super.loadClass(name);
    }

    private boolean isFiltered(String name, String pkgName) {
        String lastName = this.getName(name, pkgName);
        return !this.isIncluded(lastName) || this.isExcluded(lastName);
    }

    private String getName(String name, String pkgName) {
        if (!".".equals(pkgName) && pkgName.length() + 1 <= name.length()) {
            return name.substring(pkgName.length() + 1);
        }
        return name;
    }

    private boolean isIncluded(String name) {
        if (this.includes == null) {
            return true;
        }
        return this.isInList(name, this.includes);
    }

    private boolean isExcluded(String name) {
        if (this.excludes == null) {
            return false;
        }
        return this.isInList(name, this.excludes);
    }

    private boolean isInList(String name, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int len = s.length();
            if (len != 0) {
                if (s.charAt(0) == '*' && len == 1) {
                    return true;
                }
                if (s.charAt(len - 1) == '*' && name.startsWith(s.substring(0, len - 1))) {
                    return true;
                }
                if (name.equals(s)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

