/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.osgi.container.Module;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();
    static final ClassLoader bootClassLoader = AccessController.doPrivileged(() -> new ClassLoader(Object.class.getClassLoader()){});

    SecureAction() {
    }

    public static PrivilegedAction<SecureAction> createSecureAction() {
        return SecureAction::new;
    }

    public String getProperty(String property) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property);
        }
        return SecureAction.doPrivileged(() -> System.getProperty(property), this.controlContext);
    }

    public Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return SecureAction.doPrivileged(System::getProperties, this.controlContext);
    }

    public FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return SecureAction.doPrivilegedWithException(() -> new FileInputStream(file), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public FileOutputStream getFileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), append);
        }
        try {
            return SecureAction.doPrivilegedWithException(() -> new FileOutputStream(file.getAbsolutePath(), append), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public long length(File file) {
        if (System.getSecurityManager() == null) {
            return file.length();
        }
        return SecureAction.doPrivileged(file::length, this.controlContext);
    }

    public String getCanonicalPath(File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalPath();
        }
        try {
            return SecureAction.doPrivilegedWithException(file::getCanonicalPath, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public File getAbsoluteFile(File file) {
        if (System.getSecurityManager() == null) {
            return file.getAbsoluteFile();
        }
        return SecureAction.doPrivileged(file::getAbsoluteFile, this.controlContext);
    }

    public File getCanonicalFile(File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalFile();
        }
        try {
            return SecureAction.doPrivilegedWithException(file::getCanonicalFile, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public boolean exists(File file) {
        if (System.getSecurityManager() == null) {
            return file.exists();
        }
        return SecureAction.doPrivileged(file::exists, this.controlContext);
    }

    public boolean mkdirs(File file) {
        if (System.getSecurityManager() == null) {
            return file.mkdirs();
        }
        return SecureAction.doPrivileged(file::mkdirs, this.controlContext);
    }

    public boolean isDirectory(File file) {
        if (System.getSecurityManager() == null) {
            return file.isDirectory();
        }
        return SecureAction.doPrivileged(file::isDirectory, this.controlContext);
    }

    public long lastModified(File file) {
        if (System.getSecurityManager() == null) {
            return file.lastModified();
        }
        return SecureAction.doPrivileged(file::lastModified, this.controlContext);
    }

    public String[] list(File file) {
        if (System.getSecurityManager() == null) {
            return file.list();
        }
        return SecureAction.doPrivileged(file::list, this.controlContext);
    }

    public ZipFile getZipFile(File file, boolean verify) throws IOException {
        try {
            if (System.getSecurityManager() == null) {
                return new ZipFile(file);
            }
            try {
                return SecureAction.doPrivilegedWithException(() -> verify ? new JarFile(file) : new ZipFile(file), this.controlContext);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw (RuntimeException)e.getException();
            }
        }
        catch (ZipException e) {
            ZipException zipNameException = new ZipException("Exception in opening zip file: " + file.getPath());
            zipNameException.initCause(e);
            throw zipNameException;
        }
        catch (IOException e) {
            throw new IOException("Exception in opening zip file: " + file.getPath(), e);
        }
    }

    public URL getURL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() == null) {
            return new URL(protocol, host, port, file, handler);
        }
        try {
            return SecureAction.doPrivilegedWithException(() -> new URL(protocol, host, port, file, handler), this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof MalformedURLException) {
                throw (MalformedURLException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public <S> S getService(ServiceReference<S> reference, BundleContext context) {
        if (System.getSecurityManager() == null) {
            return context.getService(reference);
        }
        return (S)SecureAction.doPrivileged(() -> context.getService(reference), this.controlContext);
    }

    public void start(Module module, Module.StartOptions ... options) throws BundleException {
        if (System.getSecurityManager() == null) {
            module.start(options);
            return;
        }
        try {
            SecureAction.doPrivilegedWithException(() -> {
                module.start(options);
                return null;
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof BundleException) {
                throw (BundleException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public BundleContext getContext(Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getBundleContext();
        }
        return SecureAction.doPrivileged(bundle::getBundleContext, this.controlContext);
    }

    public String getLocation(Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getLocation();
        }
        return SecureAction.doPrivileged(bundle::getLocation, this.controlContext);
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
        return AccessController.doPrivileged(action, context);
    }

    private static <T> T doPrivilegedWithException(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        return AccessController.doPrivileged(action, context);
    }
}

