/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IConstantPoolEntry3;
import org.eclipse.jdt.core.util.IModulePackagesAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileAttribute;

public class ModulePackagesAttribute
extends ClassFileAttribute
implements IModulePackagesAttribute {
    private int packagesCount;
    private int[] packageIndices;
    private char[][] packageNames;

    public ModulePackagesAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int readOffset = 6;
        int length = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        this.packagesCount = length;
        if (length != 0) {
            this.packageIndices = new int[length];
            this.packageNames = new char[length][0];
            int i = 0;
            while (i < length) {
                this.packageIndices[i] = this.u2At(classFileBytes, readOffset, offset);
                readOffset += 2;
                IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.packageIndices[i]);
                if (constantPoolEntry.getKind() != 20) {
                    throw new ClassFormatException(3);
                }
                char[] name = ((IConstantPoolEntry3)constantPoolEntry).getPackageName();
                this.packageNames[i] = name != null ? name : CharOperation.NO_CHAR;
                ++i;
            }
        } else {
            this.packageNames = CharOperation.NO_CHAR_CHAR;
        }
    }

    @Override
    public int getPackagesCount() {
        return this.packagesCount;
    }

    @Override
    public char[][] getPackageNames() {
        return this.packageNames;
    }
}

