/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.ILRUCacheable;
import org.eclipse.jdt.internal.core.util.ToStringSorter;

public class LRUCache<K, V>
implements Cloneable {
    protected int currentSpace = 0;
    protected int spaceLimit;
    protected int timestampCounter = 0;
    protected Hashtable<K, LRUCacheEntry<K, V>> entryTable;
    protected LRUCacheEntry<K, V> entryQueue = null;
    protected LRUCacheEntry<K, V> entryQueueTail = null;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int size) {
        this.entryTable = new Hashtable(size);
        this.spaceLimit = size;
    }

    public LRUCache<K, V> clone() {
        LRUCache newCache = this.newInstance(this.spaceLimit);
        LRUCacheEntry<K, V> qEntry = this.entryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry.key, qEntry.value, qEntry.space);
            qEntry = qEntry.previous;
        }
        return newCache;
    }

    public double fillingRatio() {
        return (double)this.currentSpace * 100.0 / (double)this.spaceLimit;
    }

    public void flush(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return;
        }
        this.privateRemoveEntry(entry, false);
    }

    public K getKey(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return key;
        }
        return entry.key;
    }

    public V get(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        this.updateTimestamp(entry);
        return entry.value;
    }

    public int getCurrentSpace() {
        return this.currentSpace;
    }

    public int getSpaceLimit() {
        return this.spaceLimit;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int space) {
        limit = this.getSpaceLimit();
        if (this.currentSpace + space <= limit) {
            return true;
        }
        if (space <= limit) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.entryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.currentSpace + space > limit && this.entryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected LRUCache<K, V> newInstance(int size) {
        return new LRUCache<K, V>(size);
    }

    public V peek(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected void privateAdd(K key, V value, int space) {
        LRUCacheEntry<K, V> entry = new LRUCacheEntry<K, V>(key, value, space);
        this.privateAddEntry(entry, false);
    }

    protected void privateAddEntry(LRUCacheEntry<K, V> entry, boolean shuffle) {
        if (!shuffle) {
            this.entryTable.put(entry.key, entry);
            this.currentSpace += entry.space;
        }
        entry.timestamp = this.timestampCounter++;
        entry.next = this.entryQueue;
        entry.previous = null;
        if (this.entryQueue == null) {
            this.entryQueueTail = entry;
        } else {
            this.entryQueue.previous = entry;
        }
        this.entryQueue = entry;
    }

    protected void privateRemoveEntry(LRUCacheEntry<K, V> entry, boolean shuffle) {
        LRUCacheEntry previous = entry.previous;
        LRUCacheEntry next = entry.next;
        if (!shuffle) {
            this.entryTable.remove(entry.key);
            this.currentSpace -= entry.space;
        }
        if (previous == null) {
            this.entryQueue = next;
        } else {
            previous.next = next;
        }
        if (next == null) {
            this.entryQueueTail = previous;
        } else {
            next.previous = previous;
        }
    }

    public V put(K key, V value) {
        int newSpace = this.spaceFor(value);
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry != null) {
            int oldSpace = entry.space;
            int newTotal = this.getCurrentSpace() - oldSpace + newSpace;
            if (newTotal <= this.getSpaceLimit()) {
                this.updateTimestamp(entry);
                entry.value = value;
                entry.space = newSpace;
                this.currentSpace = newTotal;
                return value;
            }
            this.privateRemoveEntry(entry, false);
        }
        if (this.makeSpace(newSpace)) {
            this.privateAdd(key, value, newSpace);
        }
        return value;
    }

    public V removeKey(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.value;
        this.privateRemoveEntry(entry, false);
        return value;
    }

    public void setSpaceLimit(int limit) {
        if (limit < this.spaceLimit) {
            this.makeSpace(this.spaceLimit - limit);
        }
        this.spaceLimit = limit;
    }

    protected int spaceFor(V value) {
        if (value instanceof ILRUCacheable) {
            return ((ILRUCacheable)value).getCacheFootprint();
        }
        return 1;
    }

    public String toString() {
        return String.valueOf(this.toStringFillingRation("LRUCache")) + this.toStringContents();
    }

    protected String toStringContents() {
        StringBuilder result = new StringBuilder();
        ToStringSorter<Object> sorter = new ToStringSorter<Object>(o -> o instanceof JavaElement ? ((JavaElement)o).getElementName() : o.toString());
        List<ToStringSorter.Pair<Object>> sortedObjects = sorter.sort(this.entryTable.keySet());
        for (ToStringSorter.Pair<Object> pair : sortedObjects) {
            String toString = pair.string;
            V value = this.get(pair.object);
            result.append(toString);
            result.append(" -> ");
            result.append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public String toStringFillingRation(String cacheName) {
        StringBuilder buffer = new StringBuilder(cacheName);
        buffer.append('[');
        buffer.append(this.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.fillingRatio()));
        buffer.append("% full");
        return buffer.toString();
    }

    protected void updateTimestamp(LRUCacheEntry<K, V> entry) {
        entry.timestamp = this.timestampCounter++;
        if (this.entryQueue != entry) {
            this.privateRemoveEntry(entry, true);
            this.privateAddEntry(entry, true);
        }
    }

    public static class LRUCacheEntry<K, V> {
        public K key;
        public V value;
        public int timestamp;
        public int space;
        public LRUCacheEntry<K, V> previous;
        public LRUCacheEntry<K, V> next;

        public LRUCacheEntry(K key, V value, int space) {
            this.key = key;
            this.value = value;
            this.space = space;
        }

        public String toString() {
            return "LRUCacheEntry [" + this.key + "-->" + this.value + "]";
        }
    }
}

