/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IComponentInfo;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.internal.core.util.ClassFileAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileStruct;
import org.eclipse.jdt.internal.core.util.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.jdt.internal.core.util.RuntimeInvisibleTypeAnnotationsAttribute;
import org.eclipse.jdt.internal.core.util.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.jdt.internal.core.util.RuntimeVisibleTypeAnnotationsAttribute;
import org.eclipse.jdt.internal.core.util.SignatureAttribute;

public class ComponentInfo
extends ClassFileStruct
implements IComponentInfo {
    private int attributeBytes;
    private IClassFileAttribute[] attributes;
    private int attributesCount;
    private char[] descriptor;
    private int descriptorIndex;
    private char[] name;
    private int nameIndex;

    public ComponentInfo(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        this.nameIndex = this.u2At(classFileBytes, 0, offset);
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.nameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = constantPoolEntry.getUtf8Value();
        this.descriptorIndex = this.u2At(classFileBytes, 2, offset);
        constantPoolEntry = constantPool.decodeEntry(this.descriptorIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.descriptor = constantPoolEntry.getUtf8Value();
        this.attributesCount = this.u2At(classFileBytes, 4, offset);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        int readOffset = 6;
        if (this.attributesCount != 0) {
            this.attributes = new IClassFileAttribute[this.attributesCount];
        }
        int attributesIndex = 0;
        int i = 0;
        while (i < this.attributesCount) {
            constantPoolEntry = constantPool.decodeEntry(this.u2At(classFileBytes, readOffset, offset));
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] attributeName = constantPoolEntry.getUtf8Value();
            this.attributes[attributesIndex++] = this.equals(attributeName, IAttributeNamesConstants.SIGNATURE) ? new SignatureAttribute(classFileBytes, constantPool, offset + readOffset) : (this.equals(attributeName, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS) ? new RuntimeVisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (this.equals(attributeName, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS) ? new RuntimeInvisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (this.equals(attributeName, IAttributeNamesConstants.RUNTIME_VISIBLE_TYPE_ANNOTATIONS) ? new RuntimeVisibleTypeAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (this.equals(attributeName, IAttributeNamesConstants.RUNTIME_INVISIBLE_TYPE_ANNOTATIONS) ? new RuntimeInvisibleTypeAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset)))));
            readOffset = (int)((long)readOffset + (6L + this.u4At(classFileBytes, readOffset + 2, offset)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    @Override
    public IClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    @Override
    public char[] getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    @Override
    public char[] getName() {
        return this.name;
    }

    @Override
    public int sizeInBytes() {
        return this.attributeBytes;
    }
}

