/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;

public class MatchLocator
implements ITypeRequestor {
    public static final int MAX_AT_ONCE;
    private Parser basicParser;
    public LookupEnvironment lookupEnvironment;
    public CompilerOptions options;

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int ratio = (int)Math.round((double)maxMemory / 6.7108864E7);
        switch (ratio) {
            case 0: 
            case 1: {
                MAX_AT_ONCE = 100;
                break;
            }
            case 2: {
                MAX_AT_ONCE = 200;
                break;
            }
            case 3: {
                MAX_AT_ONCE = 300;
                break;
            }
            default: {
                MAX_AT_ONCE = 400;
            }
        }
    }

    public static void setFocus(SearchPattern pattern, IJavaElement focus) {
        pattern.focus = focus;
    }

    public static void setIndexQualifierQuery(SearchPattern pattern, char[] queries) {
        pattern.indexQualifierQuery = queries;
    }

    public static void findIndexMatches(SearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, monitor);
    }

    public static void findIndexMatches(SearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentName, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, resolveDocumentName, monitor);
    }

    public static IJavaElement getProjectOrJar(IJavaElement element) {
        while (!(element instanceof IJavaProject) && !(element instanceof JarPackageFragmentRoot)) {
            element = element.getParent();
        }
        return element;
    }

    public static IJavaElement projectOrJarFocus(SearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrJar(pattern.focus);
    }

    @Override
    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    @Override
    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        CompilationResult unitResult;
        block3: {
            unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit = this.basicParser().dietParse(sourceUnit, unitResult);
                this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
                this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
            }
            catch (AbortCompilationUnit e) {
                if (unitResult.compilationUnit == sourceUnit) break block3;
                throw e;
            }
        }
        if (BasicSearchEngine.VERBOSE && unitResult.problemCount > 0) {
            System.out.println(unitResult);
        }
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            ICompilationUnit sourceUnit = (ICompilationUnit)((Object)type.getCompilationUnit());
            this.accept(sourceUnit, accessRestriction);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
            if (unit != null) {
                this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
                this.lookupEnvironment.completeTypeBindings(unit, true);
            }
        }
    }

    protected Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
        }
        return this.basicParser;
    }
}

