/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.QualifierQuery;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.ModulePattern;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

public class IndexSelector {
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IndexLocation[] indexLocations;

    public IndexSelector(IJavaSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    private static int canSeeFocus(IJavaElement[] focuses, JavaProject javaProject, char[][][] focusQualifiedNames) {
        int result = 2;
        int length = focuses.length;
        int i = 0;
        while (i < length) {
            int canSeeFocus = IndexSelector.canSeeFocus(focuses[i], javaProject, focusQualifiedNames);
            if (canSeeFocus == 0) {
                return 0;
            }
            if (canSeeFocus == 1) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int canSeeFocus(IJavaElement focus, JavaProject javaProject, char[][][] focusQualifiedNames) {
        try {
            if (focus == null) {
                return 2;
            }
            if (focus.equals(javaProject)) {
                return 0;
            }
            if (focus instanceof JarPackageFragmentRoot) {
                IPath focusPath = focus.getPath();
                IClasspathEntry[] entries = javaProject.getExpandedClasspath();
                int i = 0;
                int length = entries.length;
                while (i < length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals(focusPath)) {
                        return 0;
                    }
                    ++i;
                }
                return 2;
            }
            IPath focusPath = ((JavaProject)focus).getProject().getFullPath();
            IClasspathEntry[] entries = javaProject.getExpandedClasspath();
            int i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals(focusPath)) {
                    State projectState;
                    if (focusQualifiedNames != null && (projectState = (State)JavaModelManager.getJavaModelManager().getLastBuiltState(javaProject.getProject(), null)) != null) {
                        Collection<ReferenceCollection> values = projectState.getReferences().values();
                        for (ReferenceCollection references : values) {
                            if (references == null || !references.includes(focusQualifiedNames, null, null)) continue;
                            return 0;
                        }
                        return 1;
                    }
                    return 0;
                }
                ++i;
            }
            return 2;
        }
        catch (JavaModelException javaModelException) {
            return 2;
        }
    }

    private static IJavaElement[] getFocusedElementsAndTypes(SearchPattern pattern, IJavaElement focusElement, ObjectVector superTypes) throws JavaModelException {
        if (pattern instanceof MethodPattern) {
            IType type = (IType)pattern.focus.getAncestor(7);
            MethodPattern methodPattern = (MethodPattern)pattern;
            String selector = new String(methodPattern.selector);
            int parameterCount = methodPattern.parameterCount;
            ITypeHierarchy superHierarchy = type.newSupertypeHierarchy(null);
            IType[] allTypes = superHierarchy.getAllSupertypes(type);
            int length = allTypes.length;
            SimpleSet focusSet = new SimpleSet(length + 1);
            if (focusElement != null) {
                focusSet.add(focusElement);
            }
            int i = 0;
            while (i < length) {
                IMethod[] methods = allTypes[i].getMethods();
                int mLength = methods.length;
                int m = 0;
                while (m < mLength) {
                    if (parameterCount == methods[m].getNumberOfParameters() && methods[m].getElementName().equals(selector)) {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)allTypes[i].getAncestor(3);
                        IJavaElement element = root.isArchive() ? root : root.getParent();
                        focusSet.add(element);
                        if (superTypes == null) break;
                        superTypes.add(allTypes[i]);
                        break;
                    }
                    ++m;
                }
                ++i;
            }
            IJavaElement[] focuses = new IJavaElement[focusSet.elementSize];
            Object[] values = focusSet.values;
            int count = 0;
            int i2 = values.length;
            while (--i2 >= 0) {
                if (values[i2] == null) continue;
                focuses[count++] = (IJavaElement)values[i2];
            }
            return focuses;
        }
        if (focusElement == null) {
            return new IJavaElement[0];
        }
        return new IJavaElement[]{focusElement};
    }

    private void initializeIndexLocations() {
        IJavaElement focus;
        IPath[] projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        IndexManager manager = JavaModelManager.getIndexManager();
        LinkedHashSet<IndexLocation> locations = new LinkedHashSet<IndexLocation>();
        IJavaElement iJavaElement = focus = this.pattern instanceof ModulePattern ? null : MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            int i = 0;
            while (i < projectsAndJars.length) {
                IPath path = projectsAndJars[i];
                Object target = JavaModel.getTarget(path, false);
                if (target instanceof IFolder) {
                    path = ((IFolder)target).getFullPath();
                }
                locations.add(manager.computeIndexLocation(path));
                ++i;
            }
        } else {
            try {
                int length = projectsAndJars.length;
                JavaProject[] projectsCanSeeFocus = new JavaProject[length];
                SimpleSet visitedProjects = new SimpleSet(length);
                int projectIndex = 0;
                SimpleSet externalLibsToCheck = new SimpleSet(length);
                ObjectVector superTypes = new ObjectVector();
                IJavaElement[] focuses = IndexSelector.getFocusedElementsAndTypes(this.pattern, focus, superTypes);
                char[][][] focusQualifiedNames = null;
                boolean isAutoBuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
                if (isAutoBuilding && focus instanceof IJavaProject) {
                    focusQualifiedNames = this.getQualifiedNames(superTypes);
                }
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                int i = 0;
                while (i < length) {
                    IPath path = projectsAndJars[i];
                    JavaProject project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        int canSeeFocus = IndexSelector.canSeeFocus(focuses, project, focusQualifiedNames);
                        if (canSeeFocus == 0) {
                            locations.add(manager.computeIndexLocation(path));
                        }
                        if (canSeeFocus != 2) {
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        externalLibsToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && externalLibsToCheck.elementSize > 0) {
                    IClasspathEntry[] entries = projectsCanSeeFocus[i].getResolvedClasspath();
                    int j = entries.length;
                    while (--j >= 0) {
                        IPath path;
                        IClasspathEntry entry = entries[j];
                        if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                        Object target = JavaModel.getTarget(path, false);
                        if (target instanceof IFolder) {
                            path = ((IFolder)target).getFullPath();
                        }
                        locations.add(manager.computeIndexLocation(path));
                    }
                    ++i;
                }
                if (externalLibsToCheck.elementSize > 0) {
                    IJavaProject[] allProjects = model.getJavaProjects();
                    int i2 = 0;
                    int l = allProjects.length;
                    while (i2 < l && externalLibsToCheck.elementSize > 0) {
                        JavaProject project = (JavaProject)allProjects[i2];
                        if (!visitedProjects.includes(project)) {
                            IClasspathEntry[] entries = project.getResolvedClasspath();
                            int j = entries.length;
                            while (--j >= 0) {
                                IPath path;
                                IClasspathEntry entry = entries[j];
                                if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                                Object target = JavaModel.getTarget(path, false);
                                if (target instanceof IFolder) {
                                    path = ((IFolder)target).getFullPath();
                                }
                                locations.add(manager.computeIndexLocation(path));
                            }
                        }
                        ++i2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        locations.remove(null);
        this.indexLocations = locations.toArray(new IndexLocation[locations.size()]);
    }

    public IndexLocation[] getIndexLocations() {
        Optional<Set<String>> indexNamesResult;
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        IndexLocation[] filtered = this.indexLocations;
        if (this.pattern != null && this.pattern.indexQualifierQuery != null && this.pattern.indexQualifierQuery.length > 0 && (indexNamesResult = JavaModelManager.getIndexManager().findMatchingIndexNames(QualifierQuery.fromEncodedQuery(this.pattern.indexQualifierQuery))).isPresent()) {
            Set<String> indexNames = indexNamesResult.get();
            filtered = (IndexLocation[])Stream.of(this.indexLocations).filter(l -> indexNames.contains(l.fileName())).toArray(IndexLocation[]::new);
        }
        if (JobManager.VERBOSE) {
            Util.verbose(String.format("-> selected %s indexes out of total indexes %s after qualify filtering - %s", filtered.length, this.indexLocations.length, this.toString()));
        }
        return filtered;
    }

    private static IJavaProject getJavaProject(IPath path, IJavaModel model) {
        IJavaProject project;
        String lastSeg = path.lastSegment();
        if (lastSeg == null) {
            lastSeg = path.toOSString();
        }
        if ((project = model.getJavaProject(lastSeg)).exists()) {
            return project;
        }
        return null;
    }

    private char[][][] getQualifiedNames(ObjectVector types) {
        IType primaryType;
        int size = types.size;
        char[][][] focusQualifiedNames = null;
        IJavaElement javaElement = this.pattern.focus;
        int index = 0;
        while (javaElement != null && !(javaElement instanceof ITypeRoot)) {
            javaElement = javaElement.getParent();
        }
        if (javaElement != null && (primaryType = ((ITypeRoot)javaElement).findPrimaryType()) != null) {
            focusQualifiedNames = new char[size + 1][][];
            focusQualifiedNames[index++] = CharOperation.splitOn('.', primaryType.getFullyQualifiedName().toCharArray());
        }
        if (focusQualifiedNames == null) {
            focusQualifiedNames = new char[size][][];
        }
        int i = 0;
        while (i < size) {
            focusQualifiedNames[index++] = CharOperation.splitOn('.', ((IType)types.elementAt(i)).getFullyQualifiedName().toCharArray());
            ++i;
        }
        return focusQualifiedNames.length == 0 ? null : ReferenceCollection.internQualifiedNames(focusQualifiedNames, true);
    }
}

