/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.SecondaryTypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class BasicSearchEngine {
    private ICompilationUnit[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements) {
        return BasicSearchEngine.createJavaSearchScope(false, elements, true);
    }

    public static IJavaSearchScope createJavaSearchScope(boolean excludeTestCode, IJavaElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return BasicSearchEngine.createJavaSearchScope(excludeTestCode, elements, includeMask);
    }

    public static IJavaSearchScope createJavaSearchScope(boolean excludeTestCode, IJavaElement[] elements, int includeMask) {
        HashSet<IJavaElement> projectsToBeAdded = new HashSet<IJavaElement>(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaElement element = elements[i];
            if (element instanceof JavaProject) {
                projectsToBeAdded.add(element);
            }
            ++i;
        }
        JavaSearchScope scope = new JavaSearchScope(excludeTestCode);
        int i2 = 0;
        int length2 = elements.length;
        while (i2 < length2) {
            IJavaElement element = elements[i2];
            if (element != null) {
                try {
                    if (projectsToBeAdded.contains(element)) {
                        scope.add((JavaProject)element, includeMask, projectsToBeAdded);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            ++i2;
        }
        return scope;
    }

    public static IJavaSearchScope createWorkspaceScope() {
        return JavaModelManager.getJavaModelManager().getWorkspaceScope();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant();
    }

    private ICompilationUnit[] getWorkingCopies() {
        int length;
        ICompilationUnit[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    ICompilationUnit unit;
                    HashMap<IPath, ICompilationUnit> pathToCUs = new HashMap<IPath, ICompilationUnit>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new ICompilationUnit[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        ICompilationUnit[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            CompilationUnit copy = (CompilationUnit)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new ICompilationUnit[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        if (index != length && result != null) {
            ICompilationUnit[] iCompilationUnitArray = result;
            result = new ICompilationUnit[index];
            System.arraycopy(iCompilationUnitArray, 0, result, 0, index);
        }
        return result;
    }

    public void searchAllSecondaryTypeNames(IPackageFragmentRoot[] sourceFolders, final IRestrictedAccessTypeRequestor nameRequestor, boolean waitForIndexes, IProgressMonitor progressMonitor) throws JavaModelException {
        try {
            int copiesLength;
            if (VERBOSE) {
                Util.verbose("BasicSearchEngine.searchAllSecondaryTypeNames(IPackageFragmentRoot[], IRestrictedAccessTypeRequestor, boolean, IProgressMonitor)");
                StringBuilder buffer = new StringBuilder("\t- source folders: ");
                int length = sourceFolders.length;
                int i = 0;
                while (i < length) {
                    if (i == 0) {
                        buffer.append('[');
                    } else {
                        buffer.append(',');
                    }
                    buffer.append(sourceFolders[i].getElementName());
                    ++i;
                }
                buffer.append("]\n\t- waitForIndexes: ");
                buffer.append(waitForIndexes);
                Util.verbose(buffer.toString());
            }
            IndexManager indexManager = JavaModelManager.getIndexManager();
            SecondaryTypeDeclarationPattern pattern = new SecondaryTypeDeclarationPattern();
            final HashSet<String> workingCopyPaths = new HashSet<String>();
            String workingCopyPath = null;
            ICompilationUnit[] copies = this.getWorkingCopies();
            int n = copiesLength = copies == null ? 0 : copies.length;
            if (copies != null) {
                if (copiesLength == 1) {
                    workingCopyPath = copies[0].getPath().toString();
                } else {
                    int i = 0;
                    while (i < copiesLength) {
                        ICompilationUnit workingCopy = copies[i];
                        workingCopyPaths.add(workingCopy.getPath().toString());
                        ++i;
                    }
                }
            }
            final String singleWkcpPath = workingCopyPath;
            IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

                @Override
                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                    if (!record.secondary) {
                        return true;
                    }
                    if (record.enclosingTypeNames == IIndexConstants.ONE_ZERO_CHAR) {
                        return true;
                    }
                    switch (copiesLength) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (!singleWkcpPath.equals(documentPath)) break;
                            return true;
                        }
                        default: {
                            if (!workingCopyPaths.contains(documentPath)) break;
                            return true;
                        }
                    }
                    AccessRestriction accessRestriction = null;
                    if (access != null) {
                        int pkgLength = record.pkg == null || record.pkg.length == 0 ? 0 : record.pkg.length + 1;
                        int nameLength = record.simpleName == null ? 0 : record.simpleName.length;
                        char[] path = new char[pkgLength + nameLength];
                        int pos = 0;
                        if (pkgLength > 0) {
                            System.arraycopy(record.pkg, 0, path, pos, pkgLength - 1);
                            CharOperation.replace(path, '.', '/');
                            path[pkgLength - 1] = 47;
                            pos += pkgLength;
                        }
                        if (nameLength > 0) {
                            System.arraycopy(record.simpleName, 0, path, pos, nameLength);
                            pos += nameLength;
                        }
                        if (pos > 0) {
                            accessRestriction = access.getViolatedRestriction(path);
                        }
                    }
                    nameRequestor.acceptType(record.modifiers, record.pkg, record.simpleName, record.enclosingTypeNames, documentPath, accessRestriction);
                    return true;
                }
            };
            try {
                SubMonitor subMonitor = SubMonitor.convert(progressMonitor, Messages.engine_searching, 100);
                indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), BasicSearchEngine.createJavaSearchScope(sourceFolders), searchRequestor), waitForIndexes ? 3 : 1, subMonitor.split(100));
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }
}

