/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceRefElementInfo;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;

public abstract class SourceRefElement
extends JavaElement
implements ISourceReference {
    public int occurrenceCount = 1;

    protected SourceRefElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void closing(Object info) throws JavaModelException {
    }

    @Override
    protected Object createElementInfo() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceRefElement)) {
            return false;
        }
        return this.occurrenceCount == ((SourceRefElement)o).occurrenceCount && super.equals(o);
    }

    @Override
    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws JavaModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent == null) {
            return;
        }
        JavaElementInfo openableParentInfo = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(openableParent);
        if (openableParentInfo == null) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    public IAnnotation[] getAnnotations() throws JavaModelException {
        AnnotatableInfo info = (AnnotatableInfo)this.getElementInfo();
        return info.annotations;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getAncestor(5);
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
        }
        return this;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        super.getHandleMemento(buff);
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    public IJavaElement getHandleUpdatingCountFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        this.occurrenceCount = Integer.parseInt(memento.nextToken());
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    @Override
    public IOpenable getOpenableParent() {
        IJavaElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)((Object)current);
            }
            current = current.getParent();
        }
        return null;
    }

    @Override
    public IPath getPath() {
        return this.getParent().getPath();
    }

    @Override
    public IResource resource() {
        return this.getParent().resource();
    }

    @Override
    public String getSource() throws JavaModelException {
        IOpenable openable = this.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        SourceRefElementInfo info = (SourceRefElementInfo)this.getElementInfo();
        return info.getSourceRange();
    }

    @Override
    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getParent().getUnderlyingResource();
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        super.toStringName(buffer);
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }
}

