/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LambdaFactory;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.MemberElementInfo;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;

public abstract class Member
extends SourceRefElement
implements IMember {
    protected Member(JavaElement parent) {
        super(parent);
    }

    @Override
    public IClassFile getClassFile() {
        JavaElement element = this.getParent();
        while (element instanceof Member) {
            element = element.getParent();
        }
        if (element instanceof IClassFile) {
            return (IClassFile)((Object)element);
        }
        return null;
    }

    @Override
    public IType getDeclaringType() {
        JavaElement parentElement = this.getParent();
        if (parentElement.getElementType() == 7) {
            return (IType)((Object)parentElement);
        }
        return null;
    }

    @Override
    public int getFlags() throws JavaModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case ')': {
                if (!memento.hasMoreTokens() || memento.nextToken() != MementoTokenizer.STRING) {
                    return this;
                }
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String interphase = memento.nextToken();
                if (!memento.hasMoreTokens() || memento.nextToken() != MementoTokenizer.COUNT) {
                    return this;
                }
                int sourceStart = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens() || memento.nextToken() != MementoTokenizer.COUNT) {
                    return this;
                }
                int sourceEnd = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens() || memento.nextToken() != MementoTokenizer.COUNT) {
                    return this;
                }
                int arrowPosition = Integer.parseInt(memento.nextToken());
                LambdaExpression expression = LambdaFactory.createLambdaExpression(this, interphase, sourceStart, sourceEnd, arrowPosition);
                if (!memento.hasMoreTokens() || (token = memento.nextToken()) != MementoTokenizer.LAMBDA_METHOD) {
                    return expression;
                }
                return expression.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '|' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                JavaElement type = (JavaElement)((Object)this.getType(typeName, 1));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case '@': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String varName = memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int declarationStart = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int declarationEnd = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int nameStart = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int nameEnd = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeSignature = memento.nextToken();
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int flags = Integer.parseInt(memento.nextToken());
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                boolean isParameter = Boolean.parseBoolean(memento.nextToken());
                return new LocalVariable(this, varName, declarationStart, declarationEnd, nameStart, nameEnd, typeSignature, null, flags, isParameter);
            }
            case ']': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeParameterName = memento.nextToken();
                TypeParameter typeParameter = new TypeParameter(this, typeParameterName);
                return typeParameter.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '}': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String annotationName = memento.nextToken();
                Annotation annotation = new Annotation(this, annotationName);
                return annotation.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '[';
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Member getOuterMostLocalContext() {
        Member member = this;
        Member lastLocalContext = null;
        while (true) {
            void var1_2;
            switch (var1_2.getElementType()) {
                case 5: 
                case 6: {
                    return lastLocalContext;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    lastLocalContext = (Member)var1_2;
                }
            }
            IJavaElement iJavaElement = var1_2.getParent();
        }
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return new SourceRange(info.getNameSourceStart(), info.getNameSourceEnd() - info.getNameSourceStart() + 1);
    }

    @Override
    public IType getType(String typeName, int count) {
        if (this.isBinary()) {
            throw new IllegalArgumentException("Not a source member " + this.toStringWithAncestors());
        }
        SourceType type = new SourceType(this, typeName);
        type.occurrenceCount = count;
        return type;
    }

    public ITypeRoot getTypeRoot() {
        IJavaElement element = this.getParent();
        while (element instanceof IMember) {
            element = element.getParent();
        }
        return (ITypeRoot)element;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.getClassFile() != null;
    }
}

