/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.Util;

public class Buffer
implements IBuffer {
    protected IFile file;
    protected int flags;
    protected char[] contents;
    protected ListenerList<IBufferChangedListener> changeListeners;
    protected IOpenable owner;
    protected int gapStart = -1;
    protected int gapEnd = -1;
    protected Object lock = new Object();

    protected Buffer(IFile file, IOpenable owner, boolean readOnly) {
        this.file = file;
        this.owner = owner;
        if (file == null) {
            this.setReadOnly(readOnly);
        }
    }

    @Override
    public synchronized void addBufferChangedListener(IBufferChangedListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ListenerList();
        }
        this.changeListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        BufferChangedEvent event = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            event = new BufferChangedEvent(this, 0, 0, null);
            this.contents = null;
            this.flags |= 4;
        }
        this.notifyChanged(event);
        object = this;
        synchronized (object) {
            this.changeListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getCharacters() {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.contents != null) break block5;
                return null;
            }
            if (this.gapStart < 0) {
                return this.contents;
            }
            int length = this.contents.length;
            char[] newContents = new char[length - this.gapEnd + this.gapStart];
            System.arraycopy(this.contents, 0, newContents, 0, this.gapStart);
            System.arraycopy(this.contents, this.gapEnd, newContents, this.gapStart, length - this.gapEnd);
            return newContents;
        }
    }

    @Override
    public String getContents() {
        char[] chars = this.getCharacters();
        if (chars == null) {
            return null;
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.contents != null) break block4;
                return -1;
            }
            int length = this.gapEnd - this.gapStart;
            return this.contents.length - length;
        }
    }

    @Override
    public IOpenable getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText(int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                if (this.contents != null) break block6;
                return "";
            }
            if (offset + length < this.gapStart) {
                return new String(this.contents, offset, length);
            }
            if (this.gapStart < offset) {
                int gapLength = this.gapEnd - this.gapStart;
                return new String(this.contents, offset + gapLength, length);
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.contents, offset, this.gapStart - offset);
            buf.append(this.contents, this.gapEnd, offset + length - this.gapStart);
            return buf.toString();
        }
    }

    @Override
    public boolean hasUnsavedChanges() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isClosed() {
        return (this.flags & 4) != 0;
    }

    public boolean isReadOnly() {
        return (this.flags & 2) != 0;
    }

    protected void notifyChanged(final BufferChangedEvent event) {
        ListenerList<IBufferChangedListener> listeners = this.changeListeners;
        if (listeners != null) {
            for (final IBufferChangedListener listener : listeners) {
                SafeRunner.run(new ISafeRunnable(){

                    @Override
                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of buffer change notification");
                    }

                    @Override
                    public void run() throws Exception {
                        listener.bufferChanged(event);
                    }
                });
            }
        }
    }

    @Override
    public synchronized void removeBufferChangedListener(IBufferChangedListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(char[] newContents) {
        if (this.contents == null) {
            Object object = this.lock;
            synchronized (object) {
                this.contents = newContents;
                this.flags &= 0xFFFFFFFE;
            }
            return;
        }
        if (!this.isReadOnly()) {
            String string = null;
            if (newContents != null) {
                string = new String(newContents);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.contents == null) {
                    return;
                }
                this.contents = newContents;
                this.flags |= 1;
                this.gapStart = -1;
                this.gapEnd = -1;
            }
            BufferChangedEvent event = new BufferChangedEvent(this, 0, this.getLength(), string);
            this.notifyChanged(event);
        }
    }

    @Override
    public void setContents(String newContents) {
        this.setContents(newContents.toCharArray());
    }

    protected void setReadOnly(boolean readOnly) {
        this.flags = readOnly ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Owner: " + ((JavaElement)((Object)this.owner)).toStringWithAncestors());
        buffer.append("\nHas unsaved changes: " + this.hasUnsavedChanges());
        buffer.append("\nIs readonly: " + this.isReadOnly());
        buffer.append("\nIs closed: " + this.isClosed());
        buffer.append("\nContents:\n");
        char[] charContents = this.getCharacters();
        if (charContents == null) {
            buffer.append("<null>");
        } else {
            int length = charContents.length;
            int i = 0;
            while (i < length) {
                char c = charContents[i];
                switch (c) {
                    case '\n': {
                        buffer.append("\\n\n");
                        break;
                    }
                    case '\r': {
                        if (i < length - 1 && this.contents[i + 1] == '\n') {
                            buffer.append("\\r\\n\n");
                            ++i;
                            break;
                        }
                        buffer.append("\\r\n");
                        break;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
                ++i;
            }
        }
        return buffer.toString();
    }
}

