/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.SourceMapper;

public class BinaryModule
extends BinaryMember
implements AbstractModule {
    private IBinaryModule info;

    public BinaryModule(JavaElement parent, String name) {
        super(parent, name);
    }

    public BinaryModule(JavaElement parent, IBinaryModule info) {
        super(parent, String.valueOf(info.name()));
        this.info = info;
    }

    @Override
    public IModule getModuleInfo() throws JavaModelException {
        if (this.info == null) {
            ModularClassFile classFile = (ModularClassFile)this.getParent();
            this.info = classFile.getBinaryModuleInfo();
        }
        return this.info;
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryModule moduleInfo = (IBinaryModule)this.getModuleInfo();
        IBinaryAnnotation[] binaryAnnotations = moduleInfo.getAnnotations();
        long tagBits = moduleInfo.getTagBits() & 0xFFFFBFFFFFFFFFFFL;
        return this.getAnnotations(binaryAnnotations, tagBits);
    }

    @Override
    public IJavaElement[] getChildren() throws JavaModelException {
        return NO_ELEMENTS;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public int getFlags() throws JavaModelException {
        if (this.getModuleInfo().isOpen()) {
            return 32;
        }
        return 0;
    }

    @Override
    public char getHandleMementoDelimiter() {
        return '`';
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            ((ModularClassFile)this.getClassFile()).getBuffer();
            return mapper.getSourceRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }
}

