/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.compiler.util.CharArray;
import org.eclipse.jdt.internal.compiler.util.CharArrayMapper;

public final class CharArrayHashMap<V>
implements Serializable,
CharArrayMapper<V> {
    private final HashMap<CharArray, V> map;

    public CharArrayHashMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    @Override
    public Collection<char[]> keys() {
        return this.map.keySet().stream().map(s -> s.getKey()).collect(Collectors.toList());
    }

    @Override
    public V get(char[] key) {
        return this.map.get(new CharArray(key));
    }

    @Override
    public V put(char[] key, V value) {
        return this.map.put(new CharArray(key), value);
    }

    public String toString() {
        return CharArrayMapper.toString(this);
    }
}

