/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;

public class TypeDeclaration
extends AbstractTypeDeclaration {
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = TypeDeclaration.internalJavadocPropertyFactory(TypeDeclaration.class);
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = TypeDeclaration.internalModifiersPropertyFactory(TypeDeclaration.class);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = TypeDeclaration.internalModifiers2PropertyFactory(TypeDeclaration.class);
    public static final SimplePropertyDescriptor INTERFACE_PROPERTY = new SimplePropertyDescriptor(TypeDeclaration.class, "interface", Boolean.TYPE, true);
    public static final ChildPropertyDescriptor NAME_PROPERTY = TypeDeclaration.internalNamePropertyFactory(TypeDeclaration.class);
    public static final ChildPropertyDescriptor SUPERCLASS_PROPERTY = new ChildPropertyDescriptor(TypeDeclaration.class, "superclass", Name.class, false, false);
    public static final ChildListPropertyDescriptor SUPER_INTERFACES_PROPERTY = new ChildListPropertyDescriptor(TypeDeclaration.class, "superInterfaces", Name.class, false);
    public static final ChildPropertyDescriptor SUPERCLASS_TYPE_PROPERTY = new ChildPropertyDescriptor(TypeDeclaration.class, "superclassType", Type.class, false, false);
    public static final ChildListPropertyDescriptor SUPER_INTERFACE_TYPES_PROPERTY = new ChildListPropertyDescriptor(TypeDeclaration.class, "superInterfaceTypes", Type.class, false);
    public static final ChildListPropertyDescriptor TYPE_PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(TypeDeclaration.class, "typeParameters", TypeParameter.class, false);
    public static final ChildListPropertyDescriptor BODY_DECLARATIONS_PROPERTY = TypeDeclaration.internalBodyDeclarationPropertyFactory(TypeDeclaration.class);
    public static final ChildListPropertyDescriptor PERMITS_TYPES_PROPERTY = new ChildListPropertyDescriptor(TypeDeclaration.class, "permitsTypes", Type.class, false);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private static final List PROPERTY_DESCRIPTORS_15;
    private boolean isInterface = false;
    private ASTNode.NodeList typeParameters = null;
    private Name optionalSuperclassName = null;
    private ASTNode.NodeList superInterfaceNames = null;
    private Type optionalSuperclassType = null;
    private ASTNode.NodeList superInterfaceTypes = null;
    private ASTNode.NodeList permittedTypes = null;
    private int restrictedIdentifierStartPosition = -1;

    static {
        ArrayList propertyList = new ArrayList(8);
        TypeDeclaration.createPropertyList(TypeDeclaration.class, propertyList);
        TypeDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        TypeDeclaration.addProperty(MODIFIERS_PROPERTY, propertyList);
        TypeDeclaration.addProperty(INTERFACE_PROPERTY, propertyList);
        TypeDeclaration.addProperty(NAME_PROPERTY, propertyList);
        TypeDeclaration.addProperty(SUPERCLASS_PROPERTY, propertyList);
        TypeDeclaration.addProperty(SUPER_INTERFACES_PROPERTY, propertyList);
        TypeDeclaration.addProperty(BODY_DECLARATIONS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = TypeDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(9);
        TypeDeclaration.createPropertyList(TypeDeclaration.class, propertyList);
        TypeDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        TypeDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        TypeDeclaration.addProperty(INTERFACE_PROPERTY, propertyList);
        TypeDeclaration.addProperty(NAME_PROPERTY, propertyList);
        TypeDeclaration.addProperty(TYPE_PARAMETERS_PROPERTY, propertyList);
        TypeDeclaration.addProperty(SUPERCLASS_TYPE_PROPERTY, propertyList);
        TypeDeclaration.addProperty(SUPER_INTERFACE_TYPES_PROPERTY, propertyList);
        TypeDeclaration.addProperty(BODY_DECLARATIONS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = TypeDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(10);
        TypeDeclaration.createPropertyList(TypeDeclaration.class, propertyList);
        TypeDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        TypeDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        TypeDeclaration.addProperty(INTERFACE_PROPERTY, propertyList);
        TypeDeclaration.addProperty(NAME_PROPERTY, propertyList);
        TypeDeclaration.addProperty(TYPE_PARAMETERS_PROPERTY, propertyList);
        TypeDeclaration.addProperty(SUPERCLASS_TYPE_PROPERTY, propertyList);
        TypeDeclaration.addProperty(SUPER_INTERFACE_TYPES_PROPERTY, propertyList);
        TypeDeclaration.addProperty(PERMITS_TYPES_PROPERTY, propertyList);
        TypeDeclaration.addProperty(BODY_DECLARATIONS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_15 = TypeDeclaration.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (DOMASTUtil.isFeatureSupportedinAST(apiLevel, 512)) {
            return PROPERTY_DESCRIPTORS_15;
        }
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    TypeDeclaration(AST ast) {
        super(ast);
        if (ast.apiLevel == 2) {
            this.superInterfaceNames = new ASTNode.NodeList(SUPER_INTERFACES_PROPERTY);
        }
        if (ast.apiLevel >= 3) {
            this.typeParameters = new ASTNode.NodeList(TYPE_PARAMETERS_PROPERTY);
            this.superInterfaceTypes = new ASTNode.NodeList(SUPER_INTERFACE_TYPES_PROPERTY);
        }
        if (DOMASTUtil.isFeatureSupportedinAST(ast, 512)) {
            this.permittedTypes = new ASTNode.NodeList(PERMITS_TYPES_PROPERTY);
        }
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return TypeDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.internalSetModifiers(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == INTERFACE_PROPERTY) {
            if (get) {
                return this.isInterface();
            }
            this.setInterface(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((Javadoc)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == SUPERCLASS_PROPERTY) {
            if (get) {
                return this.getSuperclass();
            }
            this.setSuperclass((Name)child);
            return null;
        }
        if (property == SUPERCLASS_TYPE_PROPERTY) {
            if (get) {
                return this.getSuperclassType();
            }
            this.setSuperclassType((Type)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == TYPE_PARAMETERS_PROPERTY) {
            return this.typeParameters();
        }
        if (property == SUPER_INTERFACES_PROPERTY) {
            return this.superInterfaces();
        }
        if (property == SUPER_INTERFACE_TYPES_PROPERTY) {
            return this.superInterfaceTypes();
        }
        if (property == PERMITS_TYPES_PROPERTY) {
            return this.permittedTypes();
        }
        if (property == BODY_DECLARATIONS_PROPERTY) {
            return this.bodyDeclarations();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalModifiers2Property() {
        return MODIFIERS2_PROPERTY;
    }

    @Override
    final SimplePropertyDescriptor internalModifiersProperty() {
        return MODIFIERS_PROPERTY;
    }

    @Override
    final ChildPropertyDescriptor internalNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalBodyDeclarationsProperty() {
        return BODY_DECLARATIONS_PROPERTY;
    }

    @Override
    final int getNodeType0() {
        return 55;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel == 2) {
                this.acceptChild(visitor, this.getJavadoc());
                this.acceptChild(visitor, this.getName());
                this.acceptChild(visitor, this.getSuperclass());
                this.acceptChildren(visitor, this.superInterfaceNames);
                this.acceptChildren(visitor, this.bodyDeclarations);
            }
            if (this.ast.apiLevel >= 3) {
                this.acceptChild(visitor, this.getJavadoc());
                this.acceptChildren(visitor, this.modifiers);
                this.acceptChild(visitor, this.getName());
                this.acceptChildren(visitor, this.typeParameters);
                this.acceptChild(visitor, this.getSuperclassType());
                this.acceptChildren(visitor, this.superInterfaceTypes);
                this.acceptChildren(visitor, this.bodyDeclarations);
            }
            if (DOMASTUtil.isFeatureSupportedinAST(this.getAST(), 512)) {
                this.acceptChildren(visitor, this.permittedTypes);
            }
        }
        visitor.endVisit(this);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        this.preValueChange(INTERFACE_PROPERTY);
        this.isInterface = isInterface;
        this.postValueChange(INTERFACE_PROPERTY);
    }

    public List typeParameters() {
        if (this.typeParameters == null) {
            this.unsupportedIn2();
        }
        return this.typeParameters;
    }

    public Name getSuperclass() {
        return this.internalGetSuperclass();
    }

    final Name internalGetSuperclass() {
        this.supportedOnlyIn2();
        return this.optionalSuperclassName;
    }

    public Type getSuperclassType() {
        this.unsupportedIn2();
        return this.optionalSuperclassType;
    }

    public void setSuperclass(Name superclassName) {
        this.internalSetSuperclass(superclassName);
    }

    final void internalSetSuperclass(Name superclassName) {
        this.supportedOnlyIn2();
        Name oldChild = this.optionalSuperclassName;
        this.preReplaceChild(oldChild, superclassName, SUPERCLASS_PROPERTY);
        this.optionalSuperclassName = superclassName;
        this.postReplaceChild(oldChild, superclassName, SUPERCLASS_PROPERTY);
    }

    public void setSuperclassType(Type superclassType) {
        this.unsupportedIn2();
        Type oldChild = this.optionalSuperclassType;
        this.preReplaceChild(oldChild, superclassType, SUPERCLASS_TYPE_PROPERTY);
        this.optionalSuperclassType = superclassType;
        this.postReplaceChild(oldChild, superclassType, SUPERCLASS_TYPE_PROPERTY);
    }

    public List superInterfaces() {
        return this.internalSuperInterfaces();
    }

    final List internalSuperInterfaces() {
        if (this.superInterfaceNames == null) {
            this.supportedOnlyIn2();
        }
        return this.superInterfaceNames;
    }

    public List superInterfaceTypes() {
        if (this.superInterfaceTypes == null) {
            this.unsupportedIn2();
        }
        return this.superInterfaceTypes;
    }

    public List permittedTypes() {
        if (this.permittedTypes == null) {
            this.unsupportedBelow17();
        }
        return this.permittedTypes;
    }

    @Override
    ITypeBinding internalResolveBinding() {
        return this.ast.getBindingResolver().resolveType(this);
    }

    public void setRestrictedIdentifierStartPosition(int restrictedIdentifierStartPosition) {
        if (restrictedIdentifierStartPosition < 0) {
            throw new IllegalArgumentException();
        }
        this.checkModifiable();
        this.restrictedIdentifierStartPosition = restrictedIdentifierStartPosition;
    }
}

