/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.util.ClassFileReader;

public class ToolFactory {
    public static final int M_FORMAT_NEW = 0;
    public static final int M_FORMAT_EXISTING = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(IClassFile classfile, int decodingFlag) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classfile.getAncestor(3);
        if (root == null) return null;
        try {
            IClassFileReader iClassFileReader;
            if (root instanceof JarPackageFragmentRoot) {
                String archiveName = null;
                ZipFile jar = null;
                try {
                    jar = ((JarPackageFragmentRoot)root).getJar();
                    archiveName = jar.getName();
                }
                finally {
                    JavaModelManager.getJavaModelManager().closeZipFile(jar);
                }
                PackageFragment packageFragment = (PackageFragment)classfile.getParent();
                String classFileName = classfile.getElementName();
                String entryName = org.eclipse.jdt.internal.core.util.Util.concatWith(packageFragment.names, classFileName, '/');
                return ToolFactory.createDefaultClassFileReader(archiveName, entryName, decodingFlag);
            }
            InputStream in = null;
            try {
                in = ((IFile)((JavaElement)((Object)classfile)).resource()).getContents();
                iClassFileReader = ToolFactory.createDefaultClassFileReader(in, decodingFlag);
                if (in == null) return iClassFileReader;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return iClassFileReader;
            }
            catch (IOException iOException) {}
            return iClassFileReader;
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static IClassFileReader createDefaultClassFileReader(InputStream stream, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getInputStreamAsByteArray(stream), decodingFlag);
        }
        catch (IOException | ClassFormatException exception) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static IClassFileReader createDefaultClassFileReader(String zipFileName, String zipEntryName, int decodingFlag) {
        ClassFileReader classFileReader;
        ZipFile zipFile;
        block22: {
            ZipEntry zipEntry;
            block20: {
                block21: {
                    block18: {
                        block19: {
                            zipFile = null;
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [ToolFactory.createDefaultClassFileReader()] Creating ZipFile on " + zipFileName);
                            }
                            if ((zipEntry = (zipFile = new ZipFile(zipFileName)).getEntry(zipEntryName)) != null) break block18;
                            if (zipFile == null) break block19;
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return null;
                    }
                    if (zipEntryName.toLowerCase().endsWith(".class")) break block20;
                    if (zipFile == null) break block21;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            byte[] classFileBytes = Util.getZipEntryByteContent(zipEntry, zipFile);
            classFileReader = new ClassFileReader(classFileBytes, decodingFlag);
            if (zipFile == null) break block22;
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
        catch (IOException | ClassFormatException exception) {
            block23: {
                try {
                    if (zipFile == null) break block23;
                }
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

