/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobGroup;

public abstract class Job
extends InternalJob {
    public static final IStatus ASYNC_FINISH = new Status(0, "org.eclipse.core.jobs", 1, "", null);

    public static final IJobManager getJobManager() {
        return manager;
    }

    public static Job create(String name, final ICoreRunnable runnable) {
        return new Job(name){

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    runnable.run(monitor);
                }
                catch (CoreException e) {
                    IStatus st = e.getStatus();
                    return new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public Job(String name) {
        super(name);
    }

    @Override
    public final void addJobChangeListener(IJobChangeListener listener) {
        super.addJobChangeListener(listener);
    }

    @Override
    public boolean belongsTo(Object family) {
        return false;
    }

    @Override
    public final boolean cancel() {
        return super.cancel();
    }

    @Override
    protected void canceling() {
    }

    @Override
    public final String getName() {
        return super.getName();
    }

    @Override
    public final int getPriority() {
        return super.getPriority();
    }

    @Override
    public final IStatus getResult() {
        return super.getResult();
    }

    @Override
    public final ISchedulingRule getRule() {
        return super.getRule();
    }

    @Override
    public final int getState() {
        return super.getState();
    }

    @Override
    public final Thread getThread() {
        return super.getThread();
    }

    @Override
    public final JobGroup getJobGroup() {
        return super.getJobGroup();
    }

    @Override
    public final boolean isBlocking() {
        return super.isBlocking();
    }

    @Override
    public final boolean isSystem() {
        return super.isSystem();
    }

    @Override
    public final void join() throws InterruptedException {
        super.join();
    }

    @Override
    public final void removeJobChangeListener(IJobChangeListener listener) {
        super.removeJobChangeListener(listener);
    }

    @Override
    protected abstract IStatus run(IProgressMonitor var1);

    public final void schedule() {
        super.schedule(0L);
    }

    @Override
    public final void schedule(long delay) {
        super.schedule(delay);
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
    }

    @Override
    public final void setPriority(int priority) {
        super.setPriority(priority);
    }

    @Override
    public final void setRule(ISchedulingRule rule) {
        super.setRule(rule);
    }

    @Override
    public final void setSystem(boolean value) {
        super.setSystem(value);
    }

    @Override
    public final void setUser(boolean value) {
        super.setUser(value);
    }

    @Override
    public final void setThread(Thread thread) {
        super.setThread(thread);
    }

    public boolean shouldRun() {
        return true;
    }

    @Override
    public boolean shouldSchedule() {
        return true;
    }

    @Override
    public final boolean sleep() {
        return super.sleep();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public final void wakeUp() {
        super.wakeUp(0L);
    }

    @Override
    public final void wakeUp(long delay) {
        super.wakeUp(delay);
    }
}

