/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.BitMask;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.osgi.util.NLS;

class ResourceTree
implements IResourceTree {
    private boolean isValid = true;
    private final FileSystemResourceManager localManager;
    private ILock lock;
    private MultiStatus multistatus;
    private int updateFlags;

    public ResourceTree(FileSystemResourceManager localManager, ILock lock, MultiStatus status, int updateFlags) {
        this.localManager = localManager;
        this.lock = lock;
        this.multistatus = status;
        this.updateFlags = updateFlags;
    }

    public void addToLocalHistory(IFile file) {
        if (!FileSystemResourceManager.storeHistory(file)) {
            return;
        }
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!file.exists()) {
                return;
            }
            IFileStore store = this.localManager.getStore(file);
            IFileInfo fileInfo = store.fetchInfo();
            if (!fileInfo.exists()) {
                return;
            }
            this.localManager.getHistoryStore().addState(file.getFullPath(), store, fileInfo, false);
        }
        finally {
            this.lock.release();
        }
    }

    public void deletedFile(IFile file) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!file.exists()) {
                return;
            }
            try {
                ((Resource)((Object)file)).deleteResource(true, null);
            }
            catch (CoreException e) {
                String message = NLS.bind(Messages.resources_errorDeleting, file.getFullPath());
                ResourceStatus status = new ResourceStatus(4, file.getFullPath(), message, (Throwable)e);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void deletedFolder(IFolder folder) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!folder.exists()) {
                return;
            }
            try {
                ((Resource)((Object)folder)).deleteResource(true, null);
            }
            catch (CoreException e) {
                String message = NLS.bind(Messages.resources_errorDeleting, folder.getFullPath());
                ResourceStatus status = new ResourceStatus(4, folder.getFullPath(), message, (Throwable)e);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void deletedProject(IProject target) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!target.exists()) {
                return;
            }
            try {
                ((Project)target).deleteResource(false, null);
            }
            catch (CoreException e) {
                String message = NLS.bind(Messages.resources_errorDeleting, target.getFullPath());
                ResourceStatus status = new ResourceStatus(4, target.getFullPath(), message, (Throwable)e);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void failed(IStatus reason) {
        Assert.isLegal(this.isValid);
        this.multistatus.add(reason);
    }

    protected IStatus getStatus() {
        return this.multistatus;
    }

    private boolean internalDeleteFile(IFile file, int flags, IProgressMonitor monitor) {
        try {
            boolean inSync;
            boolean force;
            String message = NLS.bind(Messages.resources_deleting, file.getFullPath());
            monitor.beginTask(message, 100);
            Policy.checkCanceled(monitor);
            if (!file.exists()) {
                return true;
            }
            if (file.isLinked()) {
                this.deletedFile(file);
                return true;
            }
            IFileStore fileStore = this.localManager.getStore(file);
            boolean localExists = fileStore.fetchInfo().exists();
            if (!localExists) {
                this.deletedFile(file);
                return true;
            }
            boolean keepHistory = (flags & 2) != 0;
            boolean bl = force = (flags & 1) != 0;
            if (keepHistory) {
                this.addToLocalHistory(file);
            }
            monitor.worked(25);
            if (!force && !(inSync = this.isSynchronized(file, 0)) && localExists) {
                message = NLS.bind(Messages.localstore_resourceIsOutOfSync, file.getFullPath());
                ResourceStatus status = new ResourceStatus(274, file.getFullPath(), message);
                this.failed(status);
                return false;
            }
            monitor.worked(25);
            try {
                fileStore.delete(0, Policy.subMonitorFor(monitor, 25));
                this.deletedFile(file);
                return true;
            }
            catch (CoreException e) {
                message = NLS.bind(Messages.resources_couldnotDelete, fileStore.toString());
                ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message, (Throwable)e);
                this.failed(status);
                monitor.done();
                return false;
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean internalDeleteFolder(IFolder folder, int flags, IProgressMonitor monitor) {
        String message = NLS.bind(Messages.resources_deleting, folder.getFullPath());
        monitor.beginTask("", 100);
        monitor.subTask(message);
        Policy.checkCanceled(monitor);
        if (!folder.exists()) {
            return true;
        }
        if (folder.isLinked()) {
            this.deletedFolder(folder);
            return true;
        }
        IFileStore fileStore = this.localManager.getStore(folder);
        if (!fileStore.fetchInfo().exists()) {
            this.deletedFolder(folder);
            return true;
        }
        try {
            this.localManager.delete(folder, flags, Policy.subMonitorFor(monitor, 100));
        }
        catch (CoreException ce) {
            message = NLS.bind(Messages.localstore_couldnotDelete, folder.getFullPath());
            ResourceStatus status = new ResourceStatus(4, 273, folder.getFullPath(), message, (Throwable)ce);
            this.failed(status);
            return false;
        }
        return true;
    }

    private boolean internalDeleteProject(IProject project, int flags, IProgressMonitor monitor) {
        String[] children;
        IResource[] members = null;
        try {
            members = project.members(10);
        }
        catch (CoreException e) {
            String message = NLS.bind(Messages.resources_errorMembers, project.getFullPath());
            ResourceStatus status = new ResourceStatus(4, project.getFullPath(), message, (Throwable)e);
            this.failed(status);
            return false;
        }
        boolean deletedChildren = true;
        IResource[] iResourceArray = members;
        int n = members.length;
        int status = 0;
        while (status < n) {
            IResource member;
            IResource child = member = iResourceArray[status];
            switch (child.getType()) {
                case 1: {
                    if (".project".equals(child.getName())) break;
                    deletedChildren &= this.internalDeleteFile((IFile)child, flags, Policy.subMonitorFor(monitor, 100 / members.length));
                    break;
                }
                case 2: {
                    deletedChildren &= this.internalDeleteFolder((IFolder)child, flags, Policy.subMonitorFor(monitor, 100 / members.length));
                }
            }
            ++status;
        }
        IFileStore projectStore = this.localManager.getStore(project);
        if (!deletedChildren) {
            return false;
        }
        try {
            children = projectStore.childNames(0, null);
        }
        catch (CoreException coreException) {
            children = new String[]{};
        }
        boolean force = BitMask.isSet(flags, 1);
        if (!(force || children.length == 1 && ".project".equals(children[0]))) {
            String message = NLS.bind(Messages.localstore_resourceIsOutOfSync, project.getName());
            this.failed(new ResourceStatus(274, project.getFullPath(), message));
            return false;
        }
        IResource file = project.findMember(".project");
        if (file == null) {
            IFileStore dotProject = projectStore.getChild(".project");
            try {
                dotProject.delete(0, null);
            }
            catch (CoreException e) {
                this.failed(e.getStatus());
            }
        } else {
            boolean deletedProjectFile = this.internalDeleteFile((IFile)file, flags, Policy.monitorFor(null));
            if (!deletedProjectFile) {
                String message = NLS.bind(Messages.resources_couldnotDelete, file.getFullPath());
                ResourceStatus status2 = new ResourceStatus(273, file.getFullPath(), message);
                this.failed(status2);
                return false;
            }
        }
        try {
            projectStore.delete(0, null);
            this.deletedProject(project);
            return true;
        }
        catch (CoreException e) {
            String message = NLS.bind(Messages.resources_couldnotDelete, projectStore.toString());
            ResourceStatus status3 = new ResourceStatus(273, project.getFullPath(), message, (Throwable)e);
            this.failed(status3);
            return false;
        }
    }

    private void safeRefresh(IResource resource) {
        try {
            resource.refreshLocal(2, new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ResourceStatus status = new ResourceStatus(4, 273, resource.getFullPath(), Messages.refresh_refreshErr, (Throwable)ce);
            this.failed(status);
        }
    }

    public boolean isSynchronized(IResource resource, int depth) {
        try {
            this.lock.acquire();
            boolean bl = this.localManager.isSynchronized(resource, depth);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    void makeInvalid() {
        this.isValid = false;
    }

    public void standardDeleteFile(IFile file, int flags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            this.internalDeleteFile(file, flags, monitor);
        }
        finally {
            this.lock.release();
        }
    }

    public void standardDeleteFolder(IFolder folder, int flags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            try {
                this.lock.acquire();
                this.internalDeleteFolder(folder, flags, monitor);
            }
            catch (OperationCanceledException oce) {
                this.safeRefresh(folder);
                throw oce;
            }
        }
        finally {
            this.lock.release();
            monitor.done();
        }
    }

    public void standardDeleteProject(IProject project, int flags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            String message = NLS.bind(Messages.resources_deleting, project.getFullPath());
            monitor.beginTask(message, 100);
            if (!project.exists()) {
                return;
            }
            boolean alwaysDeleteContent = (flags & 4) != 0;
            boolean neverDeleteContent = (flags & 8) != 0;
            boolean success = true;
            if (alwaysDeleteContent || project.isOpen() && !neverDeleteContent) {
                if (alwaysDeleteContent || this.isSynchronized(project, 2)) {
                    flags |= 1;
                }
                if (project.isOpen()) {
                    success = this.internalDeleteProject(project, flags, monitor);
                    if (!success) {
                        IFileStore store = this.localManager.getStore(project);
                        message = NLS.bind(Messages.resources_couldnotDelete, store.toString());
                        ResourceStatus status = new ResourceStatus(273, project.getFullPath(), message);
                        this.failed(status);
                    }
                    return;
                }
                try {
                    IFileStore[] members;
                    IFileStore projectStore = this.localManager.getStore(project);
                    IFileStore[] iFileStoreArray = members = projectStore.childStores(0, null);
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFileStore member = iFileStoreArray[n2];
                        if (!".project".equals(member.getName())) {
                            member.delete(0, Policy.subMonitorFor(monitor, 87 / members.length));
                        }
                        ++n2;
                    }
                    projectStore.delete(0, Policy.subMonitorFor(monitor, 87 / (members.length > 0 ? members.length : 1)));
                }
                catch (OperationCanceledException oce) {
                    this.safeRefresh(project);
                    throw oce;
                }
                catch (CoreException ce) {
                    message = NLS.bind(Messages.localstore_couldnotDelete, project.getFullPath());
                    ResourceStatus status = new ResourceStatus(4, 273, project.getFullPath(), message, (Throwable)ce);
                    this.failed(status);
                    this.lock.release();
                    monitor.done();
                    return;
                }
            }
            if (success) {
                this.deletedProject(project);
            } else {
                message = NLS.bind(Messages.localstore_couldnotDelete, project.getFullPath());
                ResourceStatus status = new ResourceStatus(273, project.getFullPath(), message);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
            monitor.done();
        }
    }
}

