/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Cache;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectContentTypes {
    private static final Preferences PROJECT_SCOPE = Platform.getPreferencesService().getRootNode().node("project");
    private Cache contentTypesPerProject;
    private Workspace workspace;

    static boolean usesContentTypePreferences(String projectName) {
        Preferences node;
        block7: {
            block6: {
                block5: {
                    node = PROJECT_SCOPE;
                    if (node.nodeExists(projectName)) break block5;
                    return false;
                }
                node = node.node(projectName);
                if (node.nodeExists("org.eclipse.core.runtime")) break block6;
                return false;
            }
            node = node.node("org.eclipse.core.runtime");
            if (node.nodeExists("content-types")) break block7;
            return false;
        }
        try {
            node = node.node("content-types");
            return node.getBoolean("enabled", false);
        }
        catch (IllegalArgumentException | IllegalStateException | BackingStoreException exception) {
            return false;
        }
    }

    public ProjectContentTypes(Workspace workspace) {
        this.workspace = workspace;
        this.contentTypesPerProject = new Cache(5, 30, 0.4);
    }

    public void contentTypePreferencesChanged(IProject project) {
        ProjectInfo info = (ProjectInfo)((Project)project).getResourceInfo(false, false);
        if (info != null) {
            info.setMatcher(null);
        }
    }

    private IContentTypeMatcher createMatcher(Project project) {
        ProjectContentTypeSelectionPolicy projectContentTypeSelectionPolicy = new ProjectContentTypeSelectionPolicy(project);
        return Platform.getContentTypeManager().getMatcher(projectContentTypeSelectionPolicy, projectContentTypeSelectionPolicy);
    }

    public IContentTypeMatcher getMatcherFor(Project project) throws CoreException {
        IContentTypeMatcher matcher;
        ProjectInfo info = (ProjectInfo)project.getResourceInfo(false, false);
        if (info == null) {
            project.checkAccessible(project.getFlags(null));
        }
        if ((matcher = info.getMatcher()) != null) {
            return matcher;
        }
        matcher = this.createMatcher(project);
        info.setMatcher(matcher);
        return matcher;
    }

    private class ProjectContentTypeSelectionPolicy
    implements IContentTypeManager.ISelectionPolicy,
    IScopeContext {
        private Project project;
        private IScopeContext projectScope;

        public ProjectContentTypeSelectionPolicy(Project project) {
            this.project = project;
            this.projectScope = new ProjectScope(project);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IScopeContext)) {
                return false;
            }
            IScopeContext other = (IScopeContext)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            IPath location = this.getLocation();
            return location == null ? other.getLocation() == null : location.equals(other.getLocation());
        }

        private IScopeContext getDelegate() {
            if (!ProjectContentTypes.usesContentTypePreferences(this.project.getName())) {
                return InstanceScope.INSTANCE;
            }
            return this.projectScope;
        }

        @Override
        public IPath getLocation() {
            return this.getDelegate().getLocation();
        }

        @Override
        public String getName() {
            return this.getDelegate().getName();
        }

        @Override
        public IEclipsePreferences getNode(String qualifier) {
            return this.getDelegate().getNode(qualifier);
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

