/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.internal.preferences.BundleDefaultPreferences;
import org.eclipse.core.internal.preferences.ConfigurationPreferences;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.InstancePreferences;
import org.eclipse.core.internal.preferences.LookupOrder;
import org.eclipse.core.internal.preferences.PreferenceServiceRegistryHelper;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.preferences.StringPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    private static String[] DEFAULT_DEFAULT_LOOKUP_ORDER = new String[]{"instance", "configuration", "default"};
    private static PreferencesService instance;
    static final RootPreferences root;
    private static final Map<String, LookupOrder> defaultsRegistry;
    private Object registryHelper = null;
    private final Map<String, EclipsePreferences> defaultScopes = new HashMap<String, EclipsePreferences>();
    private long lastStringSharing = 0L;

    static {
        root = new RootPreferences();
        defaultsRegistry = Collections.synchronizedMap(new HashMap());
    }

    private static IStatus createStatusError(String message, Exception e) {
        return new Status(4, "org.eclipse.equinox.preferences", 4, message, e);
    }

    public static PreferencesService getDefault() {
        if (instance == null) {
            instance = new PreferencesService();
        }
        return instance;
    }

    static void log(IStatus status) {
        RuntimeLog.log(status);
    }

    PreferencesService() {
        this.initializeDefaultScopes();
    }

    @Override
    public IStatus applyPreferences(IExportedPreferences preferences) throws CoreException {
        if (preferences == null) {
            throw new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Applying exported preferences: " + ((ExportedPreferences)preferences).toDeepDebugString());
        }
        MultiStatus result = new MultiStatus("org.eclipse.equinox.preferences", 0, PrefsMessages.preferences_applyProblems, null);
        IEclipsePreferences modifiedNode = this.firePreApplyEvent(preferences);
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            @Override
            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                String key;
                IEclipsePreferences globalNode = node.parent() == null ? root : (IEclipsePreferences)root.node(node.absolutePath());
                ExportedPreferences epNode = (ExportedPreferences)node;
                boolean removed = false;
                if (epNode.isExportRoot()) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("Found export root: " + epNode.absolutePath());
                    }
                    globalNode.removeNode();
                    removed = true;
                }
                String[] keys = epNode.properties.keys();
                if (removed) {
                    globalNode = (IEclipsePreferences)root.node(node.absolutePath());
                }
                ArrayList<String> propsToRemove = new ArrayList<String>();
                String[] stringArray = globalNode.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    key = stringArray[n2];
                    propsToRemove.add(key);
                    ++n2;
                }
                if (keys.length > 0) {
                    key = null;
                    String[] stringArray2 = keys;
                    int n3 = keys.length;
                    n = 0;
                    while (n < n3) {
                        String k;
                        key = k = stringArray2[n];
                        propsToRemove.remove(key);
                        key = key.intern();
                        String value = node.get(key, null);
                        if (value != null) {
                            if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                                PrefsMessages.message("Setting: " + globalNode.absolutePath() + '/' + key + '=' + value);
                            }
                            globalNode.put(key, value);
                        }
                        ++n;
                    }
                }
                String keyToRemove2 = null;
                for (String keyToRemove2 : propsToRemove) {
                    keyToRemove2 = keyToRemove2.intern();
                    if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                        PrefsMessages.message("Removing: " + globalNode.absolutePath() + '/' + keyToRemove2);
                    }
                    globalNode.remove(keyToRemove2);
                }
                return true;
            }
        };
        try {
            modifiedNode.accept(visitor);
        }
        catch (BackingStoreException e) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_applyProblems, e));
        }
        try {
            this.getRootNode().node(modifiedNode.absolutePath()).flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_saveProblems, e));
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Current list of all settings: " + ((EclipsePreferences)this.getRootNode()).toDeepDebugString());
        }
        this.lastStringSharing = 0L;
        this.shareStrings();
        return result;
    }

    private Properties convertFromLegacy(Properties properties) {
        Properties result = new Properties();
        String prefix = "/instance/";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            int index = key.indexOf(47);
            if (index == -1) {
                result.put(String.valueOf('@') + key, value);
                result.put(String.valueOf('!') + prefix + key, "");
                continue;
            }
            String path = key.substring(0, index);
            key = key.substring(index + 1);
            result.put(EclipsePreferences.encodePath(String.valueOf(prefix) + path, key), value);
        }
        return result;
    }

    private IExportedPreferences convertFromProperties(Properties properties) {
        IExportedPreferences result = ExportedPreferences.newRoot();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ExportedPreferences current;
            String path = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (path.charAt(0) == '!') {
                current = (ExportedPreferences)result.node(path.substring(1));
                current.setExportRoot();
                continue;
            }
            if (path.charAt(0) == '@') {
                current = (ExportedPreferences)result.node("instance").node(path.substring(1));
                current.setVersion(value);
                continue;
            }
            String[] decoded = EclipsePreferences.decodePath(path);
            path = decoded[0] == null ? "" : decoded[0];
            ExportedPreferences current2 = (ExportedPreferences)result.node(path);
            String key = decoded[1];
            current2.put(key, value);
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Converted preferences file to IExportedPreferences tree: " + ((ExportedPreferences)result).toDeepDebugString());
        }
        return result;
    }

    public WeakReference<Object> applyRuntimeDefaults(String name, WeakReference<Object> pluginReference) {
        if (this.registryHelper == null) {
            return null;
        }
        return ((PreferenceServiceRegistryHelper)this.registryHelper).applyRuntimeDefaults(name, pluginReference);
    }

    private void initializeDefaultScopes() {
        this.defaultScopes.put("bundle_defaults", new BundleDefaultPreferences());
        root.addChild("bundle_defaults", null);
        this.defaultScopes.put("default", new DefaultPreferences());
        root.addChild("default", null);
        this.defaultScopes.put("instance", new InstancePreferences());
        root.addChild("instance", null);
        this.defaultScopes.put("configuration", new ConfigurationPreferences());
        root.addChild("configuration", null);
    }

    public IEclipsePreferences createNode(String key) {
        IScope scope = this.defaultScopes.get(key);
        if (scope == null) {
            if (this.registryHelper == null) {
                return new EclipsePreferences(root, key);
            }
            return ((PreferenceServiceRegistryHelper)this.registryHelper).createNode(root, key);
        }
        return scope.create(root, key);
    }

    private IEclipsePreferences firePreApplyEvent(IEclipsePreferences tree) {
        if (this.registryHelper == null) {
            return tree;
        }
        final IEclipsePreferences[] result = new IEclipsePreferences[]{tree};
        ListenerList<PreferenceModifyListener> listeners = ((PreferenceServiceRegistryHelper)this.registryHelper).getModifyListeners();
        for (final PreferenceModifyListener listener : listeners) {
            ISafeRunnable job = new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                }

                @Override
                public void run() throws Exception {
                    result[0] = listener.preApply(result[0]);
                }
            };
            SafeRunner.run(job);
        }
        return result[0];
    }

    @Override
    public String get(String key, String defaultValue, Preferences[] nodes) {
        if (nodes == null) {
            return defaultValue;
        }
        Preferences[] preferencesArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            String result;
            Preferences node = preferencesArray[n2];
            if (node != null && (result = node.get(key, null)) != null) {
                return result;
            }
            ++n2;
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String qualifier, String key, boolean defaultValue, IScopeContext[] scopes) {
        String result = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : Boolean.valueOf(result);
    }

    public String[] getDefaultLookupOrder(String qualifier, String key) {
        LookupOrder order = defaultsRegistry.get(this.getRegistryKey(qualifier, key));
        return order == null ? null : order.getOrder();
    }

    public String[] getLookupOrder(String qualifier, String key) {
        String[] order = this.getDefaultLookupOrder(qualifier, key);
        if (order == null && key != null) {
            order = this.getDefaultLookupOrder(qualifier, null);
        }
        if (order == null) {
            order = DEFAULT_DEFAULT_LOOKUP_ORDER;
        }
        return order;
    }

    private Preferences[] getNodes(final String qualifier, String key, final IScopeContext[] contexts) {
        String[] order = this.getLookupOrder(qualifier, key);
        final String childPath = EclipsePreferences.makeRelative(EclipsePreferences.decodePath(key)[0]);
        final ArrayList result = new ArrayList();
        String[] stringArray = order;
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            final String scopeString = stringArray[n2];
            final AtomicReference error = new AtomicReference();
            SafeRunner.run(new ISafeRunnable(){
                private IScopeContext context;

                @Override
                public void run() throws Exception {
                    boolean found = false;
                    int j = 0;
                    while (contexts != null && j < contexts.length) {
                        Preferences node;
                        this.context = contexts[j];
                        if (this.context != null && this.context.getName().equals(scopeString) && (node = this.context.getNode(qualifier)) != null) {
                            found = true;
                            if (childPath != null) {
                                node = node.node(childPath);
                            }
                            result.add(node);
                        }
                        ++j;
                    }
                    if (!found) {
                        Preferences node = PreferencesService.this.getRootNode().node(scopeString).node(qualifier);
                        if (childPath != null) {
                            node = node.node(childPath);
                        }
                        result.add(node);
                    }
                    found = false;
                }

                @Override
                public void handleException(Throwable exception) {
                    if (this.context instanceof InstanceScope && exception instanceof IllegalStateException && Boolean.getBoolean("osgi.dataAreaRequiresExplicitInit")) {
                        error.set((IllegalStateException)exception);
                    } else {
                        PreferencesService.log(new Status(4, "org.eclipse.equinox.preferences", PrefsMessages.preferences_contextError, exception));
                    }
                }
            });
            IllegalStateException illegalState = (IllegalStateException)error.get();
            if (illegalState != null) {
                throw illegalState;
            }
            ++n2;
        }
        return result.toArray(new Preferences[result.size()]);
    }

    private String getRegistryKey(String qualifier, String key) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        if (key == null) {
            return qualifier;
        }
        return String.valueOf(qualifier) + '/' + key;
    }

    @Override
    public IEclipsePreferences getRootNode() {
        return root;
    }

    @Override
    public String getString(String qualifier, String key, String defaultValue, IScopeContext[] scopes) {
        return this.get(EclipsePreferences.decodePath(key)[1], defaultValue, this.getNodes(qualifier, key, scopes));
    }

    private boolean isLegacy(Properties properties) {
        return properties.getProperty("file_export_version") == null;
    }

    @Override
    public IExportedPreferences readPreferences(InputStream input) throws CoreException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Reading preferences from stream...");
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_importProblems, e));
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_importProblems, e));
            }
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
        if (properties.isEmpty()) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_invalidFileFormat, null));
        }
        if (this.isLegacy(properties)) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read legacy preferences file, converting to 3.0 format...");
            }
            properties = this.convertFromLegacy(properties);
        } else {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read preferences file.");
            }
            properties.remove("file_export_version");
        }
        return this.convertFromProperties(properties);
    }

    public void setRegistryHelper(Object registryHelper) {
        if (this.registryHelper != null && this.registryHelper != registryHelper) {
            ((PreferenceServiceRegistryHelper)this.registryHelper).stop();
        }
        this.registryHelper = registryHelper;
    }

    void shareStrings() {
        long now = System.currentTimeMillis();
        if (now - this.lastStringSharing < 300000L) {
            return;
        }
        StringPool pool = new StringPool();
        root.shareStrings(pool);
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            System.out.println("Preference string sharing saved: " + pool.getSavedStringCount());
        }
        this.lastStringSharing = now;
    }

    public String[] getDefaultDefaultLookupOrder() {
        return DEFAULT_DEFAULT_LOOKUP_ORDER;
    }

    public void setDefaultDefaultLookupOrder(String[] order) {
        if (order == null) {
            order = new String[]{};
        }
        DEFAULT_DEFAULT_LOOKUP_ORDER = order;
    }
}

