/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;

public final class FileStoreUtil {
    private static int comparePathUri(URI uri1, URI uri2) {
        if (uri1 == null && uri2 == null) {
            return 0;
        }
        int compare = FileStoreUtil.nullsLast(uri1, uri2);
        if (compare != 0) {
            return compare;
        }
        return FileStoreUtil.compareNormalisedUri(uri1.normalize(), uri2.normalize());
    }

    private static int compareNormalisedUri(URI uri1, URI uri2) {
        int c = FileStoreUtil.compareStringOrNull(uri1.getAuthority(), uri2.getAuthority());
        if (c != 0) {
            return c;
        }
        c = FileStoreUtil.compareStringOrNull(uri1.getScheme(), uri2.getScheme());
        if (c != 0) {
            return c;
        }
        c = FileStoreUtil.comparePathSegments(uri1.getPath(), uri2.getPath());
        if (c != 0) {
            return c;
        }
        c = FileStoreUtil.compareStringOrNull(uri1.getQuery(), uri2.getQuery());
        if (c != 0) {
            return c;
        }
        return c;
    }

    static int nullsLast(Object c1, Object c2) {
        if (c1 == null) {
            if (c2 == null) {
                return 0;
            }
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return 0;
    }

    public static int comparePathSegments(String p1, String p2) {
        int compare = FileStoreUtil.compareSlashFirst(p1, p2);
        if (compare != 0) {
            return compare;
        }
        int segmentCount1 = FileStoreUtil.countCharButNotAtEnd(p1, '/');
        int segmentCount2 = FileStoreUtil.countCharButNotAtEnd(p2, '/');
        compare = segmentCount1 - segmentCount2;
        return compare;
    }

    static int compareSlashFirst(String value, String other) {
        int len1 = value.length();
        int len2 = other.length();
        int lim = Math.min(len1, len2);
        int k = 0;
        while (k < lim) {
            char c2;
            char c1 = value.charAt(k);
            if (c1 != (c2 = other.charAt(k))) {
                if (c1 == '/') {
                    return -1;
                }
                if (c2 == '/') {
                    return 1;
                }
                return c1 - c2;
            }
            ++k;
        }
        if (value.endsWith("/")) {
            --len1;
        }
        if (other.endsWith("/")) {
            --len2;
        }
        return len1 - len2;
    }

    static int countCharButNotAtEnd(String str, char c) {
        int count = 0;
        int i = 0;
        while (i < str.length() - 1) {
            if (str.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int compareStringOrNull(String string1, String string2) {
        if (string1 == null) {
            if (string2 == null) {
                return 0;
            }
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        return string1.compareTo(string2);
    }

    public static int compareFileStore(IFileStore fileStore1, IFileStore fileStore2) {
        URI uri2;
        URI uri1;
        int compare = FileStoreUtil.compareStringOrNull(fileStore1.getFileSystem().getScheme(), fileStore2.getFileSystem().getScheme());
        if (compare != 0) {
            return compare;
        }
        try {
            uri1 = fileStore1.toURI();
        }
        catch (Exception exception) {
            uri1 = null;
        }
        try {
            uri2 = fileStore2.toURI();
        }
        catch (Exception exception) {
            uri2 = null;
        }
        return FileStoreUtil.comparePathUri(uri1, uri2);
    }
}

