/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.EventObject;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;

public class ResourceChangeEvent
extends EventObject
implements IResourceChangeEvent {
    private static final IMarkerDelta[] NO_MARKER_DELTAS = new IMarkerDelta[0];
    IResourceDelta delta;
    IResource resource;
    private int trigger = 0;
    int type;

    protected ResourceChangeEvent(Object source, int type, IResource resource) {
        super(source);
        this.resource = resource;
        this.type = type;
    }

    public ResourceChangeEvent(Object source, int type, int buildKind, IResourceDelta delta) {
        super(source);
        this.delta = delta;
        this.trigger = buildKind;
        this.type = type;
    }

    public int getBuildKind() {
        return this.trigger;
    }

    @Override
    public IResourceDelta getDelta() {
        return this.delta;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setDelta(IResourceDelta value) {
        this.delta = value;
    }

    public String toDebugString() {
        StringBuilder output = new StringBuilder();
        output.append("\nType: ");
        switch (this.type) {
            case 1: {
                output.append("POST_CHANGE");
                break;
            }
            case 2: {
                output.append("PRE_CLOSE");
                break;
            }
            case 4: {
                output.append("PRE_DELETE");
                break;
            }
            case 8: {
                output.append("PRE_BUILD");
                break;
            }
            case 16: {
                output.append("POST_BUILD");
                break;
            }
            case 32: {
                output.append("PRE_REFRESH");
                break;
            }
            default: {
                output.append("?");
            }
        }
        output.append("\nBuild kind: ");
        switch (this.trigger) {
            case 6: {
                output.append("FULL_BUILD");
                break;
            }
            case 9: 
            case 10: {
                output.append("INCREMENTAL_BUILD");
                break;
            }
            case 15: {
                output.append("CLEAN_BUILD");
                break;
            }
            default: {
                output.append(this.trigger);
            }
        }
        output.append("\nResource: " + (this.resource == null ? "null" : this.resource));
        output.append("\nDelta:" + (this.delta == null ? " null" : ((ResourceDelta)this.delta).toDeepDebugString()));
        return output.toString();
    }
}

