/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.srg2source.api.InputSupplier;
import net.minecraftforge.srg2source.api.OutputSupplier;

public class FolderSupplier
implements InputSupplier,
OutputSupplier {
    private final Path root;
    private final String sroot;
    private final Charset encoding;

    public static FolderSupplier create(Path root, Charset encoding) throws IOException {
        if (!Files.exists(root, new LinkOption[0])) {
            Files.createDirectories(root, new FileAttribute[0]);
        }
        return new FolderSupplier(root, encoding);
    }

    protected FolderSupplier(Path root, Charset encoding) {
        this.root = root;
        this.sroot = root.toAbsolutePath().toString();
        this.encoding = encoding;
    }

    @Override
    public OutputStream getOutput(String relPath) {
        try {
            Path parent;
            Path target = this.root.resolve(relPath);
            if (!Files.exists(target, new LinkOption[0]) && !Files.exists(parent = target.getParent(), new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            return Files.newOutputStream(target, new OpenOption[0]);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getInput(String relPath) {
        try {
            Path target = this.root.resolve(relPath);
            if (!Files.exists(target, new LinkOption[0])) {
                return null;
            }
            return Files.newInputStream(target, StandardOpenOption.READ);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<String> gatherAll(String endFilter) {
        try {
            return Files.walk(this.root, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this.root::relativize).map(Path::toString).filter(p -> p.endsWith(endFilter)).sorted().collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getRoot(String resource) {
        return this.sroot;
    }

    @Override
    public Charset getEncoding(String resource) {
        return this.encoding;
    }
}

