/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.mixin;

import net.minecraftforge.srg2source.extract.ExtractUtil;
import net.minecraftforge.srg2source.extract.MixinProcessor;
import net.minecraftforge.srg2source.mixin.AnnotationBase;
import net.minecraftforge.srg2source.mixin.MixinAnnotation;
import net.minecraftforge.srg2source.mixin.MixinInfo;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class Shadow
extends AnnotationBase {
    public Shadow(MixinProcessor processor) {
        super(processor, MixinAnnotation.SHADOW);
    }

    @Override
    public boolean process(MarkerAnnotation node) {
        ASTNode parent = node.getParent();
        if (parent.getNodeType() == 23) {
            FieldDeclaration fld = (FieldDeclaration)parent;
            for (VariableDeclarationFragment vdf : fld.fragments()) {
                IVariableBinding bind = vdf.resolveBinding();
                String owner = ExtractUtil.getInternalName(this.getFilename(), bind.getDeclaringClass(), parent);
                String name = bind.getName().toString();
                String desc = ExtractUtil.getTypeSignature(bind.getType());
                MixinInfo info = this.getInfo(owner);
                if (info == null) {
                    return this.error(node, "Invalid @Sadow on " + name + " owner " + owner + " has no @Mixin");
                }
                info.addShadow(name, desc, "shadow$");
            }
        } else if (parent.getNodeType() == 31) {
            MethodDeclaration mtd = (MethodDeclaration)parent;
            IMethodBinding bind = mtd.resolveBinding();
            String owner = ExtractUtil.getInternalName(this.getFilename(), bind.getDeclaringClass(), parent);
            String name = bind.getName().toString();
            String desc = ExtractUtil.getDescriptor(bind);
            MixinInfo info = this.getInfo(owner);
            if (info == null) {
                return this.error(node, "Invalid @Sadow on " + name + desc + " owner " + owner + " has no @Mixin");
            }
            info.addShadow(name, desc, "shadow$");
        } else {
            return this.error(node, "Invalid @Shadow target: " + parent.getClass().getName());
        }
        return true;
    }

    @Override
    public boolean process(NormalAnnotation node) {
        String prefix = "shadow$";
        block9: for (MemberValuePair mvp : node.values()) {
            switch (mvp.getName().toString()) {
                case "remap": 
                case "aliases": {
                    continue block9;
                }
                case "prefix": {
                    if (mvp.getValue().getNodeType() == 45) {
                        prefix = ((StringLiteral)mvp.getValue()).getLiteralValue();
                        continue block9;
                    }
                    return this.error(node, "Unknown @Shadow member: " + node.toString());
                }
            }
            return this.error(node, "Unknown @Shadow member: " + node.toString());
        }
        ASTNode parent = node.getParent();
        if (parent.getNodeType() == 23) {
            FieldDeclaration fld = (FieldDeclaration)parent;
            for (VariableDeclarationFragment vdf : fld.fragments()) {
                IVariableBinding bind = vdf.resolveBinding();
                String owner = ExtractUtil.getInternalName(this.getFilename(), bind.getDeclaringClass(), parent);
                String type = ExtractUtil.getTypeSignature(bind.getType());
                String name = bind.getName().toString();
                MixinInfo info = this.getInfo(owner);
                if (info == null) {
                    return this.error(node, "Invalid @Sadow on " + name + " owner " + owner + " has no @Mixin");
                }
                info.addShadow(name, type, prefix);
            }
        } else if (parent.getNodeType() == 31) {
            MethodDeclaration mtd = (MethodDeclaration)parent;
            IMethodBinding bind = mtd.resolveBinding();
            String owner = ExtractUtil.getInternalName(this.getFilename(), bind.getDeclaringClass(), parent);
            String name = bind.getName().toString();
            String desc = ExtractUtil.getDescriptor(bind);
            MixinInfo info = this.getInfo(owner);
            if (info == null) {
                return this.error(node, "Invalid @Sadow on " + name + desc + " owner " + owner + " has no @Mixin");
            }
            info.addShadow(name, desc, prefix);
        } else {
            return this.error(node, "Invalid @Shadow target: " + parent.getClass().getName());
        }
        return true;
    }
}

