/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.mixin;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.srg2source.extract.MixinProcessor;
import net.minecraftforge.srg2source.mixin.Accessor;
import net.minecraftforge.srg2source.mixin.IAnnotationProcessor;
import net.minecraftforge.srg2source.mixin.Interface;
import net.minecraftforge.srg2source.mixin.Invoker;
import net.minecraftforge.srg2source.mixin.Mixin;
import net.minecraftforge.srg2source.mixin.Overwrite;
import net.minecraftforge.srg2source.mixin.Shadow;

public enum MixinAnnotation {
    ACCESSOR("gen/Accessor", Accessor::new),
    INVOKER("gen/Invoker", Invoker::new),
    INTERFACE("Interface", Interface::new),
    MIXIN("Mixin", Mixin::new),
    OVERWRITE("Overwrite", Overwrite::new),
    SHADOW("Shadow", Shadow::new);

    private static final Map<String, MixinAnnotation> values;
    private final String type;
    private final Function<MixinProcessor, IAnnotationProcessor> factory;

    private MixinAnnotation(String type, Function<MixinProcessor, IAnnotationProcessor> factory) {
        this.type = "org/spongepowered/asm/mixin/" + type;
        this.factory = factory;
    }

    public static MixinAnnotation getByType(String type) {
        return values.get(type);
    }

    public String getType() {
        return this.type;
    }

    public IAnnotationProcessor newInstance(MixinProcessor processor) {
        return this.factory.apply(processor);
    }

    static {
        values = Arrays.asList(MixinAnnotation.values()).stream().collect(Collectors.toMap(e -> e.getType(), e -> e));
    }
}

