/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.srg2source.api;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraftforge.srg2source.api.InputSupplier;
import net.minecraftforge.srg2source.api.OutputSupplier;
import net.minecraftforge.srg2source.apply.RangeApplier;
import net.minecraftforge.srg2source.util.io.ChainedInputSupplier;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import net.minecraftforge.srg2source.util.io.ZipOutputSupplier;

public class RangeApplierBuilder {
    private PrintStream logStd = System.out;
    private PrintStream logErr = System.err;
    private List<InputSupplier> inputs = new ArrayList<InputSupplier>();
    private OutputSupplier output = null;
    private Consumer<RangeApplier> range = null;
    private List<Consumer<RangeApplier>> srgs = new ArrayList<Consumer<RangeApplier>>();
    private List<Consumer<RangeApplier>> excs = new ArrayList<Consumer<RangeApplier>>();
    private boolean keepImports = false;
    private boolean guessLambdas = false;
    private boolean guessLocals = false;
    private boolean sortImports = false;

    public RangeApplierBuilder logger(PrintStream value) {
        this.logStd = value;
        return this;
    }

    public RangeApplierBuilder errorLogger(PrintStream value) {
        this.logErr = value;
        return this;
    }

    public RangeApplierBuilder output(Path value) {
        try {
            this.output = Files.isDirectory(value, new LinkOption[0]) ? FolderSupplier.create(value, null) : new ZipOutputSupplier(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid output: " + value, e);
        }
        return this;
    }

    public RangeApplierBuilder srg(Path value) {
        this.srgs.add(a -> a.readSrg(value));
        return this;
    }

    public RangeApplierBuilder exc(Path value) {
        this.excs.add(a -> a.readExc(value));
        return this;
    }

    public RangeApplierBuilder input(Path value) {
        return this.input(value, StandardCharsets.UTF_8);
    }

    public RangeApplierBuilder guessLambdas() {
        return this.guessLambdas(true);
    }

    public RangeApplierBuilder guessLambdas(boolean value) {
        this.guessLambdas = value;
        return this;
    }

    public RangeApplierBuilder guessLocals() {
        return this.guessLocals(true);
    }

    public RangeApplierBuilder guessLocals(boolean value) {
        this.guessLocals = value;
        return this;
    }

    public RangeApplierBuilder sortImports() {
        return this.sortImports(true);
    }

    public RangeApplierBuilder sortImports(boolean value) {
        this.sortImports = value;
        return this;
    }

    public RangeApplierBuilder input(Path value, Charset encoding) {
        block5: {
            if (value == null || !Files.exists(value, new LinkOption[0])) {
                throw new IllegalArgumentException("Invalid input value: " + value);
            }
            String filename = value.getFileName().toString().toLowerCase(Locale.ENGLISH);
            try {
                if (Files.isDirectory(value, new LinkOption[0])) {
                    this.inputs.add(FolderSupplier.create(value, encoding));
                    break block5;
                }
                if (filename.endsWith(".jar") || filename.endsWith(".zip")) {
                    this.inputs.add(ZipInputSupplier.create(value, encoding));
                    break block5;
                }
                throw new IllegalArgumentException("Invalid input value: " + value);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid input: " + value, e);
            }
        }
        return this;
    }

    public RangeApplierBuilder input(InputSupplier value) {
        this.inputs.add(value);
        return this;
    }

    public RangeApplierBuilder range(File value) {
        this.range = a -> a.readRangeMap(value);
        return this;
    }

    public RangeApplierBuilder range(Path value) {
        this.range = a -> a.readRangeMap(value);
        return this;
    }

    public RangeApplierBuilder trimImports() {
        this.keepImports = false;
        return this;
    }

    public RangeApplierBuilder keepImports() {
        this.keepImports = true;
        return this;
    }

    public RangeApplier build() {
        if (this.output == null) {
            throw new IllegalStateException("Builder State Exception: Missing Output");
        }
        if (this.range == null) {
            throw new IllegalArgumentException("Builder State Exception: Missing Range Map");
        }
        RangeApplier ret = new RangeApplier();
        ret.setLogger(this.logStd);
        ret.setErrorLogger(this.logErr);
        if (this.inputs.size() == 1) {
            ret.setInput(this.inputs.get(0));
        } else {
            ret.setInput(new ChainedInputSupplier(this.inputs));
        }
        ret.setOutput(this.output);
        this.range.accept(ret);
        ret.setGuessLambdas(this.guessLambdas);
        ret.setGuessLocals(this.guessLocals);
        ret.setSortImports(this.sortImports);
        this.srgs.forEach(e -> e.accept(ret));
        this.excs.forEach(e -> e.accept(ret));
        ret.keepImports(this.keepImports);
        return ret;
    }
}

