/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import sun.security.util.ManifestEntryVerifier;

public class SecureJarHandler {
    private static final Class<?> JVCLASS;
    private static final Method BEGIN_ENTRY;
    private static final Method UPDATE;
    private static final Field JV;
    private static final Map<CodeSource, ProtectionDomain> pdCache;

    public static CodeSource createCodeSource(String name, URL url, byte[] bytes, Manifest manifest) {
        if (JV == null) {
            return null;
        }
        if (manifest == null) {
            return null;
        }
        if (url == null) {
            return null;
        }
        JarEntry je = new JarEntry(name);
        ManifestEntryVerifier mev = new ManifestEntryVerifier(manifest);
        Object obj = LamdbaExceptionUtils.uncheck(() -> JV.get(manifest));
        if (obj == null) {
            return null;
        }
        LamdbaExceptionUtils.uncheck(() -> BEGIN_ENTRY.invoke(obj, je, mev));
        LamdbaExceptionUtils.uncheck(() -> UPDATE.invoke(obj, bytes.length, bytes, 0, bytes.length, mev));
        try {
            UPDATE.invoke(obj, -1, bytes, 0, bytes.length, mev);
        }
        catch (SecurityException se) {
            LogManager.getLogger().info(LogMarkers.CLASSLOADING, "Validation problem during class loading of {}", name, se);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        CodeSigner[] signers = je.getCodeSigners();
        return new CodeSource(url, signers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProtectionDomain createProtectionDomain(CodeSource codeSource, ClassLoader cl) {
        Map<CodeSource, ProtectionDomain> map = pdCache;
        synchronized (map) {
            return pdCache.computeIfAbsent(codeSource, cs -> {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return new ProtectionDomain(codeSource, perms, cl, null);
            });
        }
    }

    public static boolean canHandleSecuredJars() {
        return JV != null;
    }

    static {
        Field jv;
        JVCLASS = LamdbaExceptionUtils.uncheck(() -> Class.forName("java.util.jar.JarVerifier"));
        BEGIN_ENTRY = LamdbaExceptionUtils.uncheck(() -> JVCLASS.getMethod("beginEntry", JarEntry.class, ManifestEntryVerifier.class));
        UPDATE = LamdbaExceptionUtils.uncheck(() -> JVCLASS.getMethod("update", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, ManifestEntryVerifier.class));
        try {
            jv = Manifest.class.getDeclaredField("jv");
            jv.setAccessible(true);
            BEGIN_ENTRY.setAccessible(true);
            UPDATE.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            LogManager.getLogger().warn("LEGACY JDK DETECTED, SECURED JAR HANDLING DISABLED");
            jv = null;
        }
        JV = jv;
        pdCache = new HashMap<CodeSource, ProtectionDomain>();
    }
}

