/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;

class OrderedExecutor
implements ThreadFactory {
    private final int nThreads;
    private final String logThreadName;
    private final ThreadPoolExecutor delegate;
    private final LinkedBlockingQueue<Runnable> queue;
    private int coreSize;

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.logThreadName);
        t.setDaemon(true);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeOrderedTask(Runnable task, OrderedTaskQueue dependencyQueue, int numListeners) {
        OrderedTaskQueue.OrderedTask firstOrderedTask;
        OrderedExecutor orderedExecutor = this;
        synchronized (orderedExecutor) {
            int targetSize;
            firstOrderedTask = dependencyQueue.addTaskAndReturnIfFirst(task);
            if (firstOrderedTask != null && this.coreSize < (targetSize = Math.min(this.nThreads, numListeners))) {
                this.coreSize = targetSize;
                this.delegate.setCorePoolSize(this.coreSize);
            }
        }
        if (firstOrderedTask != null) {
            this.delegate.execute(firstOrderedTask);
        }
    }

    OrderedTaskQueue createQueue() {
        return new OrderedTaskQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeNextTask(OrderedTaskQueue taskQueue) {
        OrderedTaskQueue.OrderedTask nextTask;
        OrderedExecutor orderedExecutor = this;
        synchronized (orderedExecutor) {
            nextTask = taskQueue.getNextTask();
            if (nextTask == null && this.queue.isEmpty()) {
                this.delegate.setCorePoolSize(0);
                this.coreSize = 0;
            }
        }
        if (nextTask != null) {
            this.delegate.execute(nextTask);
        }
    }

    class OrderedTaskQueue {
        private final Queue<OrderedTask> dependencyQueue = new LinkedList<OrderedTask>();
        private AtomicReference<OrderedTask> firstTask = new AtomicReference();

        OrderedTaskQueue() {
        }

        void execute(Runnable task, int numListeners) {
            OrderedExecutor.this.executeOrderedTask(task, this, numListeners);
        }

        OrderedTask addTaskAndReturnIfFirst(Runnable task) {
            OrderedTask orderedTask = new OrderedTask(task);
            if (this.firstTask.compareAndSet(null, orderedTask)) {
                return orderedTask;
            }
            this.dependencyQueue.add(orderedTask);
            return null;
        }

        OrderedTask getNextTask() {
            OrderedTask nextTask = this.dependencyQueue.poll();
            if (nextTask == null) {
                this.firstTask.set(null);
            }
            return nextTask;
        }

        class OrderedTask
        implements Runnable {
            private final Runnable task;

            public OrderedTask(Runnable task) {
                this.task = task;
            }

            @Override
            public void run() {
                try {
                    this.task.run();
                }
                finally {
                    OrderedExecutor.this.executeNextTask(OrderedTaskQueue.this);
                }
            }
        }
    }
}

