/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.location;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.location.BasicLocation;
import org.eclipse.osgi.internal.location.LocationHelper;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.storage.StorageUtil;

public class EquinoxLocations {
    private final EquinoxConfiguration.ConfigValues equinoxConfig;
    private final EquinoxContainer container;
    private final AtomicBoolean debugLocations;
    private final Location installLocation;
    private final Location configurationLocation;
    private final Location userLocation;
    private final Location instanceLocation;
    private final Location eclipseHomeLocation;

    public EquinoxLocations(EquinoxConfiguration.ConfigValues equinoxConfig, EquinoxContainer container, AtomicBoolean debugLocations, Map<Throwable, Integer> exceptions) {
        String eclipseLauncher;
        String eclipseHomeLocationPath;
        URL defaultLocation;
        this.equinoxConfig = equinoxConfig;
        this.container = container;
        this.debugLocations = debugLocations;
        String osgiStorage = equinoxConfig.getConfiguration("org.osgi.framework.storage");
        if (osgiStorage != null) {
            if (equinoxConfig.getConfiguration("osgi.configuration.area") != null) {
                exceptions.put(new IllegalArgumentException(String.format("The property '%s' with the value '%s' is being overriden by the OSGi standard configuration property '%s' with the value '%s'.", "osgi.configuration.area", equinoxConfig.getConfiguration("osgi.configuration.area"), "org.osgi.framework.storage", osgiStorage)), 2);
            }
            equinoxConfig.setConfiguration("osgi.configuration.area", osgiStorage);
        }
        this.installLocation = this.buildLocation("osgi.install.area", null, "", true, false, null);
        Location temp = this.buildLocation("osgi.user.area.default", null, "", false, false, null);
        URL uRL = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = EquinoxLocations.buildURL(new File(System.getProperty("user.home"), "user").getAbsolutePath(), true);
        }
        this.userLocation = this.buildLocation("osgi.user.area", defaultLocation, "", false, false, null);
        temp = this.buildLocation("osgi.instance.area.default", null, "", false, false, ".metadata/.plugins/");
        URL uRL2 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = EquinoxLocations.buildURL(new File(System.getProperty("user.dir"), "workspace").getAbsolutePath(), true);
        }
        this.instanceLocation = this.buildLocation("osgi.instance.area", defaultLocation, "", false, false, ".metadata/.plugins/");
        this.mungeConfigurationLocation();
        temp = this.buildLocation("osgi.configuration.area.default", null, "", false, false, null);
        URL uRL3 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null && equinoxConfig.getConfiguration("osgi.configuration.area") == null) {
            defaultLocation = EquinoxLocations.buildURL(this.computeDefaultConfigurationLocation(), true);
        }
        this.configurationLocation = this.buildLocation("osgi.configuration.area", defaultLocation, "", false, false, null);
        URL parentLocation = this.computeSharedConfigurationLocation();
        if (parentLocation != null && !parentLocation.equals(this.configurationLocation.getURL())) {
            BasicLocation parent = new BasicLocation(null, parentLocation, true, null, equinoxConfig, container, debugLocations);
            ((BasicLocation)this.configurationLocation).setParent(parent);
        }
        if (equinoxConfig.getConfiguration("eclipse.home.location") == null && (eclipseHomeLocationPath = EquinoxLocations.getEclipseHomeLocation(eclipseLauncher = equinoxConfig.getConfiguration("eclipse.launcher"), equinoxConfig)) != null) {
            equinoxConfig.setConfiguration("eclipse.home.location", eclipseHomeLocationPath);
        }
        if (equinoxConfig.getConfiguration("eclipse.home.location") == null && equinoxConfig.getConfiguration("osgi.install.area") != null) {
            equinoxConfig.setConfiguration("eclipse.home.location", equinoxConfig.getConfiguration("osgi.install.area"));
        }
        this.eclipseHomeLocation = this.buildLocation("eclipse.home.location", null, "", true, true, null);
    }

    public static URL buildURL(String spec, boolean trailingSlash) {
        return LocationHelper.buildURL(spec, trailingSlash);
    }

    private void mungeConfigurationLocation() {
        String location = this.equinoxConfig.getConfiguration("osgi.configuration.area");
        if (location != null && location.endsWith(".cfg")) {
            int index = location.lastIndexOf(47);
            if (index < 0) {
                index = location.lastIndexOf(92);
            }
            location = location.substring(0, index + 1);
            this.equinoxConfig.setConfiguration("osgi.configuration.area", location);
        }
    }

    private static String getEclipseHomeLocation(String launcher, EquinoxConfiguration.ConfigValues configValues) {
        if (launcher == null) {
            return null;
        }
        File launcherFile = new File(launcher);
        if (launcherFile.getParent() == null) {
            return null;
        }
        File launcherDir = new File(launcherFile.getParent());
        String macosx = "macosx";
        if (macosx.equals(configValues.getConfiguration("osgi.os"))) {
            launcherDir = EquinoxLocations.getMacOSEclipseHomeLocation(launcherDir);
        }
        return launcherDir.exists() && launcherDir.isDirectory() ? launcherDir.getAbsolutePath() : null;
    }

    private static File getMacOSEclipseHomeLocation(File launcherDir) {
        if (!launcherDir.getName().equalsIgnoreCase("macos")) {
            return launcherDir;
        }
        return new File(launcherDir.getParent(), "Eclipse");
    }

    private Location buildLocation(String property, URL defaultLocation, String userDefaultAppendage, boolean readOnlyDefault, boolean computeReadOnly, String dataAreaPrefix) {
        String base;
        boolean readOnly;
        String location = this.equinoxConfig.clearConfiguration(property);
        String userReadOnlySetting = this.equinoxConfig.getConfiguration(String.valueOf(property) + ".readOnly");
        boolean bl = readOnly = userReadOnlySetting == null ? readOnlyDefault : Boolean.valueOf(userReadOnlySetting);
        if (location == null) {
            return new BasicLocation(property, defaultLocation, userReadOnlySetting != null || !computeReadOnly ? readOnly : !EquinoxLocations.canWrite(defaultLocation), dataAreaPrefix, this.equinoxConfig, this.container, this.debugLocations);
        }
        String trimmedLocation = location.trim();
        if (trimmedLocation.equalsIgnoreCase("@none")) {
            return null;
        }
        if (trimmedLocation.equalsIgnoreCase("@noDefault")) {
            return new BasicLocation(property, null, readOnly, dataAreaPrefix, this.equinoxConfig, this.container, this.debugLocations);
        }
        if (trimmedLocation.startsWith("@user.home")) {
            base = this.substituteVar(location, "@user.home", "user.home");
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        } else if (trimmedLocation.startsWith("@user.dir")) {
            base = this.substituteVar(location, "@user.dir", "user.dir");
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        }
        int idx = location.indexOf("@install.hash");
        if (idx == 0) {
            throw new RuntimeException("The location cannot start with '@install.hash': " + location);
        }
        if (idx > 0) {
            location = String.valueOf(location.substring(0, idx)) + this.getInstallDirHash() + location.substring(idx + "@install.hash".length());
        }
        URL url = EquinoxLocations.buildURL(location, true);
        BasicLocation result = null;
        if (url != null) {
            result = new BasicLocation(property, null, userReadOnlySetting != null || !computeReadOnly ? readOnly : !EquinoxLocations.canWrite(url), dataAreaPrefix, this.equinoxConfig, this.container, this.debugLocations);
            result.setURL(url, false);
        }
        return result;
    }

    private String substituteVar(String source, String var, String prop) {
        String value = this.equinoxConfig.getConfiguration(prop, "");
        return String.valueOf(value) + source.substring(var.length());
    }

    private URL computeInstallConfigurationLocation() {
        String property = this.equinoxConfig.getConfiguration("osgi.install.area");
        if (property != null) {
            return LocationHelper.buildURL(property, true);
        }
        return null;
    }

    private URL computeSharedConfigurationLocation() {
        URL sharedConfigurationURL;
        block6: {
            String property = this.equinoxConfig.getConfiguration("osgi.sharedConfiguration.area");
            if (property == null) {
                return null;
            }
            try {
                sharedConfigurationURL = LocationHelper.buildURL(property, true);
                if (sharedConfigurationURL != null) break block6;
                return null;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (sharedConfigurationURL.getPath().startsWith("/")) {
            return sharedConfigurationURL;
        }
        URL installURL = this.installLocation.getURL();
        if (!sharedConfigurationURL.getProtocol().equals(installURL.getProtocol())) {
            return sharedConfigurationURL;
        }
        sharedConfigurationURL = new URL(installURL, sharedConfigurationURL.getPath());
        this.equinoxConfig.setConfiguration("osgi.sharedConfiguration.area", sharedConfigurationURL.toExternalForm());
        return null;
    }

    private String computeDefaultConfigurationLocation() {
        URL installURL = this.computeInstallConfigurationLocation();
        if (installURL != null && "file".equals(installURL.getProtocol())) {
            File installDir = new File(installURL.getPath());
            File defaultConfigDir = new File(installDir, "configuration");
            if (!defaultConfigDir.exists()) {
                defaultConfigDir.mkdirs();
            }
            if (defaultConfigDir.exists() && StorageUtil.canWrite(defaultConfigDir)) {
                return defaultConfigDir.getAbsolutePath();
            }
        }
        return this.computeDefaultUserAreaLocation("configuration");
    }

    private static boolean canWrite(URL location) {
        if (location != null && "file".equals(location.getProtocol())) {
            File locationDir = new File(location.getPath());
            if (!locationDir.exists()) {
                locationDir.mkdirs();
            }
            if (locationDir.exists() && StorageUtil.canWrite(locationDir)) {
                return true;
            }
        }
        return false;
    }

    private String computeDefaultUserAreaLocation(String pathAppendage) {
        String installProperty = this.equinoxConfig.getConfiguration("osgi.install.area");
        URL installURL = EquinoxLocations.buildURL(installProperty, true);
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getPath());
        String installDirHash = this.getInstallDirHash();
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, ".eclipseproduct");
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty("id");
                if (appId == null || appId.trim().length() == 0) {
                    appId = "eclipse";
                }
                if ((appVersion = props.getProperty("version")) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = String.valueOf(appName) + File.separator + appId + "_" + appVersion + "_" + installDirHash;
            }
            catch (IOException iOException) {
                appName = String.valueOf(appName) + File.separator + installDirHash;
            }
        } else {
            appName = String.valueOf(appName) + File.separator + installDirHash;
        }
        String userHome = System.getProperty("user.home");
        return new File(userHome, String.valueOf(appName) + "/" + pathAppendage).getAbsolutePath();
    }

    private String getInstallDirHash() {
        int hashCode;
        String installProperty = this.equinoxConfig.getConfiguration("osgi.install.area");
        URL installURL = EquinoxLocations.buildURL(installProperty, true);
        if (installURL == null) {
            return "";
        }
        File installDir = new File(installURL.getPath());
        try {
            hashCode = installDir.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            hashCode = installDir.getAbsolutePath().hashCode();
        }
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        String installDirHash = String.valueOf(hashCode);
        return installDirHash;
    }

    public Location getConfigurationLocation() {
        return this.configurationLocation;
    }

    public Location getInstallLocation() {
        return this.installLocation;
    }
}

