/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.location;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.location.LocationHelper;
import org.eclipse.osgi.internal.location.Locker;
import org.eclipse.osgi.internal.log.EquinoxLogServices;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class BasicLocation
implements Location {
    private static String DEFAULT_LOCK_FILENAME = ".metadata/.lock";
    private final boolean isReadOnly;
    private final URL defaultValue;
    private final String property;
    private final String dataAreaPrefix;
    private final EquinoxConfiguration.ConfigValues configValues;
    private final AtomicBoolean debug;
    private final EquinoxContainer container;
    private URL location = null;
    private Location parent;
    private File lockFile;
    private Locker locker;

    public BasicLocation(String property, URL defaultValue, boolean isReadOnly, String dataAreaPrefix, EquinoxConfiguration.ConfigValues configValues, EquinoxContainer container, AtomicBoolean debug) {
        this.property = property;
        this.defaultValue = defaultValue;
        this.isReadOnly = isReadOnly;
        String tempDataAreaPrefix = dataAreaPrefix == null ? "" : dataAreaPrefix;
        tempDataAreaPrefix = tempDataAreaPrefix.replace('\\', '/');
        if (tempDataAreaPrefix.length() > 0 && tempDataAreaPrefix.charAt(tempDataAreaPrefix.length() - 1) != '/') {
            tempDataAreaPrefix = String.valueOf(tempDataAreaPrefix) + '/';
        }
        this.dataAreaPrefix = tempDataAreaPrefix;
        this.configValues = configValues;
        this.container = container;
        this.debug = debug;
    }

    @Override
    public boolean allowsDefault() {
        return this.defaultValue != null;
    }

    @Override
    public synchronized Location getParentLocation() {
        return this.parent;
    }

    @Override
    public synchronized URL getURL() {
        if (this.location == null && this.defaultValue != null) {
            EquinoxLogServices logServices;
            if (this.debug.get() && (logServices = this.container.getLogServices()) != null) {
                logServices.log("org.eclipse.osgi", 1, "Called Location.getURL() when it has not been set for: \"" + this.property + "\"", new RuntimeException("Call stack for Location.getURL()"));
            }
            this.setURL(this.defaultValue, false);
        }
        return this.location;
    }

    @Override
    public synchronized boolean isSet() {
        return this.location != null;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean setURL(URL value, boolean lock) throws IllegalStateException {
        try {
            return this.set(value, lock);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized boolean set(URL value, boolean lock) throws IllegalStateException, IOException {
        return this.set(value, lock, null);
    }

    public synchronized boolean set(URL value, boolean lock, String lockFilePath) throws IllegalStateException, IOException {
        if (this.location != null) {
            throw new IllegalStateException(Msg.ECLIPSE_CANNOT_CHANGE_LOCATION);
        }
        File file = null;
        if (value.getProtocol().equalsIgnoreCase("file")) {
            File givenLockFile;
            try {
                File f = LocationHelper.decodePath(new File(value.getPath()));
                String basePath = f.getCanonicalPath();
                value = LocationHelper.buildURL("file:" + basePath, true);
            }
            catch (IOException iOException) {}
            file = lockFilePath != null && lockFilePath.length() > 0 ? ((givenLockFile = new File(lockFilePath)).isAbsolute() ? givenLockFile : new File(value.getPath(), lockFilePath)) : new File(value.getPath(), DEFAULT_LOCK_FILENAME);
        }
        boolean bl = lock = lock && !this.isReadOnly;
        if (lock && !this.lock(file, value)) {
            return false;
        }
        this.lockFile = file;
        this.location = value;
        if (this.property != null) {
            this.configValues.setConfiguration(this.property, this.location.toExternalForm());
        }
        return lock;
    }

    public synchronized void setParent(Location value) {
        this.parent = value;
    }

    public synchronized boolean isLocked() throws IOException {
        if (!this.isSet()) {
            return false;
        }
        return this.isLocked(this.lockFile);
    }

    private boolean lock(File lock, URL locationValue) throws IOException {
        if (this.isReadOnly) {
            throw new IOException(NLS.bind(Msg.location_folderReadOnly, lock));
        }
        if (lock == null) {
            if (locationValue != null && !"file".equalsIgnoreCase(locationValue.getProtocol())) {
                throw new IOException(NLS.bind(Msg.location_notFileProtocol, locationValue));
            }
            throw new IllegalStateException(Msg.location_noLockFile);
        }
        if (this.isLocked()) {
            return false;
        }
        File parentFile = new File(lock.getParent());
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
            if (!parentFile.isDirectory()) {
                throw new IOException(NLS.bind(Msg.location_folderReadOnly, parentFile));
            }
        }
        this.setLocker(lock);
        if (this.locker == null) {
            return true;
        }
        boolean locked = false;
        try {
            boolean bl = locked = this.locker.lock();
            return bl;
        }
        finally {
            if (!locked) {
                this.locker = null;
            }
        }
    }

    private boolean isLocked(File lock) throws IOException {
        if (lock == null || this.isReadOnly) {
            return true;
        }
        if (!lock.exists()) {
            return false;
        }
        this.setLocker(lock);
        return this.locker.isLocked();
    }

    private void setLocker(File lock) {
        if (this.locker != null) {
            return;
        }
        String lockMode = this.configValues.getConfiguration("osgi.locking", "java.nio");
        this.locker = LocationHelper.createLocker(lock, lockMode, this.debug.get());
    }

    @Override
    public Location createLocation(Location parentLocation, URL defaultLocation, boolean readonly) {
        BasicLocation result = new BasicLocation(null, defaultLocation, readonly, this.dataAreaPrefix, this.configValues, this.container, this.debug);
        result.setParent(parentLocation);
        return result;
    }

    @Override
    public URL getDataArea(String filename) throws IOException {
        String spec;
        URL base = this.getURL();
        if (base == null) {
            throw new IOException(Msg.location_notSet);
        }
        String prefix = base.toExternalForm();
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
            prefix = String.valueOf(prefix) + '/';
        }
        if ((filename = filename.replace('\\', '/')).length() > 0 && filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        boolean trailingSlash = (spec = String.valueOf(prefix) + this.dataAreaPrefix + filename).length() > 0 && spec.charAt(spec.length() - 1) == '/';
        return LocationHelper.buildURL(spec, trailingSlash);
    }
}

