/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleLoader;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.container.SystemModule;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.framework.DTOBuilder;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.framework.EquinoxContainerAdaptor;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.Storage;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.framework.wiring.dto.BundleRevisionDTO;
import org.osgi.framework.wiring.dto.BundleWiringDTO;
import org.osgi.framework.wiring.dto.FrameworkWiringDTO;

public class EquinoxBundle
implements Bundle,
BundleReference {
    private final EquinoxContainer equinoxContainer;
    private final Module module;
    private final Object monitor = new Object();
    private BundleContextImpl context;
    private volatile SignedContent signedContent;

    EquinoxBundle(ModuleContainer moduleContainer, EquinoxContainer equinoxContainer) {
        this.equinoxContainer = equinoxContainer;
        this.module = this.createSystemModule(moduleContainer);
    }

    public EquinoxBundle(Long id, String location, ModuleContainer moduleContainer, EnumSet<Module.Settings> settings, int startlevel, EquinoxContainer equinoxContainer) {
        this.equinoxContainer = equinoxContainer;
        this.module = new EquinoxModule(id, location, moduleContainer, settings, startlevel);
    }

    Module createSystemModule(ModuleContainer moduleContainer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Bundle bundle) {
        long idcomp = this.getBundleId() - bundle.getBundleId();
        return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
    }

    @Override
    public int getState() {
        switch (this.module.getState()) {
            case INSTALLED: {
                return 2;
            }
            case RESOLVED: {
                return 4;
            }
            case LAZY_STARTING: 
            case STARTING: {
                return 8;
            }
            case ACTIVE: {
                return 32;
            }
            case STOPPING: {
                return 16;
            }
            case UNINSTALLED: {
                return 1;
            }
        }
        throw new IllegalStateException("No valid bundle state for module state: " + (Object)((Object)this.module.getState()));
    }

    @Override
    public void start(int options) throws BundleException {
        if (options == 0 && this.equinoxContainer.getConfiguration().getDebug().MONITOR_ACTIVATION) {
            Debug.printStackTrace(new Exception("A persistent start has been called on bundle: " + this));
        }
        this.module.start(EquinoxBundle.getStartOptions(options));
    }

    private static Module.StartOptions[] getStartOptions(int options) {
        if (options == 0) {
            return new Module.StartOptions[0];
        }
        ArrayList<Module.StartOptions> result = new ArrayList<Module.StartOptions>(2);
        if ((options & 1) != 0) {
            result.add(Module.StartOptions.TRANSIENT);
        }
        if ((options & 2) != 0) {
            result.add(Module.StartOptions.USE_ACTIVATION_POLICY);
        }
        return result.toArray(new Module.StartOptions[result.size()]);
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void stop(int options) throws BundleException {
        if (options == 0 && this.equinoxContainer.getConfiguration().getDebug().MONITOR_ACTIVATION) {
            Debug.printStackTrace(new Exception("A persistent stop has been called on bundle: " + this));
        }
        this.module.stop(this.getStopOptions(options));
    }

    private Module.StopOptions[] getStopOptions(int options) {
        if ((options & 1) == 0) {
            return new Module.StopOptions[0];
        }
        return new Module.StopOptions[]{Module.StopOptions.TRANSIENT};
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    @Override
    public void uninstall() throws BundleException {
        this.privGetHeaders(null);
        Storage storage = this.equinoxContainer.getStorage();
        storage.getModuleContainer().uninstall(this.module);
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        this.equinoxContainer.checkAdminPermission(this, "metadata");
        return this.privGetHeaders(locale);
    }

    private Dictionary<String, String> privGetHeaders(String locale) {
        BundleInfo.Generation current = (BundleInfo.Generation)this.module.getCurrentRevision().getRevisionInfo();
        return current.getHeaders(locale);
    }

    @Override
    public long getBundleId() {
        return this.module.getId();
    }

    @Override
    public String getLocation() {
        this.equinoxContainer.checkAdminPermission(this.getBundle(), "metadata");
        return this.module.getLocation();
    }

    @Override
    public boolean hasPermission(Object permission) {
        BundleInfo.Generation current = (BundleInfo.Generation)this.module.getCurrentRevision().getRevisionInfo();
        ProtectionDomain domain = current.getDomain();
        if (domain != null) {
            if (permission instanceof Permission) {
                SecurityManager sm = System.getSecurityManager();
                if (sm instanceof EquinoxSecurityManager) {
                    AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{domain});
                    try {
                        sm.checkPermission((Permission)permission, acc);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return domain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    @Override
    public URL getResource(String name) {
        try {
            this.equinoxContainer.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (this.isFragment()) {
            return null;
        }
        ModuleClassLoader classLoader = this.getModuleClassLoader(false);
        if (classLoader != null) {
            return classLoader.getResource(name);
        }
        return new ClasspathManager((BundleInfo.Generation)this.module.getCurrentRevision().getRevisionInfo(), null).findLocalResource(name);
    }

    @Override
    public String getSymbolicName() {
        return this.module.getCurrentRevision().getSymbolicName();
    }

    @Override
    public Version getVersion() {
        return this.module.getCurrentRevision().getVersion();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            this.equinoxContainer.checkAdminPermission(this, "class");
        }
        catch (SecurityException e) {
            throw new ClassNotFoundException(name, e);
        }
        this.checkValid();
        if (this.isFragment()) {
            throw new ClassNotFoundException("Can not load a class from a fragment bundle: " + this);
        }
        try {
            ModuleClassLoader classLoader = this.getModuleClassLoader(true);
            if (classLoader != null) {
                if (name.length() > 0 && name.charAt(0) == '[') {
                    return Class.forName(name, false, classLoader);
                }
                return classLoader.loadClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            boolean compatibilityLazyTrigger = this.equinoxContainer.getConfiguration().compatibilityLazyTriggerOnFailLoad;
            if (compatibilityLazyTrigger && Module.State.LAZY_STARTING.equals((Object)this.module.getState())) {
                try {
                    this.module.start(Module.StartOptions.LAZY_TRIGGER);
                }
                catch (BundleException bundleException) {
                    this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 2, e.getMessage(), e);
                }
            }
            throw e;
        }
        throw new ClassNotFoundException("No class loader available for the bundle: " + this);
    }

    private ModuleClassLoader getModuleClassLoader(boolean logResolveError) {
        ResolutionReport report = this.resolve();
        if (logResolveError && !Module.RESOLVED_SET.contains((Object)this.module.getState())) {
            String reportMessage = report.getResolutionReportMessage(this.module.getCurrentRevision());
            this.equinoxContainer.getEventPublisher().publishFrameworkEvent(2, this, new BundleException(reportMessage, 4));
        }
        return AccessController.doPrivileged(new PrivilegedAction<ModuleClassLoader>(){

            @Override
            public ModuleClassLoader run() {
                ModuleLoader moduleLoader;
                ModuleWiring wiring = EquinoxBundle.this.getModule().getCurrentRevision().getWiring();
                if (wiring != null && (moduleLoader = wiring.getModuleLoader()) instanceof BundleLoader) {
                    return ((BundleLoader)moduleLoader).getModuleClassLoader();
                }
                return null;
            }
        });
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        try {
            this.equinoxContainer.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (this.isFragment()) {
            return null;
        }
        ModuleClassLoader classLoader = this.getModuleClassLoader(false);
        Enumeration<URL> result = null;
        result = classLoader != null ? classLoader.getResources(name) : new ClasspathManager((BundleInfo.Generation)this.module.getCurrentRevision().getRevisionInfo(), null).findLocalResources(name);
        return result != null && result.hasMoreElements() ? result : null;
    }

    @Override
    public URL getEntry(String path) {
        try {
            this.equinoxContainer.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        BundleInfo.Generation current = (BundleInfo.Generation)this.getModule().getCurrentRevision().getRevisionInfo();
        return current.getEntry(path);
    }

    @Override
    public long getLastModified() {
        return this.module.getLastModified();
    }

    @Override
    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        try {
            this.equinoxContainer.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        this.resolve();
        return Storage.findEntries(this.getGenerations(), path, filePattern, recurse ? 1 : 0);
    }

    @Override
    public BundleContext getBundleContext() {
        this.equinoxContainer.checkAdminPermission(this, "context");
        return this.createBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleContextImpl createBundleContext() {
        if (this.isFragment()) {
            return null;
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.context == null && Module.ACTIVE_SET.contains((Object)this.module.getState())) {
                this.context = new BundleContextImpl(this, this.equinoxContainer);
            }
            return this.context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleContextImpl getBundleContextImpl() {
        Object object = this.monitor;
        synchronized (object) {
            return this.context;
        }
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        try {
            SignerInfo[] infos;
            SignedContent current = this.getSignedContent();
            SignerInfo[] signerInfoArray = infos = current == null ? null : current.getSignerInfos();
            if (infos.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<X509Certificate, List<X509Certificate>> results = new HashMap<X509Certificate, List<X509Certificate>>(infos.length);
            SignerInfo[] signerInfoArray2 = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                Certificate[] certs;
                SignerInfo info = signerInfoArray2[n2];
                if ((signersType != 2 || info.isTrusted()) && (certs = info.getCertificateChain()) != null && certs.length != 0) {
                    ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                    Certificate[] certificateArray = certs;
                    int n3 = certs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Certificate cert = certificateArray[n4];
                        certChain.add((X509Certificate)cert);
                        ++n4;
                    }
                    results.put((X509Certificate)certs[0], certChain);
                }
                ++n2;
            }
            return results;
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }

    @Override
    public final <A> A adapt(Class<A> adapterType) {
        this.checkAdaptPermission(adapterType);
        return this.adapt0(adapterType);
    }

    private void readLock() {
        this.equinoxContainer.getStorage().getModuleDatabase().readLock();
    }

    private void readUnlock() {
        this.equinoxContainer.getStorage().getModuleDatabase().readUnlock();
    }

    private <A> A adapt0(Class<A> adapterType) {
        if (AccessControlContext.class.equals(adapterType)) {
            BundleInfo.Generation current = (BundleInfo.Generation)this.module.getCurrentRevision().getRevisionInfo();
            ProtectionDomain domain = current.getDomain();
            return (A)(domain == null ? null : new AccessControlContext(new ProtectionDomain[]{domain}));
        }
        if (BundleContext.class.equals(adapterType)) {
            try {
                return (A)this.getBundleContext();
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        if (BundleRevision.class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            return (A)this.module.getCurrentRevision();
        }
        if (BundleRevisions.class.equals(adapterType)) {
            return (A)this.module.getRevisions();
        }
        if (BundleStartLevel.class.equals(adapterType)) {
            return (A)this.module;
        }
        if (BundleWiring.class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            ModuleRevision revision = this.module.getCurrentRevision();
            if (revision == null) {
                return null;
            }
            return (A)revision.getWiring();
        }
        if (BundleDTO.class.equals(adapterType)) {
            this.readLock();
            try {
                BundleDTO domain = DTOBuilder.newBundleDTO(this);
                return (A)domain;
            }
            finally {
                this.readUnlock();
            }
        }
        if (BundleStartLevelDTO.class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            return (A)DTOBuilder.newBundleStartLevelDTO(this, this.module);
        }
        if (BundleRevisionDTO.class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            return (A)DTOBuilder.newBundleRevisionDTO(this.module.getCurrentRevision());
        }
        if (BundleRevisionDTO[].class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            return (A)DTOBuilder.newArrayBundleRevisionDTO(this.module.getRevisions());
        }
        if (BundleWiringDTO.class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            this.readLock();
            try {
                BundleWiringDTO domain = DTOBuilder.newBundleWiringDTO(this.module.getCurrentRevision());
                return (A)domain;
            }
            finally {
                this.readUnlock();
            }
        }
        if (BundleWiringDTO[].class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            this.readLock();
            try {
                BundleWiringDTO[] domain = DTOBuilder.newArrayBundleWiringDTO(this.module.getRevisions());
                return (A)domain;
            }
            finally {
                this.readUnlock();
            }
        }
        if (ServiceReferenceDTO[].class.equals(adapterType)) {
            if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
                return null;
            }
            BundleContextImpl current = this.getBundleContextImpl();
            ServiceReferenceImpl<?>[] references = current == null ? null : this.equinoxContainer.getServiceRegistry().getRegisteredServices(current);
            return (A)DTOBuilder.newArrayServiceReferenceDTO(references);
        }
        if (this.getBundleId() == 0L) {
            if (Framework.class.equals(adapterType)) {
                return (A)this;
            }
            if (FrameworkStartLevel.class.equals(adapterType)) {
                return (A)this.module.getContainer().getFrameworkStartLevel();
            }
            if (FrameworkWiring.class.equals(adapterType)) {
                return (A)this.module.getContainer().getFrameworkWiring();
            }
            if (FrameworkDTO.class.equals(adapterType)) {
                BundleContextImpl current = this.getBundleContextImpl();
                Map<String, String> configuration = this.equinoxContainer.getConfiguration().getConfiguration();
                this.readLock();
                try {
                    FrameworkDTO frameworkDTO = DTOBuilder.newFrameworkDTO(current, configuration);
                    return (A)frameworkDTO;
                }
                finally {
                    this.readUnlock();
                }
            }
            if (FrameworkStartLevelDTO.class.equals(adapterType)) {
                return (A)DTOBuilder.newFrameworkStartLevelDTO(this.module.getContainer().getFrameworkStartLevel());
            }
            if (FrameworkWiringDTO.class.equals(adapterType)) {
                this.readLock();
                try {
                    HashSet<BundleWiring> allWirings = new HashSet<BundleWiring>();
                    for (Module m : this.module.getContainer().getModules()) {
                        for (BundleRevision revision : m.getRevisions().getRevisions()) {
                            BundleWiring wiring = revision.getWiring();
                            if (wiring == null) continue;
                            allWirings.add(wiring);
                        }
                    }
                    for (ModuleRevision revision : this.module.getContainer().getRemovalPending()) {
                        ModuleWiring wiring = revision.getWiring();
                        if (wiring == null) continue;
                        allWirings.add(wiring);
                    }
                    FrameworkWiringDTO frameworkWiringDTO = DTOBuilder.newFrameworkWiringDTO(allWirings);
                    return (A)frameworkWiringDTO;
                }
                finally {
                    this.readUnlock();
                }
            }
        }
        if (Module.class.equals(adapterType)) {
            return (A)this.module;
        }
        if (ProtectionDomain.class.equals(adapterType)) {
            BundleInfo.Generation current = (BundleInfo.Generation)this.module.getCurrentRevision().getRevisionInfo();
            return (A)current.getDomain();
        }
        if (SignedContent.class.equals(adapterType)) {
            return (A)this.getSignedContent();
        }
        return null;
    }

    private SignedContent getSignedContent() {
        SignedContent current = this.signedContent;
        if (current == null) {
            SignedContentFactory factory = this.equinoxContainer.getSignedContentFactory();
            if (factory == null) {
                return null;
            }
            try {
                this.signedContent = current = factory.getSignedContent(this);
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException exception) {
                return null;
            }
        }
        return current;
    }

    private <A> void checkAdaptPermission(Class<A> adapterType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(new AdaptPermission(adapterType.getName(), this, "adapt"));
    }

    @Override
    public File getDataFile(String filename) {
        this.checkValid();
        BundleInfo.Generation current = (BundleInfo.Generation)this.module.getCurrentRevision().getRevisionInfo();
        return current.getBundleInfo().getDataFile(filename);
    }

    @Override
    public Bundle getBundle() {
        return this;
    }

    public Module getModule() {
        return this.module;
    }

    private final void checkValid() {
        if (this.module.getState().equals((Object)Module.State.UNINSTALLED)) {
            throw new IllegalStateException("Bundle has been uninstalled: " + this);
        }
    }

    public boolean isFragment() {
        return (this.getModule().getCurrentRevision().getTypes() & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startWorker0() throws BundleException {
        BundleContextImpl current = this.createBundleContext();
        if (current == null) {
            throw new BundleException("Unable to create bundle context! " + this);
        }
        try {
            current.start();
        }
        catch (BundleException e) {
            current.close();
            Object object = this.monitor;
            synchronized (object) {
                this.context = null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopWorker0() throws BundleException {
        BundleContextImpl current = this.getBundleContextImpl();
        if (current != null) {
            try {
                current.stop();
            }
            finally {
                current.close();
            }
            Object object = this.monitor;
            synchronized (object) {
                this.context = null;
            }
        }
    }

    ResolutionReport resolve() {
        if (!Module.RESOLVED_SET.contains((Object)this.module.getState())) {
            return this.module.getContainer().resolve(Collections.singletonList(this.module), true);
        }
        return null;
    }

    List<BundleInfo.Generation> getGenerations() {
        List<ModuleWire> hostWires;
        ArrayList<BundleInfo.Generation> result = new ArrayList<BundleInfo.Generation>();
        ModuleRevision current = this.getModule().getCurrentRevision();
        result.add((BundleInfo.Generation)current.getRevisionInfo());
        ModuleWiring wiring = current.getWiring();
        if (wiring != null && (hostWires = wiring.getProvidedModuleWires("osgi.wiring.host")) != null) {
            for (ModuleWire hostWire : hostWires) {
                result.add((BundleInfo.Generation)hostWire.getRequirer().getRevisionInfo());
            }
        }
        return result;
    }

    EquinoxContainer getEquinoxContainer() {
        return this.equinoxContainer;
    }

    public String toString() {
        String name = this.getSymbolicName();
        if (name == null) {
            name = "unknown";
        }
        return String.valueOf(name) + '_' + this.getVersion() + " [" + this.getBundleId() + "]";
    }

    private class EquinoxModule
    extends Module {
        @Override
        protected void startWorker() throws BundleException {
            EquinoxBundle.this.startWorker0();
        }

        @Override
        protected void stopWorker() throws BundleException {
            EquinoxBundle.this.stopWorker0();
        }

        public EquinoxModule(Long id, String location, ModuleContainer container, EnumSet<Module.Settings> settings, int startlevel) {
            super(id, location, container, settings, startlevel);
        }

        @Override
        public Bundle getBundle() {
            return EquinoxBundle.this;
        }

        @Override
        protected void cleanup(ModuleRevision revision) {
            BundleInfo.Generation generation = (BundleInfo.Generation)revision.getRevisionInfo();
            generation.delete();
            if (revision.equals(this.getCurrentRevision())) {
                generation.getBundleInfo().delete();
            }
        }
    }

    static class SystemBundle
    extends EquinoxBundle
    implements Framework {
        final List<FrameworkListener> initListeners = new ArrayList<FrameworkListener>(0);

        SystemBundle(ModuleContainer moduleContainer, EquinoxContainer equinoxContainer) {
            super(moduleContainer, equinoxContainer);
        }

        @Override
        public void init() throws BundleException {
            this.init(null);
        }

        public void init(FrameworkListener ... listeners) throws BundleException {
            if (listeners != null) {
                if (this.getEquinoxContainer().getConfiguration().getDebug().DEBUG_SYSTEM_BUNDLE) {
                    Debug.println("Initializing framework with framework listeners: " + listeners);
                }
                this.initListeners.addAll(Arrays.asList(listeners));
            } else if (this.getEquinoxContainer().getConfiguration().getDebug().DEBUG_SYSTEM_BUNDLE) {
                Debug.println("Initializing framework with framework no listeners");
            }
            try {
                ((SystemModule)this.getModule()).init();
            }
            finally {
                if (!this.initListeners.isEmpty()) {
                    this.getEquinoxContainer().getEventPublisher().flushFrameworkEvents();
                    this.removeInitListeners();
                }
            }
        }

        void addInitFrameworkListeners() {
            BundleContextImpl context = this.createBundleContext();
            for (FrameworkListener initListener : this.initListeners) {
                context.addFrameworkListener(initListener);
            }
        }

        void removeInitListeners() {
            BundleContextImpl context = this.createBundleContext();
            for (FrameworkListener initListener : this.initListeners) {
                context.removeFrameworkListener(initListener);
            }
            this.initListeners.clear();
        }

        @Override
        public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
            ModuleContainerAdaptor.ContainerEvent event = ((SystemModule)this.getModule()).waitForStop(timeout);
            return new FrameworkEvent(EquinoxContainerAdaptor.getType(event), this, null);
        }

        @Override
        Module createSystemModule(ModuleContainer moduleContainer) {
            return new EquinoxSystemModule(moduleContainer);
        }

        @Override
        public void stop(int options) throws BundleException {
            this.getEquinoxContainer().checkAdminPermission(this, "execute");
            ((EquinoxSystemModule)this.getModule()).asyncStop();
        }

        @Override
        public void stop() throws BundleException {
            this.stop(0);
        }

        @Override
        public void uninstall() throws BundleException {
            this.getEquinoxContainer().checkAdminPermission(this, "lifecycle");
            throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
        }

        @Override
        public Dictionary<String, String> getHeaders(String locale) {
            return new SystemBundleHeaders(super.getHeaders(locale));
        }

        class EquinoxSystemModule
        extends SystemModule {
            public EquinoxSystemModule(ModuleContainer container) {
                super(container);
            }

            @Override
            public Bundle getBundle() {
                return SystemBundle.this;
            }

            @Override
            protected void cleanup(ModuleRevision revision) {
            }

            @Override
            protected void initWorker() throws BundleException {
                EquinoxConfiguration config = SystemBundle.this.getEquinoxContainer().getConfiguration();
                String initUUID = config.setConfiguration("equinox.init.uuid", Boolean.TRUE.toString());
                if (initUUID != null) {
                    config.setConfiguration("org.osgi.framework.uuid", InternalUtils.newUUID(config));
                }
                SystemBundle.this.getEquinoxContainer().init();
                SystemBundle.this.addInitFrameworkListeners();
                SystemBundle.this.startWorker0();
            }

            @Override
            protected void stopWorker() throws BundleException {
                super.stopWorker();
                SystemBundle.this.stopWorker0();
                SystemBundle.this.getEquinoxContainer().close();
            }

            void asyncStop() throws BundleException {
                if (SystemBundle.this.getEquinoxContainer().getConfiguration().getDebug().DEBUG_SYSTEM_BUNDLE) {
                    Debug.printStackTrace(new Exception("Framework has been requested to stop."));
                }
                this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STOPPED);
                try {
                    if (Module.ACTIVE_SET.contains((Object)this.getState())) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    EquinoxSystemModule.this.stop(new Module.StopOptions[0]);
                                }
                                catch (Throwable e) {
                                    SystemBundle.this.getEquinoxContainer().getLogServices().log("org.eclipse.osgi", 4, "Error stopping the framework.", e);
                                }
                            }
                        }, "Framework stop - " + SystemBundle.this.getEquinoxContainer().toString());
                        t.start();
                    }
                }
                finally {
                    this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STOPPED);
                }
            }
        }

        class SystemBundleHeaders
        extends Dictionary<String, String> {
            private final Dictionary<String, String> headers;

            public SystemBundleHeaders(Dictionary<String, String> headers) {
                this.headers = headers;
            }

            @Override
            public Enumeration<String> elements() {
                return this.headers.elements();
            }

            @Override
            public String get(Object key) {
                if (!(key instanceof String)) {
                    return null;
                }
                String sKey = (String)key;
                if ("Export-Package".equalsIgnoreCase(sKey) || "Provide-Capability".equalsIgnoreCase(sKey)) {
                    String systemProp;
                    boolean useSystem;
                    String systemProvideHeader = SystemBundle.this.getEquinoxContainer().getConfiguration().getConfiguration("equinox.system.provide.header", "system.extra");
                    boolean useSystemExtra = systemProvideHeader.equals("system.extra");
                    boolean bl = useSystem = systemProvideHeader.equals("system") || useSystemExtra;
                    String string = useSystem ? ("Export-Package".equalsIgnoreCase(sKey) ? "org.osgi.framework.system.packages" : "org.osgi.framework.system.capabilities") : (systemProp = null);
                    String systemExtraProp = useSystemExtra ? ("Export-Package".equalsIgnoreCase(sKey) ? "org.osgi.framework.system.packages.extra" : "org.osgi.framework.system.capabilities.extra") : null;
                    return this.getExtra(sKey, systemProp, systemExtraProp);
                }
                return this.headers.get(key);
            }

            private String getExtra(String header, String systemProp, String systemExtraProp) {
                String systemExtraValue;
                String systemValue = systemProp != null ? SystemBundle.this.getEquinoxContainer().getConfiguration().getConfiguration(systemProp) : null;
                String string = systemExtraValue = systemExtraProp != null ? SystemBundle.this.getEquinoxContainer().getConfiguration().getConfiguration(systemExtraProp) : null;
                if (systemValue == null) {
                    systemValue = systemExtraValue;
                } else if (systemExtraValue != null && systemExtraValue.trim().length() > 0) {
                    systemValue = String.valueOf(systemValue) + ", " + systemExtraValue;
                }
                String result = this.headers.get(header);
                if (systemValue != null && systemValue.trim().length() > 0) {
                    result = result != null ? String.valueOf(result) + ", " + systemValue : systemValue;
                }
                return result;
            }

            @Override
            public boolean isEmpty() {
                return this.headers.isEmpty();
            }

            @Override
            public Enumeration<String> keys() {
                return this.headers.keys();
            }

            @Override
            public String put(String key, String value) {
                return this.headers.put(key, value);
            }

            @Override
            public String remove(Object key) {
                return this.headers.remove(key);
            }

            @Override
            public int size() {
                return this.headers.size();
            }
        }
    }
}

