/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.ResolverImpl;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleResolutionReport;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.eclipse.osgi.internal.container.NamespaceList;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

final class ModuleResolver {
    static final String SEPARATOR = System.lineSeparator();
    boolean DEBUG_ROOTS = false;
    boolean DEBUG_PROVIDERS = false;
    boolean DEBUG_HOOKS = false;
    boolean DEBUG_USES = false;
    boolean DEBUG_WIRING = false;
    boolean DEBUG_REPORT = false;
    private static final int BATCH_MIN_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private static final int DEFAULT_BATCH_TIMEOUT = (int)TimeUnit.MINUTES.toMillis(2L);
    final int resolverRevisionBatchSize;
    final int resolverBatchTimeout;
    static final Collection<String> NON_PAYLOAD_CAPABILITIES = Arrays.asList("osgi.identity");
    static final Collection<String> NON_PAYLOAD_REQUIREMENTS = Arrays.asList("osgi.wiring.host", "osgi.ee");
    static final Collection<String> NON_SUBSTITUTED_REQUIREMENTS = Arrays.asList("osgi.wiring.package", "osgi.wiring.bundle");
    final ThreadLocal<Boolean> threadResolving = new ThreadLocal();
    final ModuleContainerAdaptor adaptor;

    void setDebugOptions() {
        DebugOptions options = this.adaptor.getDebugOptions();
        if (options == null) {
            return;
        }
        boolean debugAll = options.getBooleanOption("org.eclipse.osgi/resolver", false);
        this.DEBUG_ROOTS = debugAll || options.getBooleanOption("org.eclipse.osgi/resolver/roots", false);
        this.DEBUG_PROVIDERS = debugAll || options.getBooleanOption("org.eclipse.osgi/resolver/providers", false);
        this.DEBUG_HOOKS = debugAll || options.getBooleanOption("org.eclipse.osgi/resolver/hooks", false);
        this.DEBUG_USES = debugAll || options.getBooleanOption("org.eclipse.osgi/resolver/uses", false);
        this.DEBUG_WIRING = debugAll || options.getBooleanOption("org.eclipse.osgi/resolver/wiring", false);
        this.DEBUG_REPORT = debugAll || options.getBooleanOption("org.eclipse.osgi/resolver/report", false);
    }

    ModuleResolver(ModuleContainerAdaptor adaptor) {
        this.adaptor = adaptor;
        this.setDebugOptions();
        String batchSizeConfig = this.adaptor.getProperty("equinox.resolver.revision.batch.size");
        this.resolverRevisionBatchSize = ModuleResolver.parseInteger(batchSizeConfig, Integer.MAX_VALUE, 1);
        String batchTimeoutConfig = this.adaptor.getProperty("equinox.resolver.batch.timeout");
        this.resolverBatchTimeout = ModuleResolver.parseInteger(batchTimeoutConfig, DEFAULT_BATCH_TIMEOUT, BATCH_MIN_TIMEOUT);
    }

    private static int parseInteger(String sInteger, int defaultValue, int minValue) {
        try {
            int result = sInteger == null ? defaultValue : Integer.parseInt(sInteger);
            return result < minValue ? minValue : result;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    ModuleResolutionReport resolveDelta(Collection<ModuleRevision> triggers, boolean triggersMandatory, Collection<ModuleRevision> unresolved, Map<ModuleRevision, ModuleWiring> wiringCopy, ModuleDatabase moduleDatabase) {
        ResolveProcess resolveProcess = new ResolveProcess(unresolved, triggers, triggersMandatory, wiringCopy, moduleDatabase);
        return resolveProcess.resolve();
    }

    ModuleResolutionReport resolveDynamicDelta(ModuleRequirement.DynamicModuleRequirement dynamicReq, Collection<ModuleRevision> unresolved, Map<ModuleRevision, ModuleWiring> wiringCopy, ModuleDatabase moduleDatabase) {
        ResolveProcess resolveProcess = new ResolveProcess(unresolved, dynamicReq, wiringCopy, moduleDatabase);
        return resolveProcess.resolve();
    }

    Map<ModuleRevision, ModuleWiring> generateDelta(Map<Resource, List<Wire>> result, Map<ModuleRevision, ModuleWiring> wiringCopy) {
        ModuleWiring existingWiring;
        HashMap<ModuleRevision, Map<ModuleCapability, List<ModuleWire>>> provided = new HashMap<ModuleRevision, Map<ModuleCapability, List<ModuleWire>>>();
        HashMap<ModuleRevision, List<ModuleWire>> required = new HashMap<ModuleRevision, List<ModuleWire>>();
        for (Map.Entry<Resource, List<Wire>> resultEntry : result.entrySet()) {
            ModuleRevision revision = (ModuleRevision)resultEntry.getKey();
            ArrayList<ModuleWire> requiredWires = new ArrayList<ModuleWire>(resultEntry.getValue().size());
            ArrayList<String> seen = new ArrayList<String>(5);
            for (Wire wire : resultEntry.getValue()) {
                ArrayList<ModuleWire> providedWires;
                ModuleWire moduleWire = new ModuleWire((ModuleCapability)wire.getCapability(), (ModuleRevision)wire.getProvider(), (ModuleRequirement)wire.getRequirement(), (ModuleRevision)wire.getRequirer());
                requiredWires.add(this.getInsertIndex(moduleWire.getCapability().getNamespace(), requiredWires, seen, NamespaceList.WIRE), moduleWire);
                HashMap<ModuleCapability, ArrayList<ModuleWire>> providedWiresMap = (HashMap<ModuleCapability, ArrayList<ModuleWire>>)provided.get(moduleWire.getProvider());
                if (providedWiresMap == null) {
                    providedWiresMap = new HashMap<ModuleCapability, ArrayList<ModuleWire>>();
                    provided.put(moduleWire.getProvider(), providedWiresMap);
                }
                if ((providedWires = (ArrayList<ModuleWire>)providedWiresMap.get(moduleWire.getCapability())) == null) {
                    providedWires = new ArrayList<ModuleWire>();
                    providedWiresMap.put(moduleWire.getCapability(), providedWires);
                }
                providedWires.add(moduleWire);
            }
            required.put(revision, requiredWires);
        }
        HashMap<ModuleRevision, ModuleWiring> delta = new HashMap<ModuleRevision, ModuleWiring>();
        for (ModuleRevision revision : required.keySet()) {
            existingWiring = wiringCopy.get(revision);
            if (existingWiring == null) {
                delta.put(revision, this.createNewWiring(revision, provided, required));
                continue;
            }
            delta.put(revision, ModuleResolver.createWiringDelta(revision, existingWiring, (Map)provided.get(revision), (List)required.get(revision)));
        }
        for (ModuleRevision revision : provided.keySet()) {
            existingWiring = wiringCopy.get(revision);
            if (existingWiring == null || delta.containsKey(revision)) continue;
            delta.put(revision, ModuleResolver.createWiringDelta(revision, existingWiring, (Map)provided.get(revision), (List)required.get(revision)));
        }
        return delta;
    }

    private ModuleWiring createNewWiring(ModuleRevision revision, Map<ModuleRevision, Map<ModuleCapability, List<ModuleWire>>> provided, Map<ModuleRevision, List<ModuleWire>> required) {
        List<ModuleWire> requiredWires;
        Map<ModuleCapability, List<ModuleWire>> providedWireMap = provided.get(revision);
        if (providedWireMap == null) {
            providedWireMap = Collections.emptyMap();
        }
        if ((requiredWires = required.get(revision)) == null) {
            requiredWires = Collections.emptyList();
        }
        List<ModuleCapability> capabilities = this.sortByNamespaceCopy(revision.getModuleCapabilities(null), NamespaceList.CAPABILITY);
        ListIterator<ModuleCapability> iCapabilities = capabilities.listIterator(capabilities.size());
        List<ModuleRequirement> requirements = this.sortByNamespaceCopy(revision.getModuleRequirements(null), NamespaceList.REQUIREMENT);
        ListIterator<ModuleRequirement> iRequirements = requirements.listIterator(requirements.size());
        if ((1 & revision.getTypes()) != 0) {
            ModuleResolver.removePayloadContent(iCapabilities, iRequirements);
        } else {
            ModuleCapability hostCapability;
            List<ModuleCapability> hostCapabilities = revision.getModuleCapabilities("osgi.wiring.host");
            ModuleCapability moduleCapability = hostCapability = hostCapabilities.isEmpty() ? null : hostCapabilities.get(0);
            if (hostCapability != null) {
                ModuleResolver.addPayloadContent(providedWireMap.get(hostCapability), iCapabilities, iRequirements);
            }
        }
        this.removeNonEffectiveCapabilities(iCapabilities);
        ModuleResolver.removeNonEffectiveRequirements(iRequirements, requiredWires);
        Collection<String> substituted = ModuleResolver.removeSubstitutedCapabilities(iCapabilities, requiredWires);
        ArrayList<ModuleWire> providedWires = new ArrayList<ModuleWire>();
        ModuleResolver.addProvidedWires(providedWireMap, providedWires, capabilities);
        InternalUtils.filterCapabilityPermissions(capabilities);
        return new ModuleWiring(revision, new NamespaceList<ModuleCapability>(capabilities, NamespaceList.CAPABILITY), new NamespaceList<ModuleRequirement>(requirements, NamespaceList.REQUIREMENT), new NamespaceList<ModuleWire>(providedWires, NamespaceList.WIRE), new NamespaceList<ModuleWire>(requiredWires, NamespaceList.WIRE), substituted);
    }

    private <E> List<E> sortByNamespaceCopy(List<E> elements, Function<E, String> getNamespace) {
        ArrayList<E> result = new ArrayList<E>(elements.size());
        ArrayList<String> seen = new ArrayList<String>();
        for (E e : elements) {
            String namespace = getNamespace.apply(e);
            result.add(this.getInsertIndex(namespace, result, seen, getNamespace), e);
        }
        return result;
    }

    private <E> int getInsertIndex(String namespace, List<E> elements, List<String> seen, Function<E, String> getNamespace) {
        if (seen.contains(namespace)) {
            int i = elements.size() - 1;
            while (i > -1) {
                if (namespace.equals(getNamespace.apply(elements.get(i)))) {
                    return i + 1;
                }
                --i;
            }
            throw new IllegalStateException();
        }
        seen.add(namespace);
        return elements.size();
    }

    private static void removePayloadContent(ListIterator<ModuleCapability> iCapabilities, ListIterator<ModuleRequirement> iRequirements) {
        ModuleResolver.rewind(iCapabilities);
        while (iCapabilities.hasNext()) {
            if (NON_PAYLOAD_CAPABILITIES.contains(iCapabilities.next().getNamespace())) continue;
            iCapabilities.remove();
        }
        ModuleResolver.rewind(iRequirements);
        while (iRequirements.hasNext()) {
            if (NON_PAYLOAD_REQUIREMENTS.contains(iRequirements.next().getNamespace())) continue;
            iRequirements.remove();
        }
    }

    private static Collection<String> removeSubstitutedCapabilities(ListIterator<ModuleCapability> iCapabilities, List<ModuleWire> requiredWires) {
        ArrayList<String> substituted = null;
        for (ModuleWire moduleWire : requiredWires) {
            if (!"osgi.wiring.package".equals(moduleWire.getCapability().getNamespace())) continue;
            String packageName = (String)moduleWire.getCapability().getAttributes().get("osgi.wiring.package");
            ModuleResolver.rewind(iCapabilities);
            while (iCapabilities.hasNext()) {
                ModuleCapability capability = iCapabilities.next();
                if (!"osgi.wiring.package".equals(capability.getNamespace()) || !packageName.equals(capability.getAttributes().get("osgi.wiring.package"))) continue;
                iCapabilities.remove();
                if (substituted == null) {
                    substituted = new ArrayList<String>();
                }
                if (substituted.contains(packageName)) continue;
                substituted.add(packageName);
            }
        }
        return substituted == null ? Collections.emptyList() : substituted;
    }

    private static void removeNonEffectiveRequirements(ListIterator<ModuleRequirement> iRequirements, List<ModuleWire> requiredWires) {
        HashSet<ModuleRequirement> wireRequirements = new HashSet<ModuleRequirement>();
        for (ModuleWire mw : requiredWires) {
            wireRequirements.add(mw.getRequirement());
        }
        ModuleResolver.rewind(iRequirements);
        while (iRequirements.hasNext()) {
            ModuleRequirement requirement = iRequirements.next();
            String effective = requirement.getDirectives().get("effective");
            if (effective != null && !"resolve".equals(effective)) {
                iRequirements.remove();
                continue;
            }
            if (wireRequirements.contains(requirement)) continue;
            if (!"osgi.wiring.package".equals(requirement.getNamespace())) {
                iRequirements.remove();
                continue;
            }
            String resolution = requirement.getDirectives().get("resolution");
            if ("dynamic".equals(resolution)) continue;
            iRequirements.remove();
        }
    }

    void removeNonEffectiveCapabilities(ListIterator<ModuleCapability> iCapabilities) {
        ModuleResolver.rewind(iCapabilities);
        while (iCapabilities.hasNext()) {
            Capability capability = iCapabilities.next();
            String effective = capability.getDirectives().get("effective");
            if (effective == null || "resolve".equals(effective)) continue;
            iCapabilities.remove();
            if (!this.DEBUG_PROVIDERS) continue;
            Debug.println("RESOLVER: Capability filtered because it was not effective" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
        }
    }

    private static void addPayloadContent(List<ModuleWire> hostWires, ListIterator<ModuleCapability> iCapabilities, ListIterator<ModuleRequirement> iRequirements) {
        if (hostWires == null) {
            return;
        }
        for (ModuleWire hostWire : hostWires) {
            String currentNamespace = null;
            List<ModuleCapability> fragmentCapabilities = hostWire.getRequirer().getModuleCapabilities(null);
            for (ModuleCapability fragmentCapability : fragmentCapabilities) {
                String effective;
                if (NON_PAYLOAD_CAPABILITIES.contains(fragmentCapability.getNamespace()) || (effective = fragmentCapability.getDirectives().get("effective")) != null && !"resolve".equals(effective)) continue;
                if (!fragmentCapability.getNamespace().equals(currentNamespace)) {
                    currentNamespace = fragmentCapability.getNamespace();
                    ModuleResolver.fastForward(iCapabilities);
                    while (iCapabilities.hasPrevious()) {
                        if (!iCapabilities.previous().getNamespace().equals(currentNamespace)) continue;
                        iCapabilities.next();
                        break;
                    }
                }
                if (!iCapabilities.hasPrevious()) {
                    ModuleResolver.fastForward(iCapabilities);
                }
                iCapabilities.add(fragmentCapability);
            }
            currentNamespace = null;
            List<ModuleRequirement> fragmentRequriements = hostWire.getRequirer().getModuleRequirements(null);
            for (ModuleRequirement fragmentRequirement : fragmentRequriements) {
                String effective;
                if (NON_PAYLOAD_REQUIREMENTS.contains(fragmentRequirement.getNamespace()) || (effective = fragmentRequirement.getDirectives().get("effective")) != null && !"resolve".equals(effective)) continue;
                if (!fragmentRequirement.getNamespace().equals(currentNamespace)) {
                    currentNamespace = fragmentRequirement.getNamespace();
                    boolean isDynamic = ModuleResolver.isDynamic(fragmentRequirement);
                    ModuleResolver.fastForward(iRequirements);
                    while (iRequirements.hasPrevious()) {
                        ModuleRequirement previous = iRequirements.previous();
                        if (!previous.getNamespace().equals(currentNamespace) || !isDynamic && ModuleResolver.isDynamic(previous)) continue;
                        iRequirements.next();
                        break;
                    }
                }
                if (!iRequirements.hasPrevious()) {
                    ModuleResolver.fastForward(iRequirements);
                }
                iRequirements.add(fragmentRequirement);
            }
        }
    }

    static boolean isDynamic(Requirement requirement) {
        return "osgi.wiring.package".equals(requirement.getNamespace()) && "dynamic".equals(requirement.getDirectives().get("resolution"));
    }

    private static void addProvidedWires(Map<ModuleCapability, List<ModuleWire>> toAdd, List<ModuleWire> existing, final List<ModuleCapability> orderedCapabilities) {
        if (toAdd == null) {
            return;
        }
        int originalSize = existing.size();
        for (ModuleCapability capability : orderedCapabilities) {
            List<ModuleWire> newWires = toAdd.get(capability);
            if (newWires == null) continue;
            existing.addAll(newWires);
        }
        if (originalSize != 0) {
            Collections.sort(existing, new Comparator<ModuleWire>(){

                @Override
                public int compare(ModuleWire w1, ModuleWire w2) {
                    int index1 = orderedCapabilities.indexOf(w1.getCapability());
                    int index2 = orderedCapabilities.indexOf(w2.getCapability());
                    return index1 - index2;
                }
            });
        }
    }

    private static void addRequiredWires(List<ModuleWire> toAdd, List<ModuleWire> existing, final List<ModuleRequirement> orderedRequirements) {
        if (toAdd == null) {
            return;
        }
        int originalSize = existing.size();
        existing.addAll(toAdd);
        if (originalSize != 0) {
            Collections.sort(existing, new Comparator<ModuleWire>(){

                @Override
                public int compare(ModuleWire w1, ModuleWire w2) {
                    int index1 = orderedRequirements.indexOf(w1.getRequirement());
                    int index2 = orderedRequirements.indexOf(w2.getRequirement());
                    return index1 - index2;
                }
            });
        }
    }

    private static void fastForward(ListIterator<?> listIterator) {
        while (listIterator.hasNext()) {
            listIterator.next();
        }
    }

    static void rewind(ListIterator<?> listIterator) {
        while (listIterator.hasPrevious()) {
            listIterator.previous();
        }
    }

    private static ModuleWiring createWiringDelta(ModuleRevision revision, ModuleWiring existingWiring, Map<ModuleCapability, List<ModuleWire>> providedWireMap, List<ModuleWire> requiredWires) {
        List<ModuleWire> existingProvidedWires = existingWiring.getProvidedWires().copyList();
        List<ModuleCapability> existingCapabilities = existingWiring.getCapabilities().copyList();
        List<ModuleWire> existingRequiredWires = existingWiring.getRequiredWires().copyList();
        List<ModuleRequirement> existingRequirements = existingWiring.getRequirements().copyList();
        if (providedWireMap != null) {
            List<ModuleWire> newHostWires;
            List<ModuleCapability> hostCapabilities = revision.getModuleCapabilities("osgi.wiring.host");
            ModuleCapability hostCapability = hostCapabilities.isEmpty() ? null : hostCapabilities.get(0);
            List<ModuleWire> list = newHostWires = hostCapability == null ? null : providedWireMap.get(hostCapability);
            if (newHostWires != null) {
                ModuleResolver.addPayloadContent(newHostWires, existingCapabilities.listIterator(), existingRequirements.listIterator());
            }
        }
        ModuleResolver.addProvidedWires(providedWireMap, existingProvidedWires, existingCapabilities);
        ModuleResolver.addRequiredWires(requiredWires, existingRequiredWires, existingRequirements);
        InternalUtils.filterCapabilityPermissions(existingCapabilities);
        return new ModuleWiring(revision, existingCapabilities, existingRequirements, existingProvidedWires, existingRequiredWires, existingWiring.getSubstitutedNames());
    }

    static boolean isSingleton(ModuleRevision revision) {
        List<Capability> identities = revision.getCapabilities("osgi.identity");
        if (identities.isEmpty()) {
            return false;
        }
        return "true".equals(identities.get(0).getDirectives().get("singleton"));
    }

    static Version getVersion(Capability c) {
        String versionAttr = null;
        String namespace = c.getNamespace();
        versionAttr = "osgi.identity".equals(namespace) ? "version" : ("osgi.wiring.package".equals(namespace) ? "version" : ("osgi.wiring.bundle".equals(namespace) ? "bundle-version" : ("osgi.wiring.host".equals(namespace) ? "bundle-version" : "version")));
        Object version = c.getAttributes().get(versionAttr);
        return version instanceof Version ? (Version)version : Version.emptyVersion;
    }

    protected boolean threadResolving() {
        Boolean resolvingValue = this.threadResolving.get();
        if (resolvingValue == null) {
            return false;
        }
        return resolvingValue;
    }

    class ResolveProcess
    extends ResolveContext
    implements Comparator<Capability>,
    Executor {
        private final ModuleResolutionReport.Builder reportBuilder = new ModuleResolutionReport.Builder();
        private final Collection<ModuleRevision> unresolved;
        private final Collection<ModuleRevision> disabled;
        private final Collection<ModuleRevision> triggers;
        private final Collection<ModuleRevision> optionals;
        private final boolean triggersMandatory;
        final ModuleDatabase moduleDatabase;
        final Map<ModuleRevision, ModuleWiring> wirings;
        private final Set<ModuleRevision> previouslyResolved;
        private final ModuleRequirement.DynamicModuleRequirement dynamicReq;
        private volatile ResolverHook hook = null;
        private volatile Map<String, Collection<ModuleRevision>> byName = null;
        private volatile List<Resource> currentlyResolving = null;
        private volatile boolean currentlyResolvingMandatory = false;
        private final Set<Resource> transitivelyResolveFailures = new LinkedHashSet<Resource>();
        private final Set<Resource> failedToResolve = new HashSet<Resource>();
        private AtomicBoolean scheduleTimeout = new AtomicBoolean(true);
        private AtomicReference<ScheduledFuture<?>> timoutFuture = new AtomicReference();
        private final Map<Resource, Map<Requirement, Set<Capability>>> unresolvedProviders = new HashMap<Resource, Map<Requirement, Set<Capability>>>();

        ResolveProcess(Collection<ModuleRevision> unresolved, Collection<ModuleRevision> triggers, boolean triggersMandatory, Map<ModuleRevision, ModuleWiring> wirings, ModuleDatabase moduleDatabase) {
            this.unresolved = unresolved;
            this.disabled = new HashSet<ModuleRevision>(unresolved);
            this.triggers = new ArrayList<ModuleRevision>(triggers);
            this.triggersMandatory = triggersMandatory;
            this.optionals = new LinkedHashSet<ModuleRevision>(unresolved);
            if (this.triggersMandatory) {
                for (ModuleRevision triggerRevision : triggers) {
                    this.optionals.remove(triggerRevision);
                }
            }
            this.wirings = new HashMap<ModuleRevision, ModuleWiring>(wirings);
            this.previouslyResolved = new HashSet<ModuleRevision>(wirings.keySet());
            this.moduleDatabase = moduleDatabase;
            this.dynamicReq = null;
        }

        ResolveProcess(Collection<ModuleRevision> unresolved, ModuleRequirement.DynamicModuleRequirement dynamicReq, Map<ModuleRevision, ModuleWiring> wirings, ModuleDatabase moduleDatabase) {
            this.unresolved = unresolved;
            this.disabled = new HashSet<ModuleRevision>(unresolved);
            ModuleRevision revision = dynamicReq.getRevision();
            this.triggers = new ArrayList<ModuleRevision>(1);
            this.triggers.add(revision);
            this.triggersMandatory = false;
            this.optionals = new ArrayList<ModuleRevision>(unresolved);
            this.wirings = wirings;
            this.previouslyResolved = new HashSet<ModuleRevision>(wirings.keySet());
            this.moduleDatabase = moduleDatabase;
            this.dynamicReq = dynamicReq;
        }

        @Override
        public List<Capability> findProviders(Requirement requirement) {
            Requirement origReq = requirement;
            Requirement lookupReq = this.dynamicReq == null || this.dynamicReq.getOriginal() != requirement ? requirement : this.dynamicReq;
            return this.findProviders0(origReq, lookupReq);
        }

        private List<Capability> findProviders0(Requirement origReq, Requirement lookupReq) {
            if (ModuleResolver.this.DEBUG_PROVIDERS) {
                Debug.println("RESOLVER: Finding capabilities for requirement" + SEPARATOR + '\t' + origReq + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + origReq.getResource());
            }
            List<ModuleCapability> candidates = this.moduleDatabase.findCapabilities(lookupReq);
            List<Capability> result = this.filterProviders(origReq, candidates);
            if (ModuleResolver.this.DEBUG_PROVIDERS) {
                StringBuilder builder = new StringBuilder("RESOLVER: Capabilities being returned to the resolver");
                int i = 0;
                for (Capability capability : result) {
                    builder.append(SEPARATOR).append('\t').append("[").append(++i).append("] ").append(capability).append(SEPARATOR).append('\t').append('\t').append("of resource").append(SEPARATOR).append('\t').append('\t').append('\t').append(capability.getResource());
                }
                Debug.println(builder.toString());
            }
            return result;
        }

        private List<Capability> filterProviders(Requirement requirement, List<ModuleCapability> candidates) {
            return this.filterProviders(requirement, candidates, true);
        }

        List<Capability> filterProviders(Requirement requirement, List<ModuleCapability> candidates, boolean filterResolvedHosts) {
            ListIterator<ModuleCapability> iCandidates = candidates.listIterator();
            this.filterDisabled(iCandidates);
            ModuleResolver.this.removeNonEffectiveCapabilities(iCandidates);
            this.removeSubstituted(iCandidates);
            this.filterPermissions((BundleRequirement)requirement, iCandidates);
            ArrayList<ModuleCapability> filteredMatches = null;
            if (ModuleResolver.this.DEBUG_PROVIDERS || ModuleResolver.this.DEBUG_HOOKS) {
                filteredMatches = new ArrayList<ModuleCapability>(candidates);
            }
            this.hook.filterMatches((BundleRequirement)requirement, InternalUtils.asListBundleCapability(candidates));
            if (ModuleResolver.this.DEBUG_PROVIDERS || ModuleResolver.this.DEBUG_HOOKS) {
                filteredMatches.removeAll(candidates);
                if (!filteredMatches.isEmpty()) {
                    StringBuilder builder = new StringBuilder("RESOLVER: Capabilities filtered by ResolverHook.filterMatches");
                    int i = 0;
                    for (Capability capability : filteredMatches) {
                        builder.append(SEPARATOR).append('\t').append("[").append(++i).append("] ").append(capability).append(SEPARATOR).append('\t').append('\t').append("of resource").append(SEPARATOR).append('\t').append('\t').append('\t').append(capability.getResource());
                    }
                    Debug.println(builder.toString());
                }
            }
            this.filterResolvedHosts(requirement, candidates, filterResolvedHosts);
            if (candidates.isEmpty()) {
                if (!this.wirings.containsKey(requirement.getResource()) || ModuleResolver.isDynamic(requirement)) {
                    this.reportBuilder.addEntry(requirement.getResource(), ResolutionReport.Entry.Type.MISSING_CAPABILITY, requirement);
                    String resolution = requirement.getDirectives().get("resolution");
                    if (resolution == null || "mandatory".equals(resolution)) {
                        this.transitivelyResolveFailures.add(requirement.getResource());
                    }
                }
            } else {
                this.computeUnresolvedProviders(requirement, candidates);
            }
            this.filterFailedToResolve(candidates);
            Collections.sort(candidates, this);
            return InternalUtils.asListCapability(candidates);
        }

        private void filterFailedToResolve(List<ModuleCapability> candidates) {
            Iterator<ModuleCapability> iCandidates = candidates.iterator();
            while (iCandidates.hasNext()) {
                ModuleCapability capability = iCandidates.next();
                if (!this.failedToResolve.contains(capability.getRevision())) continue;
                iCandidates.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because its resource was not resolved" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
            }
        }

        private void filterResolvedHosts(Requirement requirement, List<ModuleCapability> candidates, boolean filterResolvedHosts) {
            if (filterResolvedHosts && "osgi.wiring.host".equals(requirement.getNamespace())) {
                Iterator<ModuleCapability> iCandidates = candidates.iterator();
                while (iCandidates.hasNext()) {
                    if (!this.wirings.containsKey(iCandidates.next().getRevision())) continue;
                    iCandidates.remove();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void filterPermissions(BundleRequirement requirement, ListIterator<ModuleCapability> iCandidates) {
            ModuleResolver.rewind(iCandidates);
            if (System.getSecurityManager() == null || !iCandidates.hasNext()) {
                return;
            }
            if (requirement.getRevision().getBundle() != null) ** GOTO lbl19
            return;
lbl-1000:
            // 1 sources

            {
                candidate = iCandidates.next();
                if ("osgi.wiring.package".equals(requirement.getNamespace()) && requirement.getRevision().equals(candidate.getRevision())) continue;
                requirePermission = InternalUtils.getRequirePermission(candidate);
                providePermission = InternalUtils.getProvidePermission(candidate);
                if (!requirement.getRevision().getBundle().hasPermission(requirePermission)) {
                    iCandidates.remove();
                    if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                    Debug.println("RESOLVER: Capability filtered because requirer did not have permission" + ModuleResolver.SEPARATOR + '\t' + candidate + ModuleResolver.SEPARATOR + '\t' + '\t' + "of resource" + ModuleResolver.SEPARATOR + '\t' + '\t' + '\t' + candidate.getResource());
                    continue;
                }
                if (candidate.getRevision().getBundle().hasPermission(providePermission)) continue;
                iCandidates.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because provider did not have permission" + ModuleResolver.SEPARATOR + '\t' + candidate + ModuleResolver.SEPARATOR + '\t' + '\t' + "of resource" + ModuleResolver.SEPARATOR + '\t' + '\t' + '\t' + candidate.getResource());
lbl19:
                // 7 sources

                ** while (iCandidates.hasNext())
            }
lbl20:
            // 1 sources

        }

        private void filterDisabled(ListIterator<ModuleCapability> iCandidates) {
            ModuleResolver.rewind(iCandidates);
            while (iCandidates.hasNext()) {
                Capability capability = iCandidates.next();
                if (!this.disabled.contains(capability.getResource())) continue;
                iCandidates.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because it was disabled" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
            }
        }

        private void removeSubstituted(ListIterator<ModuleCapability> iCapabilities) {
            ModuleResolver.rewind(iCapabilities);
            while (iCapabilities.hasNext()) {
                ModuleCapability capability = iCapabilities.next();
                ModuleWiring wiring = this.wirings.get(capability.getRevision());
                if (wiring == null || !wiring.isSubtituted(capability)) continue;
                iCapabilities.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because it was substituted" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
            }
        }

        @Override
        public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
            int index = Collections.binarySearch(capabilities, hostedCapability, this);
            if (index < 0) {
                index = -index - 1;
            }
            capabilities.add(index, hostedCapability);
            return index;
        }

        @Override
        public boolean isEffective(Requirement requirement) {
            String effective = requirement.getDirectives().get("effective");
            return effective == null || "resolve".equals(effective);
        }

        @Override
        public Map<Resource, Wiring> getWirings() {
            Map<ModuleRevision, ModuleWiring> raw = this.wirings;
            return Collections.unmodifiableMap(raw);
        }

        @Override
        public Collection<Resource> getMandatoryResources() {
            if (this.currentlyResolvingMandatory) {
                return Collections.unmodifiableList(this.currentlyResolving);
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<Resource> getOptionalResources() {
            if (!this.currentlyResolvingMandatory) {
                return Collections.unmodifiableList(this.currentlyResolving);
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<Resource> findRelatedResources(Resource host) {
            List<ModuleCapability> hostCaps = ((ModuleRevision)host).getModuleCapabilities("osgi.wiring.host");
            if (hostCaps.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Resource> relatedFragments = new ArrayList<Resource>();
            for (String hostBSN : this.getHostBSNs(hostCaps)) {
                String matchFilter = "(equinox.fragment=" + hostBSN + ")";
                Requirement fragmentRequirement = ModuleContainer.createRequirement("equinox.fragment", Collections.singletonMap("filter", matchFilter), Collections.emptyMap());
                List<ModuleCapability> candidates = this.moduleDatabase.findCapabilities(fragmentRequirement);
                this.filterDisabled(candidates.listIterator());
                block1: for (ModuleCapability candidate : candidates) {
                    ModuleRequirement hostReq = candidate.getRevision().getModuleRequirements("osgi.wiring.host").get(0);
                    for (ModuleCapability hostCap : hostCaps) {
                        if (!hostReq.matches(hostCap)) continue;
                        relatedFragments.add(candidate.getResource());
                        continue block1;
                    }
                }
            }
            return relatedFragments;
        }

        private Collection<String> getHostBSNs(List<ModuleCapability> hostCaps) {
            if (hostCaps.size() == 1) {
                return this.getHostBSNs(hostCaps.get(0));
            }
            HashSet<String> result = new HashSet<String>();
            for (ModuleCapability hostCap : hostCaps) {
                result.addAll(this.getHostBSNs(hostCap));
            }
            return result;
        }

        private Collection<String> getHostBSNs(ModuleCapability moduleCapability) {
            Object namesAttr = moduleCapability.getAttributes().get("osgi.wiring.host");
            if (namesAttr instanceof String) {
                return Collections.singletonList((String)namesAttr);
            }
            if (namesAttr instanceof String[]) {
                return Arrays.asList((String[])namesAttr);
            }
            if (namesAttr instanceof Collection) {
                return (Collection)namesAttr;
            }
            return Collections.emptyList();
        }

        /*
         * Unable to fully structure code
         */
        ModuleResolutionReport resolve() {
            block37: {
                block34: {
                    block36: {
                        block35: {
                            if (ModuleResolver.this.threadResolving()) {
                                throw new IllegalStateException(Msg.ModuleResolver_RecursiveError);
                            }
                            ModuleResolver.this.threadResolving.set(Boolean.TRUE);
                            try {
                                this.hook = ModuleResolver.this.adaptor.getResolverHookFactory().begin(InternalUtils.asListBundleRevision((List)this.triggers));
                            }
                            catch (RuntimeException e) {
                                if (e.getCause() instanceof BundleException && (be = (BundleException)e.getCause()).getType() == 12) {
                                    var13_5 = new ModuleResolutionReport(null, Collections.emptyMap(), new ResolutionException(be));
                                    ModuleResolver.this.threadResolving.set(Boolean.FALSE);
                                    return var13_5;
                                }
                                throw e;
                            }
                            result = null;
                            re = null;
                            logger = new ResolveLogger();
                            try {
                                try {
                                    this.filterResolvable();
                                    this.selectSingletons();
                                    this.optionals.removeAll(this.disabled);
                                    if (this.triggers.removeAll(this.disabled) && this.triggersMandatory) {
                                        throw new ResolutionException(String.valueOf(Msg.ModuleResolver_SingletonDisabledError) + this.disabled);
                                    }
                                    if (this.dynamicReq != null) {
                                        result = this.resolveDynamic();
                                    } else {
                                        result = new HashMap<Resource, List<Wire>>();
                                        dynamicAttachWirings = this.resolveNonPayLoadFragments();
                                        this.applyInterimResultToWiringCopy(dynamicAttachWirings);
                                        if (!dynamicAttachWirings.isEmpty()) {
                                            fragmentResources = dynamicAttachWirings.keySet();
                                            this.triggers.removeAll(fragmentResources);
                                            this.optionals.removeAll(fragmentResources);
                                            result.putAll(dynamicAttachWirings);
                                        }
                                        if (this.triggersMandatory) {
                                            this.resolveRevisionsInBatch(this.triggers, true, logger, result);
                                        }
                                        this.resolveRevisionsInBatch(this.optionals, false, logger, result);
                                    }
                                    break block34;
                                }
                                catch (ResolutionException e) {
                                    re = e;
                                    f = this.timoutFuture.getAndSet(null);
                                    if (f != null) {
                                        f.cancel(true);
                                    }
                                    this.computeUnresolvedProviderResolutionReportEntries(result);
                                    this.computeUsesConstraintViolations(logger.getUsesConstraintViolations());
                                    if (ModuleResolver.this.DEBUG_WIRING) {
                                        this.printWirings(result);
                                    }
                                    report = this.reportBuilder.build(result, re);
                                    if (!ModuleResolver.this.DEBUG_REPORT) break block35;
                                    if (report.getResolutionException() != null) {
                                        Debug.printStackTrace(report.getResolutionException());
                                    }
                                    if ((resources = report.getEntries().keySet()).isEmpty()) break block35;
                                    Debug.println("RESOLVER: Resolution report");
                                    ** for (resource : report.getEntries().keySet())
                                }
                            }
                            catch (Throwable var7_25) {
                                f = this.timoutFuture.getAndSet(null);
                                if (f != null) {
                                    f.cancel(true);
                                }
                                this.computeUnresolvedProviderResolutionReportEntries(result);
                                this.computeUsesConstraintViolations(logger.getUsesConstraintViolations());
                                if (ModuleResolver.this.DEBUG_WIRING) {
                                    this.printWirings(result);
                                }
                                report = this.reportBuilder.build(result, re);
                                if (!ModuleResolver.this.DEBUG_REPORT) break block36;
                                if (report.getResolutionException() != null) {
                                    Debug.printStackTrace(report.getResolutionException());
                                }
                                if ((resources = report.getEntries().keySet()).isEmpty()) break block36;
                                Debug.println("RESOLVER: Resolution report");
                                ** for (resource : report.getEntries().keySet())
                            }
lbl-1000:
                            // 1 sources

                            {
                                Debug.println(report.getResolutionReportMessage(resource));
                                continue;
                            }
                        }
                        if (this.hook instanceof ResolutionReport.Listener) {
                            ((ResolutionReport.Listener)this.hook).handleResolutionReport(report);
                        }
                        this.hook.end();
                        break block37;
lbl-1000:
                        // 1 sources

                        {
                            Debug.println(report.getResolutionReportMessage(resource));
                            continue;
                        }
                    }
                    if (this.hook instanceof ResolutionReport.Listener) {
                        ((ResolutionReport.Listener)this.hook).handleResolutionReport(report);
                    }
                    this.hook.end();
                    throw var7_25;
                }
                f = this.timoutFuture.getAndSet(null);
                if (f != null) {
                    f.cancel(true);
                }
                this.computeUnresolvedProviderResolutionReportEntries(result);
                this.computeUsesConstraintViolations(logger.getUsesConstraintViolations());
                if (ModuleResolver.this.DEBUG_WIRING) {
                    this.printWirings(result);
                }
                report = this.reportBuilder.build(result, re);
                if (ModuleResolver.this.DEBUG_REPORT) {
                    if (report.getResolutionException() != null) {
                        Debug.printStackTrace(report.getResolutionException());
                    }
                    if (!(resources = report.getEntries().keySet()).isEmpty()) {
                        Debug.println("RESOLVER: Resolution report");
                        for (Resource resource : report.getEntries().keySet()) {
                            Debug.println(report.getResolutionReportMessage(resource));
                        }
                    }
                }
                if (this.hook instanceof ResolutionReport.Listener) {
                    ((ResolutionReport.Listener)this.hook).handleResolutionReport(report);
                }
                this.hook.end();
            }
            var13_6 = report;
            return var13_6;
            finally {
                ModuleResolver.this.threadResolving.set(Boolean.FALSE);
            }
        }

        private void printWirings(Map<Resource, List<Wire>> wires) {
            StringBuilder builder = new StringBuilder("RESOLVER: Wirings for resolved bundles:");
            if (wires == null) {
                Debug.println(" null wires!");
                return;
            }
            for (Map.Entry<Resource, List<Wire>> entry : wires.entrySet()) {
                builder.append(SEPARATOR).append('\t').append("Resource").append(SEPARATOR).append('\t').append('\t').append(entry.getKey()).append(SEPARATOR).append('\t').append("Wiring");
                int i = 0;
                for (Wire wire : entry.getValue()) {
                    builder.append(SEPARATOR).append('\t').append('\t').append('[').append(++i).append("] ").append(wire);
                }
            }
            Debug.println(builder);
        }

        private void resolveRevisionsInBatch(Collection<ModuleRevision> revisions, boolean isMandatory, ResolveLogger logger, Map<Resource, List<Wire>> result) throws ResolutionException {
            long startTime = System.currentTimeMillis();
            long initialFreeMemory = Runtime.getRuntime().freeMemory();
            long maxUsedMemory = 0L;
            revisions = new LinkedList<ModuleRevision>(revisions);
            ArrayList<Resource> toResolve = new ArrayList<Resource>();
            try {
                Iterator<ModuleRevision> iResources = revisions.iterator();
                while (iResources.hasNext()) {
                    ModuleRevision single = iResources.next();
                    iResources.remove();
                    if (!this.wirings.containsKey(single) && !this.failedToResolve.contains(single)) {
                        toResolve.add(single);
                    }
                    if (toResolve.size() == ModuleResolver.this.resolverRevisionBatchSize || !iResources.hasNext()) {
                        if (ModuleResolver.this.DEBUG_ROOTS) {
                            Debug.println("Resolver: resolving " + toResolve.size() + " in batch.");
                            for (Resource root : toResolve) {
                                Debug.println("    Resolving root bundle: " + root);
                            }
                        }
                        this.resolveRevisions(toResolve, isMandatory, logger, result);
                        toResolve.clear();
                    }
                    maxUsedMemory = Math.max(maxUsedMemory, Runtime.getRuntime().freeMemory() - initialFreeMemory);
                }
            }
            catch (ResolutionException resolutionException) {
                if (resolutionException.getCause() instanceof CancellationException) {
                    this.resolveRevisionsIndividually(isMandatory, logger, result, toResolve, revisions);
                }
                throw resolutionException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.resolveRevisionsIndividually(isMandatory, logger, result, toResolve, revisions);
            }
            if (ModuleResolver.this.DEBUG_ROOTS) {
                Debug.println("Resolver: resolve batch size:  " + ModuleResolver.this.resolverRevisionBatchSize);
                Debug.println("Resolver: time to resolve:  " + (System.currentTimeMillis() - startTime) + "ms");
                Debug.println("Resolver: max used memory: " + maxUsedMemory / 0x100000L + "Mo");
            }
        }

        private void resolveRevisionsIndividually(boolean isMandatory, ResolveLogger logger, Map<Resource, List<Wire>> result, Collection<Resource> toResolve, Collection<ModuleRevision> revisions) throws ResolutionException {
            this.scheduleTimeout.set(false);
            for (Resource resource : toResolve) {
                if (this.wirings.containsKey(resource) || this.failedToResolve.contains(resource)) continue;
                this.resolveRevisions(Collections.singletonList(resource), isMandatory, logger, result);
            }
            for (Resource resource : revisions) {
                if (this.wirings.containsKey(resource) || this.failedToResolve.contains(resource)) continue;
                this.resolveRevisions(Collections.singletonList(resource), isMandatory, logger, result);
            }
        }

        private void resolveRevisions(List<Resource> revisions, boolean isMandatory, ResolveLogger logger, Map<Resource, List<Wire>> result) throws ResolutionException {
            boolean applyTransitiveFailures = true;
            this.currentlyResolving = revisions;
            this.currentlyResolvingMandatory = isMandatory;
            this.transitivelyResolveFailures.clear();
            Map<Resource, List<Wire>> interimResults = null;
            try {
                try {
                    this.transitivelyResolveFailures.addAll(revisions);
                    interimResults = new ResolverImpl(logger, this).resolve(this);
                    this.applyInterimResultToWiringCopy(interimResults);
                    if (ModuleResolver.this.DEBUG_ROOTS) {
                        Debug.println("Resolver: resolved " + interimResults.size() + " bundles.");
                    }
                    for (Map.Entry<Resource, List<Wire>> interimResultEntry : interimResults.entrySet()) {
                        List<Wire> existingWires;
                        if (ModuleResolver.this.DEBUG_ROOTS) {
                            Debug.println("    Resolved bundle: " + interimResultEntry.getKey());
                        }
                        if ((existingWires = result.get(interimResultEntry.getKey())) != null) {
                            existingWires.addAll((Collection<Wire>)interimResultEntry.getValue());
                            continue;
                        }
                        result.put(interimResultEntry.getKey(), interimResultEntry.getValue());
                    }
                }
                catch (ResolutionException resolutionException) {
                    if (resolutionException.getCause() instanceof CancellationException) {
                        applyTransitiveFailures = false;
                    }
                    throw resolutionException;
                }
                catch (OutOfMemoryError memoryError) {
                    applyTransitiveFailures = false;
                    throw memoryError;
                }
            }
            finally {
                if (applyTransitiveFailures) {
                    this.transitivelyResolveFailures.addAll(logger.getUsesConstraintViolations().keySet());
                    if (interimResults != null) {
                        this.transitivelyResolveFailures.removeAll(interimResults.keySet());
                    }
                    if (!this.transitivelyResolveFailures.isEmpty()) {
                        this.failedToResolve.addAll(this.transitivelyResolveFailures);
                    }
                }
                this.currentlyResolving = null;
                this.currentlyResolvingMandatory = false;
            }
        }

        private void applyInterimResultToWiringCopy(Map<Resource, List<Wire>> interimResult) {
            if (!interimResult.isEmpty()) {
                Map<ModuleRevision, ModuleWiring> updatedWirings = ModuleResolver.this.generateDelta(interimResult, this.wirings);
                for (Map.Entry<ModuleRevision, ModuleWiring> updatedWiring : updatedWirings.entrySet()) {
                    this.wirings.put(updatedWiring.getKey(), updatedWiring.getValue());
                }
            }
        }

        private void computeUsesConstraintViolations(Map<Resource, ResolutionException> usesConstraintViolations) {
            for (Map.Entry<Resource, ResolutionException> usesConstraintViolation : usesConstraintViolations.entrySet()) {
                this.reportBuilder.addEntry(usesConstraintViolation.getKey(), ResolutionReport.Entry.Type.USES_CONSTRAINT_VIOLATION, usesConstraintViolation.getValue());
            }
        }

        private void computeUnresolvedProviderResolutionReportEntries(Map<Resource, List<Wire>> resolution) {
            ArrayList<ModuleRevision> shouldHaveResolvedResources = new ArrayList<ModuleRevision>(this.unresolved);
            shouldHaveResolvedResources.removeAll(this.disabled);
            if (resolution != null) {
                shouldHaveResolvedResources.removeAll(resolution.keySet());
            }
            for (Resource resource : shouldHaveResolvedResources) {
                Map<Requirement, Set<Capability>> requirementToCapabilities = this.unresolvedProviders.get(resource);
                if (requirementToCapabilities == null) continue;
                if (resolution != null) {
                    Iterator<Set<Capability>> values = requirementToCapabilities.values().iterator();
                    while (values.hasNext()) {
                        Set<Capability> value = values.next();
                        Iterator<Capability> capabilities = value.iterator();
                        while (capabilities.hasNext()) {
                            if (!resolution.containsKey(capabilities.next().getResource())) continue;
                            capabilities.remove();
                        }
                        if (!value.isEmpty()) continue;
                        values.remove();
                    }
                }
                if (requirementToCapabilities.isEmpty()) continue;
                this.reportBuilder.addEntry(resource, ResolutionReport.Entry.Type.UNRESOLVED_PROVIDER, requirementToCapabilities);
            }
        }

        private void computeUnresolvedProviders(Requirement requirement, Collection<? extends Capability> capabilities) {
            Set<Capability> value;
            Resource requirer = requirement.getResource();
            Map<Requirement, Set<Capability>> requirementToCapabilities = this.unresolvedProviders.get(requirer);
            if (requirementToCapabilities == null) {
                requirementToCapabilities = new HashMap<Requirement, Set<Capability>>();
                this.unresolvedProviders.put(requirer, requirementToCapabilities);
            }
            if ((value = requirementToCapabilities.get(requirement)) == null) {
                value = new HashSet<Capability>(capabilities.size());
                requirementToCapabilities.put(requirement, value);
            }
            for (Capability capability : capabilities) {
                if (this.wirings.containsKey(capability.getResource())) continue;
                value.add(capability);
            }
        }

        private Map<Resource, List<Wire>> resolveNonPayLoadFragments() {
            ArrayList<ModuleRevision> dynamicAttachableFrags = new ArrayList<ModuleRevision>();
            if (this.triggersMandatory) {
                for (ModuleRevision moduleRevision : this.triggers) {
                    if ((moduleRevision.getTypes() & 1) == 0) continue;
                    dynamicAttachableFrags.add(moduleRevision);
                }
            }
            for (ModuleRevision moduleRevision : this.optionals) {
                if ((moduleRevision.getTypes() & 1) == 0) continue;
                dynamicAttachableFrags.add(moduleRevision);
            }
            if (dynamicAttachableFrags.isEmpty()) {
                return Collections.emptyMap();
            }
            Collections.sort(dynamicAttachableFrags, new Comparator<ModuleRevision>(){

                @Override
                public int compare(ModuleRevision r1, ModuleRevision r2) {
                    return -r1.getVersion().compareTo(r2.getVersion());
                }
            });
            HashMap<ModuleCapability, DynamicFragments> hostDynamicFragments = new HashMap<ModuleCapability, DynamicFragments>();
            for (ModuleRevision dynamicAttachableFragment : dynamicAttachableFrags) {
                List<ModuleRequirement> requirements = dynamicAttachableFragment.getModuleRequirements(null);
                for (ModuleRequirement requirement : requirements) {
                    if (!"osgi.wiring.host".equals(requirement.getNamespace())) continue;
                    List<ModuleCapability> matchingHosts = this.moduleDatabase.findCapabilities(requirement);
                    this.filterProviders(requirement, matchingHosts, false);
                    for (ModuleCapability hostCandidate : matchingHosts) {
                        boolean attachAlways;
                        ModuleWiring hostWiring = this.wirings.get(hostCandidate.getRevision());
                        String attachDirective = hostCandidate.getDirectives().get("fragment-attachment");
                        boolean bl = attachAlways = attachDirective == null || "always".equals(attachDirective);
                        if (!attachAlways || hostWiring == null) continue;
                        DynamicFragments dynamicFragments = (DynamicFragments)hostDynamicFragments.get(hostCandidate);
                        if (dynamicFragments == null) {
                            dynamicFragments = new DynamicFragments(hostWiring, hostCandidate);
                            hostDynamicFragments.put(hostCandidate, dynamicFragments);
                        }
                        dynamicFragments.addFragment(requirement.getRevision());
                    }
                }
            }
            HashMap<Resource, List<Wire>> dynamicWires = new HashMap<Resource, List<Wire>>();
            for (DynamicFragments dynamicFragments : hostDynamicFragments.values()) {
                dynamicWires.putAll(dynamicFragments.getNewWires());
            }
            return dynamicWires;
        }

        private Map<Resource, List<Wire>> resolveDynamic() throws ResolutionException {
            return new ResolverImpl(new Logger(0), null).resolveDynamic(this, this.dynamicReq.getRevision().getWiring(), this.dynamicReq.getOriginal());
        }

        private void filterResolvable() {
            ArrayList<ModuleRevision> enabledCandidates = new ArrayList<ModuleRevision>(this.unresolved);
            this.hook.filterResolvable(InternalUtils.asListBundleRevision((List<? extends BundleRevision>)enabledCandidates));
            for (ModuleRevision enabledRevision : enabledCandidates) {
                this.disabled.remove(enabledRevision);
            }
            for (ModuleRevision revision : this.disabled) {
                this.reportBuilder.addEntry(revision, ResolutionReport.Entry.Type.FILTERED_BY_RESOLVER_HOOK, null);
                if (!ModuleResolver.this.DEBUG_HOOKS) continue;
                Debug.println("RESOLVER: Resource filtered by ResolverHook.filterResolvable: " + revision);
            }
        }

        private void selectSingletons() {
            HashMap selectedSingletons = new HashMap();
            for (ModuleRevision revision : this.unresolved) {
                String bsn;
                ArrayList<ModuleRevision> selected;
                if (!ModuleResolver.isSingleton(revision) || this.disabled.contains(revision) || (selected = (ArrayList<ModuleRevision>)selectedSingletons.get(bsn = revision.getSymbolicName())) != null) continue;
                selected = new ArrayList<ModuleRevision>(1);
                selectedSingletons.put(bsn, selected);
                Collection<ModuleRevision> sameBSN = this.getRevisions(bsn);
                if (sameBSN.size() < 2) {
                    selected.add(revision);
                    continue;
                }
                for (ModuleRevision singleton : sameBSN) {
                    if (!ModuleResolver.isSingleton(singleton) || !this.wirings.containsKey(singleton)) continue;
                    selected.add(singleton);
                }
                Map<ModuleRevision, Collection<ModuleRevision>> collisionMap = this.getCollisionMap(sameBSN);
                for (ModuleRevision singleton : sameBSN) {
                    Collection<ModuleRevision> collisions;
                    if (selected.contains(singleton) || (collisions = collisionMap.get(singleton)) == null || this.disabled.contains(singleton)) continue;
                    ArrayList<ModuleRevision> pickOneToResolve = new ArrayList<ModuleRevision>();
                    for (ModuleRevision moduleRevision : collisions) {
                        if (selected.contains(moduleRevision)) {
                            this.disabled.add(singleton);
                            this.reportBuilder.addEntry(singleton, ResolutionReport.Entry.Type.SINGLETON_SELECTION, moduleRevision);
                            break;
                        }
                        if (pickOneToResolve.contains(moduleRevision)) continue;
                        pickOneToResolve.add(moduleRevision);
                    }
                    if (!this.disabled.contains(singleton)) {
                        for (Map.Entry entry : collisionMap.entrySet()) {
                            if (entry.getKey() == singleton || !((Collection)entry.getValue()).contains(singleton)) continue;
                            if (selected.contains(entry.getKey())) {
                                this.disabled.add(singleton);
                                this.reportBuilder.addEntry(singleton, ResolutionReport.Entry.Type.SINGLETON_SELECTION, entry.getKey());
                                break;
                            }
                            if (pickOneToResolve.contains(entry.getKey())) continue;
                            pickOneToResolve.add((ModuleRevision)entry.getKey());
                        }
                    }
                    if (this.disabled.contains(singleton)) continue;
                    pickOneToResolve.add(singleton);
                    selected.add(this.pickOneToResolve(pickOneToResolve));
                }
            }
        }

        private Collection<ModuleRevision> getRevisions(String name) {
            Collection<ModuleRevision> result;
            Map<String, Collection<ModuleRevision>> current = this.byName;
            if (current == null) {
                HashSet<ModuleRevision> revisions = new HashSet<ModuleRevision>();
                revisions.addAll(this.unresolved);
                revisions.addAll(this.previouslyResolved);
                current = new HashMap<String, Collection<ModuleRevision>>();
                for (ModuleRevision revision : revisions) {
                    Collection<ModuleRevision> sameName = current.get(revision.getSymbolicName());
                    if (sameName == null) {
                        sameName = new ArrayList<ModuleRevision>();
                        current.put(revision.getSymbolicName(), sameName);
                    }
                    sameName.add(revision);
                }
                this.byName = current;
            }
            if ((result = current.get(name)) == null) {
                return Collections.emptyList();
            }
            return result;
        }

        private ModuleRevision pickOneToResolve(Collection<ModuleRevision> pickOneToResolve) {
            ModuleRevision selectedVersion = null;
            for (ModuleRevision singleton : pickOneToResolve) {
                boolean higherVersion;
                if (selectedVersion == null) {
                    selectedVersion = singleton;
                }
                boolean bl = higherVersion = selectedVersion.getVersion().compareTo(singleton.getVersion()) < 0;
                if (!higherVersion) continue;
                selectedVersion = singleton;
            }
            for (ModuleRevision singleton : pickOneToResolve) {
                if (singleton == selectedVersion) continue;
                this.disabled.add(singleton);
                this.reportBuilder.addEntry(singleton, ResolutionReport.Entry.Type.SINGLETON_SELECTION, selectedVersion);
            }
            return selectedVersion;
        }

        private Map<ModuleRevision, Collection<ModuleRevision>> getCollisionMap(Collection<ModuleRevision> sameBSN) {
            HashMap<ModuleRevision, Collection<ModuleRevision>> result = new HashMap<ModuleRevision, Collection<ModuleRevision>>();
            for (ModuleRevision singleton : sameBSN) {
                if (!ModuleResolver.isSingleton(singleton) || this.disabled.contains(singleton)) continue;
                ArrayList<BundleCapability> capabilities = new ArrayList<BundleCapability>(sameBSN.size() - 1);
                for (ModuleRevision collision : sameBSN) {
                    if (collision == singleton || !ModuleResolver.isSingleton(collision) || this.disabled.contains(collision)) continue;
                    capabilities.add(this.getIdentity(collision));
                }
                this.hook.filterSingletonCollisions(this.getIdentity(singleton), capabilities);
                ArrayList<ModuleRevision> collisionCandidates = new ArrayList<ModuleRevision>(capabilities.size());
                for (BundleCapability identity : capabilities) {
                    collisionCandidates.add((ModuleRevision)identity.getRevision());
                }
                if (ModuleResolver.this.DEBUG_HOOKS) {
                    ArrayList<ModuleRevision> filteredSingletons = new ArrayList<ModuleRevision>(sameBSN);
                    filteredSingletons.removeAll(collisionCandidates);
                    filteredSingletons.remove(singleton);
                    if (!filteredSingletons.isEmpty()) {
                        StringBuilder builder = new StringBuilder("RESOLVER: Resources filtered by ResolverHook.filterSingletonCollisions").append(SEPARATOR).append('\t').append("Singleton").append(SEPARATOR).append('\t').append('\t').append(singleton).append(" [id=").append(singleton.getRevisions().getModule().getId()).append(", location=").append(singleton.getRevisions().getModule().getLocation()).append(']').append(SEPARATOR).append('\t').append("Collisions");
                        int i = 0;
                        for (ModuleRevision revision : filteredSingletons) {
                            builder.append(SEPARATOR).append('\t').append('\t').append("[").append(++i).append("] ").append(revision).append(" [id=").append(revision.getRevisions().getModule().getId()).append(", location=").append(revision.getRevisions().getModule().getLocation()).append(']');
                        }
                        Debug.println(builder.toString());
                    }
                }
                result.put(singleton, collisionCandidates);
            }
            return result;
        }

        private BundleCapability getIdentity(ModuleRevision bundle) {
            List<BundleCapability> identities = bundle.getDeclaredCapabilities("osgi.identity");
            return identities.isEmpty() ? null : identities.get(0);
        }

        @Override
        public int compare(Capability c1, Capability c2) {
            Long id2;
            Version v2;
            boolean resolved2;
            boolean resolved1 = this.previouslyResolved.contains(c1.getResource());
            if (resolved1 != (resolved2 = this.previouslyResolved.contains(c2.getResource()))) {
                return resolved1 ? -1 : 1;
            }
            Version v1 = ModuleResolver.getVersion(c1);
            int versionCompare = -v1.compareTo(v2 = ModuleResolver.getVersion(c2));
            if (versionCompare != 0) {
                return versionCompare;
            }
            ModuleRevision m1 = this.getModuleRevision(c1);
            ModuleRevision m2 = this.getModuleRevision(c2);
            Long id1 = m1.getRevisions().getModule().getId();
            if (id1.equals(id2 = m2.getRevisions().getModule().getId()) && !m1.equals(m2)) {
                List<ModuleRevision> revisions = m1.getRevisions().getModuleRevisions();
                int index1 = revisions.indexOf(m1);
                int index2 = revisions.indexOf(m2);
                return index2 - index1;
            }
            return id1.compareTo(id2);
        }

        ModuleRevision getModuleRevision(Capability c) {
            if (c instanceof HostedCapability) {
                c = ((HostedCapability)c).getDeclaredCapability();
            }
            if (c instanceof ModuleCapability) {
                return ((ModuleCapability)c).getRevision();
            }
            return null;
        }

        @Override
        public void execute(Runnable command) {
            ModuleResolver.this.adaptor.getResolverExecutor().execute(command);
        }

        @Override
        public void onCancel(Runnable callback) {
            ScheduledExecutorService scheduledExecutor;
            if (this.scheduleTimeout.compareAndSet(true, false) && (scheduledExecutor = ModuleResolver.this.adaptor.getScheduledExecutor()) != null) {
                try {
                    this.timoutFuture.set(scheduledExecutor.schedule(callback, (long)ModuleResolver.this.resolverBatchTimeout, TimeUnit.MILLISECONDS));
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }

        @Override
        public List<Wire> getSubstitutionWires(Wiring wiring) {
            return ((ModuleWiring)wiring).getSubstitutionWires();
        }

        class DynamicFragments {
            private final ModuleCapability hostCapability;
            private final Map<String, ModuleRevision> fragments = new HashMap<String, ModuleRevision>();
            private final Set<ModuleRevision> validProviders = new HashSet<ModuleRevision>();
            boolean fragmentAdded = false;

            DynamicFragments(ModuleWiring hostWiring, ModuleCapability hostCapability) {
                this.hostCapability = hostCapability;
                this.validProviders.add(hostWiring.getRevision());
                for (ModuleWire hostWire : hostWiring.getProvidedModuleWires("osgi.wiring.host")) {
                    this.validProviders.add(hostWire.getRequirer());
                    this.fragments.put(hostWire.getRequirer().getSymbolicName(), hostWire.getRequirer());
                }
            }

            void addFragment(ModuleRevision fragment) {
                ModuleRevision existing = this.fragments.get(fragment.getSymbolicName());
                if (existing == null) {
                    this.fragments.put(fragment.getSymbolicName(), fragment);
                    this.validProviders.add(fragment);
                    this.fragmentAdded = true;
                }
            }

            Map<Resource, List<Wire>> getNewWires() {
                boolean retry;
                if (!this.fragmentAdded) {
                    return Collections.emptyMap();
                }
                HashMap<Resource, List<Wire>> result = new HashMap<Resource, List<Wire>>();
                block0: do {
                    retry = false;
                    result.clear();
                    Iterator<Map.Entry<String, ModuleRevision>> iFragments = this.fragments.entrySet().iterator();
                    while (iFragments.hasNext()) {
                        Map.Entry<String, ModuleRevision> fragmentEntry = iFragments.next();
                        if (ResolveProcess.this.wirings.get(fragmentEntry.getValue()) != null) continue;
                        for (ModuleRequirement req : fragmentEntry.getValue().getModuleRequirements(null)) {
                            ModuleRevision requirer = NON_PAYLOAD_REQUIREMENTS.contains(req.getNamespace()) ? req.getRevision() : this.hostCapability.getRevision();
                            ArrayList<Wire> newWires = (ArrayList<Wire>)result.get(requirer);
                            if (newWires == null) {
                                newWires = new ArrayList<Wire>();
                                result.put(requirer, newWires);
                            }
                            if ("osgi.wiring.host".equals(req.getNamespace())) {
                                newWires.add(new ModuleWire(this.hostCapability, this.hostCapability.getRevision(), req, requirer));
                                continue;
                            }
                            if (!this.failToWire(req, requirer, newWires)) continue;
                            iFragments.remove();
                            this.validProviders.remove(req.getRevision());
                            retry = true;
                            continue block0;
                        }
                    }
                } while (retry);
                return result;
            }

            private boolean failToWire(ModuleRequirement requirement, ModuleRevision requirer, List<Wire> wires) {
                if (!ResolveProcess.this.isEffective(requirement)) {
                    return false;
                }
                List<ModuleCapability> matching = ResolveProcess.this.moduleDatabase.findCapabilities(requirement);
                ArrayList<ModuleWire> newWires = new ArrayList<ModuleWire>(0);
                ResolveProcess.this.filterProviders(requirement, matching, false);
                for (ModuleCapability candidate : matching) {
                    ModuleRevision provider;
                    if (!requirer.equals(requirement.getRevision()) && !this.validProviders.contains(candidate.getRevision())) continue;
                    ModuleRevision moduleRevision = provider = NON_PAYLOAD_CAPABILITIES.contains(candidate.getNamespace()) ? candidate.getRevision() : this.hostCapability.getRevision();
                    if (!newWires.isEmpty() && !"multiple".equals(requirement.getDirectives().get("cardinality"))) continue;
                    newWires.add(new ModuleWire(candidate, provider, requirement, requirer));
                }
                if (newWires.isEmpty() && !"optional".equals(requirement.getDirectives().get("resolution"))) {
                    return true;
                }
                if (!NON_SUBSTITUTED_REQUIREMENTS.contains(requirement.getNamespace())) {
                    wires.addAll(newWires);
                }
                return false;
            }
        }

        class ResolveLogger
        extends Logger {
            private Map<Resource, ResolutionException> errors;

            public ResolveLogger() {
                super(((ResolveProcess)ResolveProcess.this).ModuleResolver.this.DEBUG_USES ? 4 : 0);
                this.errors = null;
            }

            @Override
            public void logUsesConstraintViolation(Resource resource, ResolutionError error) {
                if (this.errors == null) {
                    this.errors = new HashMap<Resource, ResolutionException>();
                }
                this.errors.put(resource, error.toException());
                if (((ResolveProcess)ResolveProcess.this).ModuleResolver.this.DEBUG_USES) {
                    Debug.println("RESOLVER: Uses constraint violation" + SEPARATOR + '\t' + "Resource" + SEPARATOR + '\t' + '\t' + resource + SEPARATOR + '\t' + "Error" + SEPARATOR + '\t' + '\t' + error.getMessage());
                }
            }

            Map<Resource, ResolutionException> getUsesConstraintViolations() {
                return this.errors == null ? Collections.emptyMap() : this.errors;
            }

            @Override
            public boolean isDebugEnabled() {
                return ((ResolveProcess)ResolveProcess.this).ModuleResolver.this.DEBUG_USES;
            }

            @Override
            protected void doLog(int level, String msg, Throwable throwable) {
                Debug.println("RESOLVER: " + msg + SEPARATOR + (throwable != null ? String.valueOf(18) + throwable.getMessage() : ""));
            }
        }
    }
}

