/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchIndex;
import org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.eclipse.jdt.internal.core.nd.java.NdType;
import org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.eclipse.jdt.internal.core.nd.java.TypeRef;
import org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryType;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.eclipse.jdt.internal.core.nd.util.PathMap;
import org.eclipse.jdt.internal.core.search.matching.ClasspathSourceDirectory;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;

public class IndexBasedJavaSearchEnvironment
implements INameEnvironment,
SuffixConstants {
    private Map<String, org.eclipse.jdt.core.ICompilationUnit> workingCopies;
    private PathMap<Integer> mapPathsToRoots = new PathMap();
    private IPackageFragmentRoot[] roots;
    private int sourceEntryPosition;
    private List<ClasspathLocation> unindexedEntries = new ArrayList<ClasspathLocation>();
    private long timeSpentInFindClassInUnindexedLocations;
    private long timeSpentInFindType;

    public IndexBasedJavaSearchEnvironment(List<IJavaProject> javaProject, org.eclipse.jdt.core.ICompilationUnit[] copies) {
        this.workingCopies = JavaSearchNameEnvironment.getWorkingCopyMap(copies);
        try {
            ArrayList<IPackageFragmentRoot> localRoots = new ArrayList<IPackageFragmentRoot>();
            for (IJavaProject next : javaProject) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = next.getAllPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object target;
                    IPackageFragmentRoot nextRoot = iPackageFragmentRootArray[n2];
                    IPath path = nextRoot.getPath();
                    if (!nextRoot.isArchive() && (target = JavaModel.getTarget(path, true)) != null && nextRoot.getKind() == 1) {
                        PackageFragmentRoot root = (PackageFragmentRoot)nextRoot;
                        ClasspathSourceDirectory cp = new ClasspathSourceDirectory((IContainer)target, root.fullExclusionPatternChars(), root.fullInclusionPatternChars());
                        this.unindexedEntries.add(cp);
                    }
                    localRoots.add(nextRoot);
                    ++n2;
                }
            }
            this.roots = localRoots.toArray(new IPackageFragmentRoot[0]);
        }
        catch (JavaModelException javaModelException) {
            this.roots = new IPackageFragmentRoot[0];
        }
        int length = this.roots.length;
        int i = 0;
        while (i < length) {
            IPath nextPath = JavaIndex.getLocationForElement(this.roots[i]);
            this.mapPathsToRoots.put(nextPath, i);
            ++i;
        }
        this.sourceEntryPosition = Integer.MAX_VALUE;
        i = 0;
        while (i < length) {
            IPackageFragmentRoot nextRoot = this.roots[i];
            try {
                if (nextRoot.getKind() == 1) {
                    this.sourceEntryPosition = i;
                    break;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
    }

    public static boolean isEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.jdt.core", "useIndexBasedSearchEnvironment", false, null);
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        char[] binaryName = CharOperation.concatWith(compoundTypeName, '/');
        int bestEntryPosition = Integer.MAX_VALUE;
        NameEnvironmentAnswer result = this.findClassInUnindexedLocations(new String(binaryName), compoundTypeName[compoundTypeName.length - 1]);
        if (result != null) {
            bestEntryPosition = this.sourceEntryPosition;
        }
        long start = -1L;
        if (NameLookup.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            char[] fieldDescriptor = JavaNames.binaryNameToFieldDescriptor(binaryName);
            JavaIndex index = JavaIndex.getIndex();
            Nd nd = index.getNd();
            try {
                Throwable throwable = null;
                Object var11_11 = null;
                try (IReader lock = nd.acquireReadLock();){
                    NdTypeId typeId = index.findType(fieldDescriptor);
                    if (typeId != null) {
                        List<NdType> types = typeId.getTypes();
                        for (NdType next : types) {
                            String fileName;
                            NdResourceFile resource = next.getFile();
                            IPath path = resource.getPath();
                            Integer nextRoot = this.mapPathsToRoots.getMostSpecific(path);
                            if (nextRoot == null) continue;
                            IPackageFragmentRoot root = this.roots[nextRoot];
                            ClasspathEntry classpathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                            AccessRuleSet ruleSet = classpathEntry.getAccessRuleSet();
                            AccessRestriction accessRestriction = ruleSet == null ? null : ruleSet.getViolatedRestriction(binaryName);
                            TypeRef typeRef = TypeRef.create(next);
                            IndexBinaryType binaryType = new IndexBinaryType(typeRef, (fileName = String.valueOf(new String(binaryName)) + ".class").toCharArray());
                            NameEnvironmentAnswer nextAnswer = new NameEnvironmentAnswer(binaryType, accessRestriction);
                            boolean useNewAnswer = this.isBetter(result, bestEntryPosition, nextAnswer, nextRoot);
                            if (!useNewAnswer) continue;
                            bestEntryPosition = nextRoot;
                            result = nextAnswer;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        finally {
            if (NameLookup.VERBOSE) {
                this.timeSpentInFindType += System.currentTimeMillis() - start;
            }
        }
        return result;
    }

    private NameEnvironmentAnswer findClassInUnindexedLocations(String qualifiedTypeName, char[] typeName) {
        long start = -1L;
        if (NameLookup.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            String binaryFileName = null;
            String qBinaryFileName = null;
            String sourceFileName = null;
            String qSourceFileName = null;
            String qPackageName = null;
            NameEnvironmentAnswer suggestedAnswer = null;
            for (ClasspathLocation location : this.unindexedEntries) {
                NameEnvironmentAnswer answer;
                if (location instanceof ClasspathSourceDirectory) {
                    ICompilationUnit workingCopy;
                    if (sourceFileName == null) {
                        sourceFileName = qSourceFileName = qualifiedTypeName;
                        qPackageName = "";
                        if (qualifiedTypeName.length() > typeName.length) {
                            int typeNameStart = qSourceFileName.length() - typeName.length;
                            qPackageName = qSourceFileName.substring(0, typeNameStart - 1);
                            sourceFileName = qSourceFileName.substring(typeNameStart);
                        }
                    }
                    answer = (workingCopy = (ICompilationUnit)((Object)this.workingCopies.get(qualifiedTypeName))) != null ? new NameEnvironmentAnswer(workingCopy, null) : location.findClass(sourceFileName, qPackageName, null, qSourceFileName, false, null);
                } else {
                    if (binaryFileName == null) {
                        binaryFileName = qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
                        qPackageName = "";
                        if (qualifiedTypeName.length() > typeName.length) {
                            int typeNameStart = qBinaryFileName.length() - typeName.length - 6;
                            qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
                            binaryFileName = qBinaryFileName.substring(typeNameStart);
                        }
                    }
                    answer = location.findClass(binaryFileName, qPackageName, null, qBinaryFileName, false, null);
                }
                if (answer == null) continue;
                if (!answer.ignoreIfBetter()) {
                    if (!answer.isBetter(suggestedAnswer)) continue;
                    NameEnvironmentAnswer nameEnvironmentAnswer = answer;
                    return nameEnvironmentAnswer;
                }
                if (!answer.isBetter(suggestedAnswer)) continue;
                suggestedAnswer = answer;
            }
            if (suggestedAnswer != null) {
                NameEnvironmentAnswer nameEnvironmentAnswer = suggestedAnswer;
                return nameEnvironmentAnswer;
            }
            return null;
        }
        finally {
            if (NameLookup.VERBOSE) {
                this.timeSpentInFindClassInUnindexedLocations += System.currentTimeMillis() - start;
            }
        }
    }

    public boolean isBetter(NameEnvironmentAnswer currentBest, int currentBestClasspathPosition, NameEnvironmentAnswer toTest, int toTestClasspathPosition) {
        boolean useNewAnswer = false;
        if (currentBest == null) {
            useNewAnswer = true;
        } else if (toTest.isBetter(currentBest)) {
            useNewAnswer = true;
        } else if (!currentBest.isBetter(toTest)) {
            useNewAnswer = toTestClasspathPosition < currentBestClasspathPosition;
        }
        return useNewAnswer;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        char[][] newArray = new char[packageName.length + 1][];
        System.arraycopy(packageName, 0, newArray, 0, packageName.length);
        newArray[packageName.length] = typeName;
        return this.findType(newArray);
    }

    @Override
    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        char[] binaryPackageName = CharOperation.concatWith(parentPackageName, '/');
        final char[] fieldDescriptorPrefix = parentPackageName == null || parentPackageName.length == 0 ? CharArrayUtils.concat(JavaNames.FIELD_DESCRIPTOR_PREFIX, packageName, new char[]{'/'}) : CharArrayUtils.concat(JavaNames.FIELD_DESCRIPTOR_PREFIX, binaryPackageName, {'/'}, packageName, {'/'});
        JavaIndex index = JavaIndex.getIndex();
        Nd nd = index.getNd();
        Throwable throwable = null;
        Object var8_9 = null;
        try (IReader lock = nd.acquireReadLock();){
            boolean bl = !index.visitFieldDescriptorsStartingWith(fieldDescriptorPrefix, new FieldSearchIndex.Visitor<NdTypeId>(){

                @Override
                public boolean visit(NdTypeId typeId) {
                    if (typeId.getFieldDescriptor().length() <= fieldDescriptorPrefix.length + 1) {
                        return true;
                    }
                    List<NdType> types = typeId.getTypes();
                    for (NdType next : types) {
                        NdResourceFile resource;
                        IPath path;
                        if (next.isMember() || next.isLocal() || next.isAnonymous() || !IndexBasedJavaSearchEnvironment.this.containsPrefixOf(path = (resource = next.getFile()).getPath())) continue;
                        return false;
                    }
                    return true;
                }
            });
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    boolean containsPrefixOf(IPath path) {
        return this.mapPathsToRoots.containsPrefixOf(path);
    }

    public static INameEnvironment create(List<IJavaProject> javaProjects, org.eclipse.jdt.core.ICompilationUnit[] copies) {
        if (JavaIndex.isEnabled() && IndexBasedJavaSearchEnvironment.isEnabled()) {
            return new IndexBasedJavaSearchEnvironment(javaProjects, copies);
        }
        Iterator<IJavaProject> next = javaProjects.iterator();
        JavaSearchNameEnvironment result = new JavaSearchNameEnvironment(next.next(), copies);
        while (next.hasNext()) {
            result.addProjectClassPath((JavaProject)next.next());
        }
        return result;
    }
}

