/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;

public class HierarchyScope
extends AbstractSearchScope
implements SuffixConstants {
    public IType focusType;
    private String focusPath;
    private WorkingCopyOwner owner;
    private ITypeHierarchy hierarchy;
    private HashSet resourcePaths;
    private IPath[] enclosingProjectsAndJars;
    protected Set<String> elements;
    protected int elementCount;
    public boolean needsRefresh;
    private HashSet subTypes;
    private IJavaProject javaProject;
    private boolean includeFocusType;

    public void add(IResource element) {
        this.elements.add(element.getFullPath().toString());
    }

    private void buildResourceVector() {
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        IType[] types = null;
        if (this.subTypes != null) {
            types = this.hierarchy.getAllSubtypes(this.focusType);
            if (this.includeFocusType) {
                int len = types.length;
                IType[] iTypeArray = types;
                types = new IType[len + 1];
                System.arraycopy(iTypeArray, 0, types, 0, len);
                types[len] = this.focusType;
            }
        } else {
            types = this.hierarchy.getAllTypes();
        }
        int i = 0;
        while (i < types.length) {
            block14: {
                IType type;
                block11: {
                    String resourcePath;
                    String zipFileName;
                    IPath jarPath;
                    IPackageFragmentRoot root;
                    block13: {
                        Object target;
                        block12: {
                            IResource resource;
                            type = types[i];
                            if (this.subTypes != null) {
                                this.subTypes.add(type);
                            }
                            if ((resource = ((JavaElement)((Object)type)).resource()) != null) {
                                this.add(resource);
                            }
                            if (!((root = (IPackageFragmentRoot)type.getPackageFragment().getParent()) instanceof JarPackageFragmentRoot)) break block11;
                            JarPackageFragmentRoot jar = (JarPackageFragmentRoot)root;
                            jarPath = jar.getPath();
                            target = JavaModel.getTarget(jarPath, true);
                            if (!(target instanceof IFile)) break block12;
                            zipFileName = jarPath.toString();
                            break block13;
                        }
                        if (!(target instanceof File)) break block14;
                        zipFileName = ((File)target).getPath();
                    }
                    IModuleDescription md = root.getModuleDescription();
                    if (md != null) {
                        String module = md.getElementName();
                        resourcePath = String.valueOf(zipFileName) + "|" + module + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
                    } else {
                        resourcePath = String.valueOf(zipFileName) + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
                    }
                    this.resourcePaths.add(resourcePath);
                    paths.put(jarPath, type);
                    break block14;
                }
                paths.put(type.getJavaProject().getProject().getFullPath(), type);
            }
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[paths.size()];
        i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.enclosingProjectsAndJars[i++] = (IPath)iter.next();
        }
    }

    @Override
    public boolean encloses(String resourcePath) {
        return this.encloses(resourcePath, null);
    }

    public boolean encloses(String resourcePath, IProgressMonitor progressMonitor) {
        int separatorIndex;
        if (this.hierarchy == null) {
            if (resourcePath.equals(this.focusPath)) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize(progressMonitor);
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh(progressMonitor);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        if ((separatorIndex = resourcePath.indexOf("|")) != -1) {
            return this.resourcePaths.contains(resourcePath);
        }
        return this.elements.contains(resourcePath);
    }

    @Override
    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh) {
            try {
                this.refresh(null);
            }
            catch (JavaModelException javaModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars;
    }

    protected void initialize(IProgressMonitor progressMonitor) throws JavaModelException {
        this.resourcePaths = new HashSet();
        this.elements = new HashSet<String>();
        this.elementCount = 0;
        this.needsRefresh = false;
        if (this.hierarchy == null) {
            this.hierarchy = this.javaProject != null ? this.focusType.newTypeHierarchy(this.javaProject, this.owner, progressMonitor) : this.focusType.newTypeHierarchy(this.owner, progressMonitor);
        } else {
            this.hierarchy.refresh(progressMonitor);
        }
        this.buildResourceVector();
    }

    @Override
    public void processDelta(IJavaElementDelta delta, int eventType) {
        if (this.needsRefresh) {
            return;
        }
        this.needsRefresh = this.hierarchy == null ? false : ((TypeHierarchy)this.hierarchy).isAffected(delta, eventType);
    }

    protected void refresh(IProgressMonitor progressMonitor) throws JavaModelException {
        if (this.hierarchy != null) {
            this.initialize(progressMonitor);
        }
    }

    public String toString() {
        return "HierarchyScope on " + ((JavaElement)((Object)this.focusType)).toStringWithAncestors();
    }

    @Override
    public boolean isParallelSearchSupported() {
        return true;
    }

    @Override
    public void initBeforeSearch(IProgressMonitor monitor) throws JavaModelException {
        if (this.needsRefresh) {
            this.initialize(monitor);
        }
    }
}

