/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.field;

import org.eclipse.jdt.internal.core.nd.INdStruct;
import org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.eclipse.jdt.internal.core.nd.field.BaseField;
import org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.FieldPointer;
import org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.eclipse.jdt.internal.core.nd.field.IRefCountedField;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class FieldManyToOne<T extends INdStruct>
extends BaseField
implements IDestructableField,
IRefCountedField {
    public static final FieldPointer TARGET;
    public static final FieldInt BACKPOINTER_INDEX;
    StructDef<T> targetType;
    final StructDef<? extends INdStruct> localType;
    FieldOneToMany<?> backPointer;
    private static final StructDef<FieldManyToOne> type;
    public final boolean pointsToOwner;
    private final ModificationLog.Tag putTag;
    private final ModificationLog.Tag destructTag;
    private boolean permitsNull = true;

    static {
        type = StructDef.createAbstract(FieldManyToOne.class);
        TARGET = type.addPointer();
        BACKPOINTER_INDEX = type.addInt();
        type.done();
    }

    private FieldManyToOne(StructDef<? extends INdStruct> localType, FieldOneToMany<?> backPointer, boolean pointsToOwner) {
        this.localType = localType;
        this.pointsToOwner = pointsToOwner;
        if (backPointer != null) {
            if (backPointer.forwardPointer != null && backPointer.forwardPointer != this) {
                throw new IllegalArgumentException("Attempted to construct a FieldNodePointer referring to a backpointer list that is already in use by another field");
            }
            backPointer.targetType = localType;
            this.targetType = backPointer.localType;
            backPointer.forwardPointer = this;
        }
        this.backPointer = backPointer;
        this.setFieldName("field " + localType.getNumFields() + ", a " + this.getClass().getSimpleName() + " in struct " + localType.getStructName());
        this.putTag = ModificationLog.createTag("Writing " + this.getFieldName());
        this.destructTag = ModificationLog.createTag("Destructing " + this.getFieldName());
    }

    public static <T extends INdStruct, B extends INdStruct> FieldManyToOne<T> create(StructDef<B> builder, FieldOneToMany<B> forwardPointer) {
        FieldManyToOne<T> result = new FieldManyToOne<T>(builder, forwardPointer, false);
        builder.add(result);
        builder.addDestructableField(result);
        return result;
    }

    public static <T extends INdStruct, B extends INdStruct> FieldManyToOne<T> createOwner(StructDef<B> builder, FieldOneToMany<B> forwardPointer) {
        if (!NdNode.class.isAssignableFrom(builder.getStructClass())) {
            throw new IllegalArgumentException(String.valueOf(FieldManyToOne.class.getSimpleName()) + " can't be the owner of " + builder.getStructClass().getSimpleName() + " because the latter isn't a subclass of " + NdNode.class.getSimpleName());
        }
        FieldManyToOne<T> result = new FieldManyToOne<T>(builder, forwardPointer, true);
        builder.add(result);
        builder.addDestructableField(result);
        builder.addOwnerField(result);
        return result;
    }

    public T get(Nd nd, long address) {
        return NdNode.load(nd, this.getAddress(nd, address), this.targetType);
    }

    public long getAddress(Nd nd, long address) {
        long result = nd.getDB().getRecPtr(address + (long)this.offset);
        if (!this.permitsNull && result == 0L) {
            throw nd.describeProblem().addProblemAddress(this, address).build("Database contained a null in a non-null field");
        }
        return result;
    }

    public void put(Nd nd, long address, T value) {
        if (value != null) {
            this.put(nd, address, value.getAddress());
        } else if (this.permitsNull) {
            this.put(nd, address, 0L);
        } else {
            throw new IllegalArgumentException("Attempted to write a null into a non-null field");
        }
    }

    public void put(Nd nd, long address, long newTargetAddress) {
        Database db = nd.getDB();
        db.getLog().start(this.putTag);
        try {
            long fieldStart = address + (long)this.offset;
            if (this.backPointer == null) {
                throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " must be associated with a " + FieldOneToMany.class.getSimpleName());
            }
            long oldTargetAddress = TARGET.get(nd, fieldStart);
            if (oldTargetAddress == newTargetAddress) {
                return;
            }
            this.detachFromOldTarget(nd, address, oldTargetAddress);
            TARGET.put(nd, fieldStart, newTargetAddress);
            if (newTargetAddress != 0L) {
                BACKPOINTER_INDEX.put(nd, fieldStart, this.backPointer.add(nd, newTargetAddress, address));
            } else if (this.pointsToOwner) {
                nd.scheduleDeletion(address);
            }
        }
        finally {
            db.getLog().end(this.putTag);
        }
    }

    protected void detachFromOldTarget(Nd nd, long address, long oldTargetAddress) {
        long fieldStart = address + (long)this.offset;
        if (oldTargetAddress != 0L) {
            short targetTypeId;
            ITypeFactory typeFactory;
            int oldIndex = BACKPOINTER_INDEX.get(nd, fieldStart);
            this.backPointer.remove(nd, oldTargetAddress, oldIndex);
            if (this.targetType.isNdNode() && (typeFactory = nd.getTypeFactory(targetTypeId = NdNode.NODE_TYPE.get(nd, oldTargetAddress))).getDeletionSemantics() == StructDef.DeletionSemantics.REFCOUNTED && typeFactory.isReadyForDeletion(nd, oldTargetAddress)) {
                nd.scheduleDeletion(oldTargetAddress);
            }
        }
    }

    void adjustIndex(Nd nd, long address, int index) {
        BACKPOINTER_INDEX.put(nd, address + (long)this.offset, index);
    }

    @Override
    public void destruct(Nd nd, long address) {
        Database db = nd.getDB();
        db.getLog().start(this.destructTag);
        try {
            long fieldStart = address + (long)this.offset;
            long oldTargetAddress = TARGET.get(nd, fieldStart);
            this.detachFromOldTarget(nd, address, oldTargetAddress);
            TARGET.put(nd, fieldStart, 0L);
        }
        finally {
            db.getLog().end(this.destructTag);
        }
    }

    void clearedByBackPointer(Nd nd, long address) {
        long fieldStart = (long)this.offset + address;
        TARGET.put(nd, fieldStart, 0L);
        BACKPOINTER_INDEX.put(nd, fieldStart, 0);
    }

    @Override
    public int getRecordSize() {
        return type.size();
    }

    @Override
    public boolean hasReferences(Nd nd, long address) {
        long fieldStart = (long)this.offset + address;
        long target = TARGET.get(nd, fieldStart);
        return target != 0L;
    }
}

