/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd;

import org.eclipse.jdt.internal.core.nd.IndexExceptionBuilder;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.eclipse.jdt.internal.core.nd.field.FieldPointer;
import org.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.eclipse.jdt.internal.core.nd.util.MathUtils;

public final class RawGrowableArray {
    private static final FieldPointer GROWABLE_BLOCK_ADDRESS;
    private static final int ARRAY_HEADER_BYTES;
    private static final StructDef<RawGrowableArray> type;
    private final int inlineSize;

    static {
        type = StructDef.createAbstract(RawGrowableArray.class);
        GROWABLE_BLOCK_ADDRESS = type.addPointer();
        type.done();
        ARRAY_HEADER_BYTES = type.size();
    }

    public RawGrowableArray(int inlineRecords) {
        this.inlineSize = inlineRecords;
    }

    public int size(Nd nd, long address) {
        Database db = nd.getDB();
        long growableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
        if (growableBlockAddress == 0L) {
            long inlineRecordStartAddress = address + (long)ARRAY_HEADER_BYTES;
            int index = 0;
            while (index < this.inlineSize) {
                long nextAddress = inlineRecordStartAddress + (long)(index * 4);
                long nextValue = db.getRecPtr(nextAddress);
                if (nextValue == 0L) {
                    return index;
                }
                ++index;
            }
            return this.inlineSize;
        }
        return GrowableBlockHeader.ARRAY_SIZE.get(nd, growableBlockAddress);
    }

    public int add(Nd nd, long address, long value) {
        if (value == 0L) {
            throw new IllegalArgumentException("Null pointers cannot be inserted into " + this.getClass().getName());
        }
        Database db = nd.getDB();
        int insertionIndex = this.size(nd, address);
        int newSize = insertionIndex + 1;
        try {
            this.ensureCapacity(nd, address, newSize);
            long recordAddress = this.getAddressOfRecord(nd, address, insertionIndex);
            db.putRecPtr(recordAddress, value);
            this.setSize(nd, address, newSize);
        }
        catch (IndexException e) {
            IndexExceptionBuilder descriptor = nd.describeProblem();
            this.addSizeTo(nd, address, descriptor);
            descriptor.attachTo(e);
            throw e;
        }
        return insertionIndex;
    }

    public long get(Nd nd, long address, int index) {
        long recordAddress = this.getAddressOfRecord(nd, address, index);
        return nd.getDB().getRecPtr(recordAddress);
    }

    public void ensureCapacity(Nd nd, long address, int desiredSize) {
        int growableBlockCurrentSize;
        int growableBlockNeededSize = desiredSize - this.inlineSize;
        long growableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
        int n = growableBlockCurrentSize = growableBlockAddress == 0L ? 0 : GrowableBlockHeader.ALLOCATED_SIZE.get(nd, growableBlockAddress);
        if (growableBlockNeededSize <= growableBlockCurrentSize) {
            return;
        }
        Database db = nd.getDB();
        int neededBlockSize = this.getGrowableRegionSizeFor(desiredSize);
        if (neededBlockSize > GrowableBlockHeader.MAX_GROWABLE_SIZE) {
            int currentBlockCount;
            short metablockCurrentPages;
            long metablockAddress = growableBlockAddress;
            assert (neededBlockSize % GrowableBlockHeader.MAX_GROWABLE_SIZE == 0);
            int requiredBlockCount = RawGrowableArray.divideRoundingUp(neededBlockSize, GrowableBlockHeader.MAX_GROWABLE_SIZE);
            int neededMetablockPages = this.computeMetablockPagesForBlocks(requiredBlockCount);
            if (neededMetablockPages > Short.MAX_VALUE) {
                throw new IndexException("A metablock overflowed. Unable to allocate " + neededMetablockPages + " pages.");
            }
            if (growableBlockCurrentSize <= GrowableBlockHeader.MAX_GROWABLE_SIZE) {
                int currentSize = this.size(nd, address);
                long firstGrowableBlockAddress = this.resizeBlock(nd, address, GrowableBlockHeader.MAX_GROWABLE_SIZE);
                metablockAddress = db.malloc(Database.getBytesThatFitInChunks(neededMetablockPages), (short)7);
                GrowableBlockHeader.ARRAY_SIZE.put(nd, metablockAddress, currentSize);
                GrowableBlockHeader.ALLOCATED_SIZE.put(nd, metablockAddress, GrowableBlockHeader.MAX_GROWABLE_SIZE);
                MetaBlockHeader.METABLOCK_NUM_PAGES.put(nd, metablockAddress, (short)neededMetablockPages);
                db.putRecPtr(metablockAddress + (long)MetaBlockHeader.META_BLOCK_HEADER_BYTES, firstGrowableBlockAddress);
                GROWABLE_BLOCK_ADDRESS.put(nd, address, metablockAddress);
            }
            if ((metablockCurrentPages = MetaBlockHeader.METABLOCK_NUM_PAGES.get(nd, metablockAddress)) < neededMetablockPages) {
                short newMetablockPages = (short)Math.min(32767.0, (double)neededMetablockPages * 1.5);
                long newMetablockAddress = db.malloc(Database.getBytesThatFitInChunks(newMetablockPages), (short)7);
                short oldNumPages = MetaBlockHeader.METABLOCK_NUM_PAGES.get(nd, metablockAddress);
                db.memcpy(newMetablockAddress, metablockAddress, (int)Database.getBytesThatFitInChunks(oldNumPages));
                db.free(metablockAddress, (short)7);
                metablockAddress = newMetablockAddress;
                MetaBlockHeader.METABLOCK_NUM_PAGES.put(nd, metablockAddress, newMetablockPages);
                GROWABLE_BLOCK_ADDRESS.put(nd, address, metablockAddress);
            }
            int currentAllocatedSize = GrowableBlockHeader.ALLOCATED_SIZE.get(nd, metablockAddress);
            assert (currentAllocatedSize % GrowableBlockHeader.MAX_GROWABLE_SIZE == 0);
            int nextBlock = currentBlockCount = currentAllocatedSize / GrowableBlockHeader.MAX_GROWABLE_SIZE;
            while (nextBlock < requiredBlockCount) {
                long nextBlockAddress = db.malloc(this.computeBlockBytes(GrowableBlockHeader.MAX_GROWABLE_SIZE), (short)7);
                db.putRecPtr(metablockAddress + (long)MetaBlockHeader.META_BLOCK_HEADER_BYTES + (long)(nextBlock * 4), nextBlockAddress);
                ++nextBlock;
            }
            GrowableBlockHeader.ALLOCATED_SIZE.put(nd, metablockAddress, neededBlockSize);
        } else {
            long newBlockAddress = this.resizeBlock(nd, address, neededBlockSize);
            GROWABLE_BLOCK_ADDRESS.put(nd, address, newBlockAddress);
        }
    }

    private static int divideRoundingUp(int neededBlockSize, int maxGrowableSize) {
        return (neededBlockSize + maxGrowableSize - 1) / maxGrowableSize;
    }

    private int computeMetablockPagesForBlocks(int requiredBlockCount) {
        return Database.getChunksNeededForBytes(requiredBlockCount * 4 + GrowableBlockHeader.GROWABLE_BLOCK_HEADER_BYTES);
    }

    private long resizeBlock(Nd nd, long address, int newBlockSize) {
        Database db = nd.getDB();
        long oldGrowableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
        if (oldGrowableBlockAddress != 0L) {
            if (newBlockSize == 0) {
                db.free(oldGrowableBlockAddress, (short)7);
                return 0L;
            }
            int oldAllocatedSize = GrowableBlockHeader.ALLOCATED_SIZE.get(nd, oldGrowableBlockAddress);
            if (oldAllocatedSize == newBlockSize) {
                return oldGrowableBlockAddress;
            }
        }
        int arraySize = this.size(nd, address);
        int numToCopySize = Math.min(Math.max(0, arraySize - this.inlineSize), newBlockSize);
        long newGrowableBlockAddress = db.malloc(this.computeBlockBytes(newBlockSize), (short)7);
        if (oldGrowableBlockAddress != 0L) {
            db.memcpy(newGrowableBlockAddress, oldGrowableBlockAddress, this.computeBlockBytes(numToCopySize));
            db.free(oldGrowableBlockAddress, (short)7);
        }
        GrowableBlockHeader.ARRAY_SIZE.put(nd, newGrowableBlockAddress, arraySize);
        GrowableBlockHeader.ALLOCATED_SIZE.put(nd, newGrowableBlockAddress, newBlockSize);
        return newGrowableBlockAddress;
    }

    private int computeBlockBytes(int size) {
        return size * 4 + GrowableBlockHeader.GROWABLE_BLOCK_HEADER_BYTES;
    }

    private void setSize(Nd nd, long address, int size) {
        long growableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
        if (growableBlockAddress == 0L) {
            return;
        }
        GrowableBlockHeader.ARRAY_SIZE.put(nd, growableBlockAddress, size);
    }

    private long getAddressOfRecord(Nd nd, long address, int index) {
        int growableBlockRelativeIndex = index - this.inlineSize;
        if (growableBlockRelativeIndex >= 0) {
            Database db = nd.getDB();
            long growableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
            int size = this.size(nd, address);
            if (index > size) {
                IndexExceptionBuilder builder = nd.describeProblem();
                this.addSizeTo(nd, address, builder);
                builder.addProblemAddress(GROWABLE_BLOCK_ADDRESS, address);
                throw builder.build("Record index " + index + " out of range. Array contains " + size + " elements");
            }
            int growableBlockSize = GrowableBlockHeader.ALLOCATED_SIZE.get(nd, growableBlockAddress);
            if (growableBlockSize > GrowableBlockHeader.MAX_GROWABLE_SIZE) {
                int blockRelativeIndex = growableBlockRelativeIndex % GrowableBlockHeader.MAX_GROWABLE_SIZE;
                int block = growableBlockRelativeIndex / GrowableBlockHeader.MAX_GROWABLE_SIZE;
                long dataBlockAddress = growableBlockAddress + (long)MetaBlockHeader.META_BLOCK_HEADER_BYTES + (long)(block * 4);
                if ((growableBlockAddress = db.getRecPtr(dataBlockAddress)) == 0L) {
                    throw nd.describeProblem().addProblemAddress("backpointer number " + block, dataBlockAddress, 4).addProblemAddress(GROWABLE_BLOCK_ADDRESS, address).build("Null data block found in metablock");
                }
                growableBlockRelativeIndex = blockRelativeIndex;
            }
            long dataStartAddress = growableBlockAddress + (long)GrowableBlockHeader.GROWABLE_BLOCK_HEADER_BYTES;
            return dataStartAddress + (long)(growableBlockRelativeIndex * 4);
        }
        return address + (long)ARRAY_HEADER_BYTES + (long)(index * 4);
    }

    private void addSizeTo(Nd nd, long address, IndexExceptionBuilder builder) {
        long growableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
        if (growableBlockAddress != 0L) {
            builder.addProblemAddress(GrowableBlockHeader.ARRAY_SIZE, growableBlockAddress);
        }
    }

    public long remove(Nd nd, long address, int index) {
        long returnValue;
        int currentSize = this.size(nd, address);
        int lastElementIndex = currentSize - 1;
        Database db = nd.getDB();
        if (index > lastElementIndex || index < 0) {
            IndexExceptionBuilder descriptor = nd.describeProblem().addProblemAddress(GROWABLE_BLOCK_ADDRESS, address);
            this.addSizeTo(nd, address, descriptor);
            throw descriptor.build("Attempt to remove nonexistent element " + index + " from an array of size " + (lastElementIndex + 1));
        }
        long toRemoveAddress = this.getAddressOfRecord(nd, address, index);
        if (index == lastElementIndex) {
            returnValue = 0L;
            db.putRecPtr(toRemoveAddress, 0L);
        } else {
            long lastElementAddress = this.getAddressOfRecord(nd, address, lastElementIndex);
            long lastElementValue = db.getRecPtr(lastElementAddress);
            db.putRecPtr(toRemoveAddress, lastElementValue);
            db.putRecPtr(lastElementAddress, 0L);
            returnValue = lastElementValue;
        }
        this.setSize(nd, address, currentSize - 1);
        this.repackIfNecessary(nd, address, currentSize);
        return returnValue;
    }

    private void repackIfNecessary(Nd nd, long address, int desiredSize) {
        long growableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
        if (growableBlockAddress == 0L) {
            return;
        }
        int desiredGrowableSize = desiredSize - this.inlineSize;
        int currentGrowableSize = GrowableBlockHeader.ALLOCATED_SIZE.get(nd, growableBlockAddress);
        int newGrowableSize = this.getGrowableRegionSizeFor(desiredSize);
        if (newGrowableSize >= currentGrowableSize) {
            return;
        }
        Database db = nd.getDB();
        if (currentGrowableSize > GrowableBlockHeader.MAX_GROWABLE_SIZE) {
            boolean needsRepacking;
            int currentBlockCount = currentGrowableSize / GrowableBlockHeader.MAX_GROWABLE_SIZE;
            int desiredBlockCount = (newGrowableSize + GrowableBlockHeader.MAX_GROWABLE_SIZE - 1) / GrowableBlockHeader.MAX_GROWABLE_SIZE;
            boolean bl = needsRepacking = currentBlockCount - desiredBlockCount > 1 || newGrowableSize <= GrowableBlockHeader.MAX_GROWABLE_SIZE / 2 + 1;
            if (!needsRepacking) {
                return;
            }
            long metablockRecordsAddress = growableBlockAddress + (long)MetaBlockHeader.META_BLOCK_HEADER_BYTES;
            int currentBlock = currentBlockCount;
            while (--currentBlock >= desiredBlockCount) {
                long nextAddress = metablockRecordsAddress + (long)(currentBlock * 4);
                long oldBlockAddress = db.getRecPtr(nextAddress);
                db.free(oldBlockAddress, (short)7);
                db.putRecPtr(nextAddress, 0L);
            }
            if (newGrowableSize > GrowableBlockHeader.MAX_GROWABLE_SIZE) {
                GrowableBlockHeader.ALLOCATED_SIZE.put(nd, growableBlockAddress, newGrowableSize);
                return;
            }
            long firstBlockAddress = db.getRecPtr(metablockRecordsAddress);
            int oldSize = GrowableBlockHeader.ARRAY_SIZE.get(nd, growableBlockAddress);
            db.free(growableBlockAddress, (short)7);
            GROWABLE_BLOCK_ADDRESS.put(nd, address, firstBlockAddress);
            if (firstBlockAddress != 0L) {
                currentGrowableSize = GrowableBlockHeader.MAX_GROWABLE_SIZE;
                GrowableBlockHeader.ARRAY_SIZE.put(nd, firstBlockAddress, oldSize);
                GrowableBlockHeader.ALLOCATED_SIZE.put(nd, firstBlockAddress, GrowableBlockHeader.MAX_GROWABLE_SIZE);
            }
        }
        if (desiredGrowableSize <= currentGrowableSize / 4 + 1) {
            long newBlockAddress = this.resizeBlock(nd, address, newGrowableSize);
            GROWABLE_BLOCK_ADDRESS.put(nd, address, newBlockAddress);
        }
    }

    private int getGrowableRegionSizeFor(int arraySize) {
        int growableRegionSize = arraySize - this.inlineSize;
        if (growableRegionSize <= 0) {
            return 0;
        }
        int nextGrowableSize = RawGrowableArray.getNextPowerOfTwo(Math.max(growableRegionSize, this.inlineSize));
        if (nextGrowableSize > GrowableBlockHeader.MAX_GROWABLE_SIZE) {
            if (growableRegionSize <= GrowableBlockHeader.MAX_GROWABLE_SIZE) {
                return GrowableBlockHeader.MAX_GROWABLE_SIZE;
            }
            return MathUtils.roundUpToNearestMultiple(growableRegionSize, GrowableBlockHeader.MAX_GROWABLE_SIZE);
        }
        return nextGrowableSize;
    }

    private static int getPrevPowerOfTwo(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n - (n >> 1);
    }

    private static int getNextPowerOfTwo(int toTest) {
        int highBit;
        int nextGrowableSize = highBit = RawGrowableArray.getPrevPowerOfTwo(toTest);
        if (highBit != toTest) {
            assert (nextGrowableSize << 1 != 0);
            nextGrowableSize <<= 1;
        }
        return nextGrowableSize;
    }

    public int getRecordSize() {
        return ARRAY_HEADER_BYTES + 4 * this.inlineSize;
    }

    public void destruct(Nd nd, long address) {
        this.repackIfNecessary(nd, address, 0);
    }

    public boolean isEmpty(Nd nd, long address) {
        Database db = nd.getDB();
        long growableBlockAddress = GROWABLE_BLOCK_ADDRESS.get(nd, address);
        if (growableBlockAddress == 0L) {
            if (this.inlineSize == 0) {
                return true;
            }
            long firstValue = db.getRecPtr(address + (long)ARRAY_HEADER_BYTES);
            return firstValue == 0L;
        }
        return GrowableBlockHeader.ARRAY_SIZE.get(nd, growableBlockAddress) == 0;
    }

    static class GrowableBlockHeader {
        public static final FieldInt ARRAY_SIZE;
        public static final FieldInt ALLOCATED_SIZE;
        public static final int GROWABLE_BLOCK_HEADER_BYTES;
        public static final int MAX_GROWABLE_SIZE;
        private static final StructDef<GrowableBlockHeader> type;

        static {
            type = StructDef.createAbstract(GrowableBlockHeader.class);
            ARRAY_SIZE = type.addInt();
            ALLOCATED_SIZE = type.addInt();
            type.done();
            GROWABLE_BLOCK_HEADER_BYTES = type.size();
            MAX_GROWABLE_SIZE = (Database.MAX_SINGLE_BLOCK_MALLOC_SIZE - GROWABLE_BLOCK_HEADER_BYTES) / 4;
        }

        GrowableBlockHeader() {
        }

        static StructDef<GrowableBlockHeader> getType() {
            return type;
        }
    }

    static final class MetaBlockHeader
    extends GrowableBlockHeader {
        public static final FieldShort METABLOCK_NUM_PAGES;
        public static final int META_BLOCK_HEADER_BYTES;
        private static final StructDef<MetaBlockHeader> type;

        static {
            type = StructDef.createAbstract(MetaBlockHeader.class, GrowableBlockHeader.getType());
            METABLOCK_NUM_PAGES = type.addShort();
            type.done();
            META_BLOCK_HEADER_BYTES = type.size();
        }

        MetaBlockHeader() {
        }
    }
}

