/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathJar
extends ClasspathLocation {
    final boolean isOnModulePath;
    protected static SimpleLookupTable PackageCache = new SimpleLookupTable();
    protected static SimpleLookupTable ModuleCache = new SimpleLookupTable();
    String zipFilename;
    IFile resource;
    ZipFile zipFile;
    ZipFile annotationZipFile;
    long lastModified;
    boolean closeZipFileAtEnd;
    private SimpleSet knownPackageNames;
    AccessRuleSet accessRuleSet;
    String externalAnnotationPath;
    String compliance;

    protected static void addToPackageSet(SimpleSet packageSet, String fileName, boolean endsWithSep) {
        int last = endsWithSep ? fileName.length() : fileName.lastIndexOf(47);
        while (last > 0) {
            String packageName = fileName.substring(0, last);
            if (packageSet.addIfNotIncluded(packageName) == null) {
                return;
            }
            last = packageName.lastIndexOf(47);
        }
    }

    protected SimpleSet findPackageSet() {
        String zipFileName = this.zipFilename;
        PackageCacheEntry cacheEntry = (PackageCacheEntry)PackageCache.get(zipFileName);
        long timestamp = this.lastModified();
        long fileSize = new File(zipFileName).length();
        if (cacheEntry != null && cacheEntry.lastModified == timestamp && cacheEntry.fileSize == fileSize) {
            return cacheEntry.packageSet;
        }
        SimpleSet packageSet = new SimpleSet(41);
        packageSet.add("");
        this.readJarContent(packageSet);
        PackageCache.put(zipFileName, new PackageCacheEntry(timestamp, fileSize, packageSet));
        return packageSet;
    }

    protected String readJarContent(SimpleSet packageSet) {
        String modInfo = null;
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            if (fileName.startsWith("META-INF/")) continue;
            if (modInfo == null) {
                String className;
                int folderEnd = fileName.lastIndexOf(47);
                if ((className = fileName.substring(++folderEnd, fileName.length())).equalsIgnoreCase("module-info.class")) {
                    modInfo = fileName;
                }
            }
            ClasspathJar.addToPackageSet(packageSet, fileName, false);
        }
        return modInfo;
    }

    IModule initializeModule() {
        IBinaryModule mod;
        block18: {
            mod = null;
            ZipFile file = null;
            try {
                try {
                    file = new ZipFile(this.zipFilename);
                    String releasePath = "META-INF/versions/" + this.compliance + '/' + "module-info.class";
                    ClassFileReader classfile = null;
                    try {
                        classfile = ClassFileReader.read(file, releasePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (classfile == null) {
                        classfile = ClassFileReader.read(file, "module-info.class");
                    }
                    if (classfile != null) {
                        mod = classfile.getModuleDeclaration();
                    }
                }
                catch (IOException | ClassFormatException exception) {
                    try {
                        if (file != null) {
                            file.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {}
        }
        return mod;
    }

    ClasspathJar(IFile resource, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath) {
        this.resource = resource;
        try {
            URI location = resource.getLocationURI();
            if (location == null) {
                this.zipFilename = "";
            } else {
                File localFile = Util.toLocalFile(location, null);
                this.zipFilename = localFile.getPath();
            }
        }
        catch (CoreException coreException) {
            this.zipFilename = "";
        }
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        this.isOnModulePath = isOnModulePath;
    }

    ClasspathJar(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath) {
        this.zipFilename = zipFilename;
        this.lastModified = lastModified;
        this.zipFile = null;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        this.isOnModulePath = isOnModulePath;
    }

    public ClasspathJar(ZipFile zipFile, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath) {
        this(zipFile.getName(), accessRuleSet, externalAnnotationPath, isOnModulePath);
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = true;
    }

    public ClasspathJar(String fileName, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath) {
        this(fileName, 0L, accessRuleSet, externalAnnotationPath, isOnModulePath);
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
    }

    @Override
    public void cleanup() {
        if (this.closeZipFileAtEnd) {
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [ClasspathJar.cleanup()] Closed ZipFile on " + this.zipFilename);
                    }
                }
                catch (IOException e) {
                    JavaCore.getPlugin().getLog().log(new Status(4, "org.eclipse.jdt.core", "Error closing " + this.zipFile.getName(), (Throwable)e));
                }
                this.zipFile = null;
            }
            if (this.annotationZipFile != null) {
                try {
                    this.annotationZipFile.close();
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [ClasspathJar.cleanup()] Closed Annotation ZipFile on " + this.zipFilename);
                    }
                }
                catch (IOException e) {
                    JavaCore.getPlugin().getLog().log(new Status(4, "org.eclipse.jdt.core", "Error closing " + this.annotationZipFile.getName(), (Throwable)e));
                }
                this.annotationZipFile = null;
            }
        } else if (this.zipFile != null && JavaModelManager.ZIP_ACCESS_VERBOSE) {
            try {
                this.zipFile.size();
                System.out.println("(" + Thread.currentThread() + ") [ClasspathJar.cleanup()] ZipFile NOT closed on " + this.zipFilename);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.module = null;
        this.knownPackageNames = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJar)) {
            return false;
        }
        ClasspathJar jar = (ClasspathJar)o;
        if (!(this.accessRuleSet == jar.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(jar.accessRuleSet))) {
            return false;
        }
        if (!Util.equalOrNull(this.compliance, jar.compliance)) {
            return false;
        }
        return this.zipFilename.equals(jar.zipFilename) && this.lastModified() == jar.lastModified() && this.isOnModulePath == jar.isOnModulePath && this.areAllModuleOptionsEqual(jar);
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        block12: {
            if (!this.isPackage(qualifiedPackageName, moduleName)) {
                return null;
            }
            try {
                char[] modName;
                IBinaryType reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
                if (reader == null) break block12;
                char[] cArray = modName = this.module == null ? null : this.module.name();
                if (reader instanceof ClassFileReader) {
                    ClassFileReader classReader = reader;
                    if (classReader.moduleName == null) {
                        classReader.moduleName = modName;
                    } else {
                        modName = classReader.moduleName;
                    }
                }
                String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                if (this.externalAnnotationPath != null) {
                    try {
                        if (this.annotationZipFile == null) {
                            this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                        }
                        reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                    }
                    catch (IOException iOException) {}
                    if (reader.getExternalAnnotationStatus() == BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED) {
                        reader = new ExternalAnnotationDecorator(reader, null);
                    }
                }
                if (this.accessRuleSet == null) {
                    return new NameEnvironmentAnswer(reader, null, modName);
                }
                return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), modName);
            }
            catch (IOException | ClassFormatException exception) {}
        }
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public int hashCode() {
        return this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        if (!(moduleName == null || this.module != null && moduleName.equals(String.valueOf(this.module.name())))) {
            return false;
        }
        if (this.knownPackageNames == null) {
            this.scanContent();
        }
        return this.knownPackageNames.includes(qualifiedPackageName);
    }

    @Override
    public boolean hasCompilationUnit(String pkgName, String moduleName) {
        if (this.scanContent()) {
            if (!this.knownPackageNames.includes(pkgName)) {
                return false;
            }
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                String fileName = e.nextElement().getName();
                if (!fileName.startsWith(pkgName) || !fileName.toLowerCase().endsWith(".class") || fileName.indexOf(47, pkgName.length() + 1) != -1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean scanContent() {
        try {
            if (this.zipFile == null) {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [ClasspathJar.isPackage(String)] Creating ZipFile on " + this.zipFilename);
                }
                this.zipFile = new ZipFile(this.zipFilename);
                this.closeZipFileAtEnd = true;
                this.knownPackageNames = this.findPackageSet();
            } else {
                this.knownPackageNames = this.findPackageSet();
            }
            return true;
        }
        catch (Exception exception) {
            this.knownPackageNames = new SimpleSet();
            return false;
        }
    }

    public long lastModified() {
        if (this.lastModified == 0L) {
            this.lastModified = new File(this.zipFilename).lastModified();
        }
        return this.lastModified;
    }

    public String toString() {
        String start = "Classpath jar file " + this.zipFilename;
        if (this.accessRuleSet == null) {
            return start;
        }
        return String.valueOf(start) + " with " + this.accessRuleSet;
    }

    @Override
    public String debugPathString() {
        long time = this.lastModified();
        if (time == 0L) {
            return this.zipFilename;
        }
        return String.valueOf(this.zipFilename) + '(' + new Date(time) + " : " + time + ')';
    }

    @Override
    public IModule getModule() {
        if (this.knownPackageNames == null) {
            this.scanContent();
        }
        return this.module;
    }

    public Manifest getManifest() {
        if (!this.scanContent()) {
            return null;
        }
        ZipEntry entry = this.zipFile.getEntry("META-INF/MANIFEST.MF");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = entry != null ? this.zipFile.getInputStream(entry) : null;){
                if (is != null) {
                    return new Manifest(is);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public char[][] listPackages() {
        if (!this.scanContent()) {
            return null;
        }
        char[][] result = new char[this.knownPackageNames.elementSize][];
        int count = 0;
        int i = 0;
        while (i < this.knownPackageNames.values.length) {
            String string = (String)this.knownPackageNames.values[i];
            if (string != null && !string.isEmpty()) {
                result[count++] = string.replace('/', '.').toCharArray();
            }
            ++i;
        }
        if (count < result.length) {
            return (char[][])Arrays.copyOf(result, count);
        }
        return result;
    }

    static class PackageCacheEntry {
        long lastModified;
        long fileSize;
        SimpleSet packageSet;

        PackageCacheEntry(long lastModified, long fileSize, SimpleSet packageSet) {
            this.lastModified = lastModified;
            this.fileSize = fileSize;
            this.packageSet = packageSet;
        }
    }
}

