/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.BinaryField;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelCache;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavadocContents;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class BinaryType
extends BinaryMember
implements IType,
SuffixConstants {
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IMethod[] NO_METHODS = new IMethod[0];
    private static final IType[] NO_TYPES = new IType[0];
    private static final IInitializer[] NO_INITIALIZERS = new IInitializer[0];
    public static final JavadocContents EMPTY_JAVADOC = new JavadocContents(null, org.eclipse.jdt.internal.compiler.util.Util.EMPTY_STRING);

    protected BinaryType(JavaElement parent, String name) {
        super(parent, name);
    }

    @Override
    protected void closing(Object info) throws JavaModelException {
        ClassFileInfo cfi = this.getClassFileInfo();
        cfi.removeBinaryChildren();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BinaryType)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        IBinaryAnnotation[] binaryAnnotations = info.getAnnotations();
        return this.getAnnotations(binaryAnnotations, info.getTagBits());
    }

    @Override
    public IJavaElement[] getChildren() throws JavaModelException {
        ClassFileInfo cfi = this.getClassFileInfo();
        return cfi.binaryChildren;
    }

    protected ClassFileInfo getClassFileInfo() throws JavaModelException {
        return (ClassFileInfo)this.parent.getElementInfo();
    }

    @Override
    public IOrdinaryClassFile getClassFile() {
        return (IOrdinaryClassFile)super.getClassFile();
    }

    @Override
    public IType getDeclaringType() {
        IOrdinaryClassFile classFile = this.getClassFile();
        if (classFile.isOpen()) {
            char[] enclosingTypeName;
            block10: {
                block9: {
                    try {
                        enclosingTypeName = ((IBinaryType)this.getElementInfo()).getEnclosingTypeName();
                        if (enclosingTypeName != null) break block9;
                        return null;
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                }
                enclosingTypeName = ClassFile.unqualifiedName(enclosingTypeName);
                if (classFile.getElementName().length() <= enclosingTypeName.length + 1 || !Character.isDigit(classFile.getElementName().charAt(enclosingTypeName.length + 1))) break block10;
                return null;
            }
            return this.getPackageFragment().getOrdinaryClassFile(String.valueOf(new String(enclosingTypeName)) + ".class").getType();
        }
        String classFileName = classFile.getElementName();
        int lastDollar = -1;
        int i = 0;
        int length = classFileName.length();
        while (i < length) {
            char c = classFileName.charAt(i);
            if (Character.isDigit(c) && lastDollar == i - 1) {
                return null;
            }
            if (c == '$') {
                lastDollar = i;
            }
            ++i;
        }
        if (lastDollar == -1) {
            return null;
        }
        String enclosingName = classFileName.substring(0, lastDollar);
        String enclosingClassFileName = String.valueOf(enclosingName) + ".class";
        return new BinaryType((JavaElement)((Object)this.getPackageFragment().getClassFile(enclosingClassFileName)), Util.localTypeName(enclosingName, enclosingName.lastIndexOf(36), enclosingName.length()));
    }

    @Override
    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(this);
        if (info != null && info != JavaModelCache.NON_EXISTING_JAR_TYPE_INFO) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), false, monitor);
    }

    @Override
    public int getElementType() {
        return 7;
    }

    @Override
    public IField getField(String fieldName) {
        return new BinaryField(this, fieldName);
    }

    @Override
    public int getFlags() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.getModifiers() & 0xFFFFFFDF;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    @Override
    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        try {
            return this.getFullyQualifiedName(enclosingTypeSeparator, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String fieldName = memento.nextToken();
                JavaElement field = (JavaElement)((Object)this.getField(fieldName));
                return field.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '|': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String count = memento.nextToken();
                JavaElement initializer = (JavaElement)((Object)this.getInitializer(Integer.parseInt(count)));
                return initializer.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String selector = memento.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                block16: while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    switch (token.charAt(0)) {
                        case '[': 
                        case ']': 
                        case '}': {
                            break block16;
                        }
                        case '~': {
                            if (!memento.hasMoreTokens()) {
                                return this;
                            }
                            String param = memento.nextToken();
                            StringBuffer buffer = new StringBuffer();
                            while (param.length() == 1 && '[' == param.charAt(0)) {
                                buffer.append('[');
                                if (!memento.hasMoreTokens()) {
                                    return this;
                                }
                                param = memento.nextToken();
                            }
                            params.add(String.valueOf(buffer.toString()) + param);
                            break;
                        }
                        default: {
                            break block16;
                        }
                    }
                }
                String[] parameters = new String[params.size()];
                params.toArray(parameters);
                JavaElement method = (JavaElement)((Object)this.getMethod(selector, parameters));
                switch (token.charAt(0)) {
                    case ')': 
                    case '@': 
                    case '[': 
                    case ']': 
                    case '}': {
                        return method.getHandleFromMemento(token, memento, workingCopyOwner);
                    }
                }
                return method;
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '|' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                JavaElement type = (JavaElement)((Object)this.getType(typeName));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case ']': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeParameterName = memento.nextToken();
                TypeParameter typeParameter = new TypeParameter(this, typeParameterName);
                return typeParameter.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '}': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String annotationName = memento.nextToken();
                Annotation annotation = new Annotation(this, annotationName);
                return annotation.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    @Override
    public IInitializer getInitializer(int count) {
        return new Initializer(this, count);
    }

    @Override
    public IMethod getMethod(String selector, String[] parameterTypeSignatures) {
        return new BinaryMethod(this, selector, parameterTypeSignatures);
    }

    @Override
    public IMethod[] getMethods() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(9);
        int size = list.size();
        if (size == 0) {
            return NO_METHODS;
        }
        IMethod[] array = new IMethod[size];
        list.toArray(array);
        return array;
    }

    @Override
    public IPackageFragment getPackageFragment() {
        IJavaElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 4) {
                return (IPackageFragment)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue(false);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public String getSourceFileName(IBinaryType info) {
        block4: {
            if (info == null) {
                try {
                    info = (IBinaryType)this.getElementInfo();
                    break block4;
                }
                catch (JavaModelException v0) {
                    type = this;
                    enclosingType = this.getDeclaringType();
                    ** while (enclosingType != null)
                }
lbl-1000:
                // 1 sources

                {
                    type = enclosingType;
                    enclosingType = type.getDeclaringType();
                    continue;
                }
lbl12:
                // 1 sources

                return String.valueOf(type.getElementName()) + Util.defaultJavaExtension();
            }
        }
        return this.sourceFileName(info);
    }

    @Override
    public String getSuperclassName() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(ClassFile.translatedName(superclassName));
    }

    @Override
    public String[] getSuperInterfaceNames() throws JavaModelException {
        int length;
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null || (length = names.length) == 0) {
            return CharOperation.NO_STRINGS;
        }
        names = ClassFile.translatedNames(names);
        String[] strings = new String[length];
        int i = 0;
        while (i < length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    @Override
    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        String[] typeParameterSignatures = this.getTypeParameterSignatures();
        int length = typeParameterSignatures.length;
        if (length == 0) {
            return TypeParameter.NO_TYPE_PARAMETERS;
        }
        ITypeParameter[] typeParameters = new ITypeParameter[length];
        int i = 0;
        while (i < typeParameterSignatures.length) {
            String typeParameterName = Signature.getTypeVariable(typeParameterSignatures[i]);
            typeParameters[i] = new TypeParameter(this, typeParameterName);
            ++i;
        }
        return typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        if (genericSignature == null) {
            return CharOperation.NO_STRINGS;
        }
        char[] dotBaseSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.');
        char[][] typeParams = Signature.getTypeParameters(dotBaseSignature);
        return CharOperation.toStrings(typeParams);
    }

    @Override
    public IType getType(String typeName) {
        IClassFile classFile = this.getPackageFragment().getClassFile(String.valueOf(this.getTypeQualifiedName()) + "$" + typeName + ".class");
        return new BinaryType((JavaElement)((Object)classFile), typeName);
    }

    @Override
    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName('$');
    }

    @Override
    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        try {
            return this.getTypeQualifiedName(enclosingTypeSeparator, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    @Override
    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        int size = list.size();
        if (size == 0) {
            return NO_TYPES;
        }
        IType[] array = new IType[size];
        list.toArray(array);
        return array;
    }

    @Override
    public boolean isAnonymous() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isAnonymous();
    }

    @Override
    public boolean isClass() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 1;
    }

    @Override
    public boolean isEnum() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 3;
    }

    public boolean isRecord() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 5;
    }

    @Override
    public boolean isInterface() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        switch (TypeDeclaration.kind(info.getModifiers())) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnnotation() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return TypeDeclaration.kind(info.getModifiers()) == 4;
    }

    @Override
    public boolean isMember() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isMember();
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IJavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        if (project == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullProject);
        }
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        ICompilationUnit[] projectWCs = null;
        if (workingCopies != null) {
            int length = workingCopies.length;
            projectWCs = new ICompilationUnit[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                ICompilationUnit wc = workingCopies[i];
                if (project.equals(wc.getJavaProject())) {
                    projectWCs[index++] = wc;
                }
                ++i;
            }
            if (index != length) {
                ICompilationUnit[] iCompilationUnitArray = projectWCs;
                projectWCs = new ICompilationUnit[index];
                System.arraycopy(iCompilationUnitArray, 0, projectWCs, 0, index);
            }
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, projectWCs, project, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedBinaryType resolvedHandle = new ResolvedBinaryType(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    /*
     * Unable to fully structure code
     */
    public String sourceFileName(IBinaryType info) {
        block3: {
            block4: {
                sourceFileName = info.sourceFileName();
                if (sourceFileName != null) break block3;
                if (!info.isMember()) break block4;
                enclosingType = this.getDeclaringType();
                if (enclosingType != null) ** GOTO lbl8
                return null;
lbl-1000:
                // 1 sources

                {
                    enclosingType = enclosingType.getDeclaringType();
lbl8:
                    // 2 sources

                    ** while (enclosingType.getDeclaringType() != null)
                }
lbl9:
                // 1 sources

                return String.valueOf(enclosingType.getElementName()) + Util.defaultJavaExtension();
            }
            if (info.isLocal() || info.isAnonymous()) {
                typeQualifiedName = this.getTypeQualifiedName();
                dollar = typeQualifiedName.indexOf(36);
                if (dollar == -1) {
                    return String.valueOf(this.getElementName()) + Util.defaultJavaExtension();
                }
                return String.valueOf(typeQualifiedName.substring(0, dollar)) + Util.defaultJavaExtension();
            }
            return String.valueOf(this.getElementName()) + Util.defaultJavaExtension();
        }
        index = CharOperation.lastIndexOf('/', sourceFileName);
        return new String(sourceFileName, index + 1, sourceFileName.length - index - 1);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                if (this.isRecord()) {
                    buffer.append("record ");
                } else if (this.isAnnotation()) {
                    buffer.append("@interface ");
                } else if (this.isEnum()) {
                    buffer.append("enum ");
                } else if (this.isInterface()) {
                    buffer.append("interface ");
                } else {
                    buffer.append("class ");
                }
                this.toStringName(buffer);
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        if (this.getElementName().length() > 0) {
            super.toStringName(buffer);
        } else {
            buffer.append("<anonymous>");
        }
    }
}

