/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;

public class LambdaExpression
extends Expression {
    public static final SimplePropertyDescriptor PARENTHESES_PROPERTY = new SimplePropertyDescriptor(LambdaExpression.class, "parentheses", Boolean.TYPE, true);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(LambdaExpression.class, "parameters", VariableDeclaration.class, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(LambdaExpression.class, "body", ASTNode.class, true, true);
    private static final List PROPERTY_DESCRIPTORS_8_0;
    private boolean hasParentheses = true;
    private ASTNode.NodeList parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    private ASTNode body = null;

    static {
        ArrayList propertyList = new ArrayList(4);
        LambdaExpression.createPropertyList(LambdaExpression.class, propertyList);
        LambdaExpression.addProperty(PARENTHESES_PROPERTY, propertyList);
        LambdaExpression.addProperty(PARAMETERS_PROPERTY, propertyList);
        LambdaExpression.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = LambdaExpression.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS_8_0;
    }

    LambdaExpression(AST ast) {
        super(ast);
        this.unsupportedIn2_3_4();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return LambdaExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == PARENTHESES_PROPERTY) {
            if (get) {
                return this.hasParentheses();
            }
            this.setParentheses(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody(child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 86;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.parameters);
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public boolean hasParentheses() {
        return this.hasParentheses;
    }

    public void setParentheses(boolean hasParentheses) {
        this.preValueChange(PARENTHESES_PROPERTY);
        this.hasParentheses = hasParentheses;
        this.postValueChange(PARENTHESES_PROPERTY);
    }

    public List parameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode getBody() {
        if (this.body == null) {
            LambdaExpression lambdaExpression = this;
            synchronized (lambdaExpression) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new Block(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(ASTNode body) {
        if (!(body instanceof Expression) && !(body instanceof Block)) {
            throw new IllegalArgumentException();
        }
        ASTNode oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public IMethodBinding resolveMethodBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }
}

