/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.internal.core.dom.NaiveASTFlattener;

public abstract class ASTNode {
    final AST ast;
    private ASTNode parent = null;
    private static final Map UNMODIFIABLE_EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    private Object property1 = null;
    private Object property2 = null;
    private int startPosition = -1;
    private int length = 0;
    int typeAndFlags = 0;
    private StructuralPropertyDescriptor location = null;

    ASTNode(AST ast) {
        if (ast == null) {
            throw new IllegalArgumentException();
        }
        this.ast = ast;
        this.setNodeType(this.getNodeType0());
        this.setFlags(ast.getDefaultNodeFlag());
    }

    public final AST getAST() {
        return this.ast;
    }

    public final ASTNode getParent() {
        return this.parent;
    }

    public final StructuralPropertyDescriptor getLocationInParent() {
        return this.location;
    }

    public final ASTNode getRoot() {
        ASTNode candidate = this;
        ASTNode p;
        while ((p = candidate.getParent()) != null) {
            candidate = p;
        }
        return candidate;
    }

    public final Object getStructuralProperty(StructuralPropertyDescriptor property) {
        if (property instanceof SimplePropertyDescriptor) {
            SimplePropertyDescriptor p = (SimplePropertyDescriptor)property;
            if (p.getValueType() == Integer.TYPE) {
                int result = this.internalGetSetIntProperty(p, true, 0);
                return result;
            }
            if (p.getValueType() == Boolean.TYPE) {
                boolean result = this.internalGetSetBooleanProperty(p, true, false);
                return result;
            }
            return this.internalGetSetObjectProperty(p, true, null);
        }
        if (property instanceof ChildPropertyDescriptor) {
            return this.internalGetSetChildProperty((ChildPropertyDescriptor)property, true, null);
        }
        if (property instanceof ChildListPropertyDescriptor) {
            return this.internalGetChildListProperty((ChildListPropertyDescriptor)property);
        }
        throw new IllegalArgumentException();
    }

    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        throw new RuntimeException("Node does not have this property");
    }

    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        throw new RuntimeException("Node does not have this property");
    }

    Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        throw new RuntimeException("Node does not have this property");
    }

    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        throw new RuntimeException("Node does not have this property");
    }

    List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        throw new RuntimeException("Node does not have this property");
    }

    public final List structuralPropertiesForType() {
        return this.internalStructuralPropertiesForType(this.ast.apiLevel, this.ast.isPreviewEnabled());
    }

    abstract List internalStructuralPropertiesForType(int var1);

    List internalStructuralPropertiesForType(int apiLevel, boolean previewEnabled) {
        return this.internalStructuralPropertiesForType(apiLevel);
    }

    static void createPropertyList(Class nodeClass, List propertyList) {
        propertyList.add(nodeClass);
    }

    static void addProperty(StructuralPropertyDescriptor property, List propertyList) {
        Class nodeClass = (Class)propertyList.get(0);
        if (property.getNodeClass() != nodeClass) {
            throw new RuntimeException("Structural property descriptor has wrong node class!");
        }
        propertyList.add(property);
    }

    static List reapPropertyList(List propertyList) {
        propertyList.remove(0);
        ArrayList a = new ArrayList(propertyList.size());
        a.addAll(propertyList);
        return Collections.unmodifiableList(a);
    }

    final void unsupportedIn2() {
        if (this.ast.apiLevel == 2) {
            throw new UnsupportedOperationException("Operation not supported in JLS2 AST");
        }
    }

    final void unsupportedIn2_3() {
        if (this.ast.apiLevel <= 3) {
            throw new UnsupportedOperationException("Operation only supported in JLS4 and later AST");
        }
    }

    final void unsupportedIn2_3_4() {
        if (this.ast.apiLevel < 8) {
            throw new UnsupportedOperationException("Operation only supported in JLS8 and later AST");
        }
    }

    final void unsupportedBelow9() {
        if (this.ast.apiLevel < 9) {
            throw new UnsupportedOperationException("Operation only supported in JLS9 and later AST");
        }
    }

    final void unsupportedBelow10() {
        if (this.ast.apiLevel < 10) {
            throw new UnsupportedOperationException("Operation only supported in ASTs with level JLS10 and above");
        }
    }

    final void unsupportedBelow14() {
        if (this.ast.apiLevel < 14) {
            throw new UnsupportedOperationException("Operation only supported in ASTs with level JLS14 and above");
        }
    }

    final void unsupportedBelow15() {
        if (this.ast.apiLevel < 15) {
            throw new UnsupportedOperationException("Operation only supported in ASTs with level JLS15 and above");
        }
    }

    final void unsupportedBelow16() {
        if (this.ast.apiLevel < 16) {
            throw new UnsupportedOperationException("Operation only supported in ASTs with level JLS16 and above");
        }
    }

    final void unsupportedWithoutPreviewError() {
        if (!this.ast.isPreviewEnabled()) {
            throw new UnsupportedOperationException("Operation only supported in ASTs with previewEnabled flag as true");
        }
    }

    final void supportedOnlyIn2() {
        if (this.ast.apiLevel != 2) {
            throw new UnsupportedOperationException("Operation only supported in JLS2 AST");
        }
    }

    final void supportedOnlyIn2_3_4() {
        if (this.ast.apiLevel >= 8) {
            throw new UnsupportedOperationException("Operation only supported in JLS2, JLS3 and JLS4 ASTs");
        }
    }

    final void supportedOnlyIn12() {
        if (this.ast.apiLevel != 12) {
            throw new UnsupportedOperationException("Operation only supported in JLS12 AST");
        }
    }

    final void supportedOnlyIn16() {
        if (this.ast.apiLevel != 16) {
            throw new UnsupportedOperationException("Operation only supported in JLS16 AST");
        }
    }

    final void setParent(ASTNode parent, StructuralPropertyDescriptor property) {
        this.ast.modifying();
        this.parent = parent;
        this.location = property;
    }

    static void checkNewChild(ASTNode node, ASTNode newChild, boolean cycleCheck, Class nodeType) {
        if (newChild.ast != node.ast) {
            throw new IllegalArgumentException();
        }
        if (newChild.getParent() != null) {
            throw new IllegalArgumentException();
        }
        if (cycleCheck && newChild == node.getRoot()) {
            throw new IllegalArgumentException();
        }
        Class<?> childClass = newChild.getClass();
        if (nodeType != null && !nodeType.isAssignableFrom(childClass)) {
            throw new ClassCastException(childClass + " is not an instance of " + nodeType);
        }
        if ((newChild.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
    }

    final void preReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        if (newChild != null) {
            ASTNode.checkNewChild(this, newChild, property.cycleRisk, null);
        }
        if (oldChild != null) {
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            if (newChild != null) {
                this.ast.preReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.preRemoveChildEvent(this, oldChild, property);
            }
            oldChild.setParent(null, null);
        } else if (newChild != null) {
            this.ast.preAddChildEvent(this, newChild, property);
        }
        if (newChild != null) {
            newChild.setParent(this, property);
        }
    }

    final void postReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if (newChild != null) {
            if (oldChild != null) {
                this.ast.postReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.postAddChildEvent(this, newChild, property);
            }
        } else {
            this.ast.postRemoveChildEvent(this, oldChild, property);
        }
    }

    final void preValueChange(SimplePropertyDescriptor property) {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.preValueChangeEvent(this, property);
        this.ast.modifying();
    }

    final void postValueChange(SimplePropertyDescriptor property) {
        this.ast.postValueChangeEvent(this, property);
    }

    final void checkModifiable() {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.modifying();
    }

    final void preLazyInit() {
        this.ast.disableEvents();
    }

    final void postLazyInit(ASTNode newChild, ChildPropertyDescriptor property) {
        newChild.setParent(this, property);
        this.ast.reenableEvents();
    }

    public final int getFlags() {
        return this.typeAndFlags & 0xFFFF;
    }

    public final void setFlags(int flags) {
        this.ast.modifying();
        int old = this.typeAndFlags & 0xFFFF0000;
        this.typeAndFlags = old | flags & 0xFFFF;
    }

    public final int getNodeType() {
        return this.typeAndFlags >>> 16;
    }

    private void setNodeType(int nodeType) {
        int old = this.typeAndFlags & 0xFFFF0000;
        this.typeAndFlags = old | nodeType << 16;
    }

    abstract int getNodeType0();

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final void accept(ASTVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        if (visitor.preVisit2(this)) {
            this.accept0(visitor);
        }
        visitor.postVisit(this);
    }

    abstract void accept0(ASTVisitor var1);

    final void acceptChild(ASTVisitor visitor, ASTNode child) {
        if (child == null) {
            return;
        }
        child.accept(visitor);
    }

    final void acceptChildren(ASTVisitor visitor, NodeList children) {
        NodeList.Cursor cursor = children.newCursor();
        try {
            while (cursor.hasNext()) {
                ASTNode child = (ASTNode)cursor.next();
                child.accept(visitor);
            }
        }
        finally {
            children.releaseCursor(cursor);
        }
    }

    public final int getStartPosition() {
        return this.startPosition;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setSourceRange(int startPosition, int length) {
        if (startPosition >= 0 && length < 0) {
            throw new IllegalArgumentException();
        }
        if (startPosition < 0 && length != 0) {
            throw new IllegalArgumentException();
        }
        this.checkModifiable();
        this.startPosition = startPosition;
        this.length = length;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        int p = buffer.length();
        try {
            this.appendDebugString(buffer);
        }
        catch (RuntimeException runtimeException) {
            buffer.setLength(p);
            buffer.append("!");
            buffer.append(this.standardToString());
        }
        return buffer.toString();
    }

    final String standardToString() {
        return super.toString();
    }

    void appendDebugString(StringBuffer buffer) {
        this.appendPrintString(buffer);
    }

    final void appendPrintString(StringBuffer buffer) {
        NaiveASTFlattener printer = new NaiveASTFlattener();
        this.accept(printer);
        buffer.append(printer.getResult());
    }

    class NodeList
    extends AbstractList {
        ArrayList store = new ArrayList(0);
        ChildListPropertyDescriptor propertyDescriptor;
        private List cursors = null;

        NodeList(ChildListPropertyDescriptor property) {
            this.propertyDescriptor = property;
        }

        @Override
        public int size() {
            return this.store.size();
        }

        @Override
        public Object get(int index) {
            return this.store.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode newChild = (ASTNode)element;
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if (oldChild == newChild) {
                return oldChild;
            }
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preReplaceChildEvent(ASTNode.this, oldChild, newChild, this.propertyDescriptor);
            ASTNode result = this.store.set(index, newChild);
            oldChild.setParent(null, null);
            newChild.setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postReplaceChildEvent(ASTNode.this, oldChild, newChild, this.propertyDescriptor);
            return result;
        }

        @Override
        public void add(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode newChild = (ASTNode)element;
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preAddChildEvent(ASTNode.this, newChild, this.propertyDescriptor);
            this.store.add(index, element);
            this.updateCursors(index, 1);
            newChild.setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postAddChildEvent(ASTNode.this, newChild, this.propertyDescriptor);
        }

        @Override
        public Object remove(int index) {
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.this.ast.preRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            oldChild.setParent(null, null);
            Object result = this.store.remove(index);
            this.updateCursors(index, -1);
            ASTNode.this.ast.postRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Cursor newCursor() {
            NodeList nodeList = this;
            synchronized (nodeList) {
                if (this.cursors == null) {
                    this.cursors = new ArrayList(1);
                }
                Cursor result = new Cursor();
                this.cursors.add(result);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseCursor(Cursor cursor) {
            NodeList nodeList = this;
            synchronized (nodeList) {
                this.cursors.remove(cursor);
                if (this.cursors.isEmpty()) {
                    this.cursors = null;
                }
            }
        }

        private synchronized void updateCursors(int index, int delta) {
            if (this.cursors == null) {
                return;
            }
            for (Cursor c : this.cursors) {
                c.update(index, delta);
            }
        }

        class Cursor
        implements Iterator {
            private int position = 0;

            Cursor() {
            }

            @Override
            public boolean hasNext() {
                return this.position < NodeList.this.store.size();
            }

            public Object next() {
                Object result = NodeList.this.store.get(this.position);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            void update(int index, int delta) {
                if (this.position > index) {
                    this.position += delta;
                }
            }
        }
    }
}

