/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.EclipseAppDescriptor;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;

public class EclipseAppHandle
extends ApplicationHandle
implements IApplicationContext,
ApplicationRunnable {
    private static final Object NULL_RESULT = new Object();
    private volatile ServiceRegistration handleRegistration;
    private int status = 1;
    private final Map<String, Object> arguments;
    private Object application;
    private final Boolean defaultAppInstance;
    private Object result;
    private boolean setResult = false;
    private boolean setAsyncResult = false;
    private final boolean[] registrationLock = new boolean[]{true};

    EclipseAppHandle(String instanceId, Map<String, Object> arguments, EclipseAppDescriptor descriptor) {
        super(instanceId, descriptor);
        this.defaultAppInstance = arguments == null || arguments.get("eclipse.application.default") == null ? Boolean.FALSE : (Boolean)arguments.remove("eclipse.application.default");
        this.arguments = arguments == null ? new HashMap<String, Object>(2) : new HashMap<String, Object>(arguments);
    }

    @Override
    public synchronized String getState() {
        switch (this.status) {
            case 1: {
                return "org.eclipse.equinox.app.starting";
            }
            case 2: {
                return "RUNNING";
            }
            case 4: {
                return "STOPPING";
            }
        }
        if (this.getServiceRegistration() == null) {
            throw new IllegalStateException(NLS.bind(Messages.application_error_state_stopped, this.getInstanceId()));
        }
        return "org.eclipse.equinox.app.stopped";
    }

    @Override
    protected void destroySpecific() {
        this.setAppStatus(4);
        IApplication app = this.getApplication();
        if (app != null) {
            app.stop();
        }
        this.setAppStatus(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceRegistration(ServiceRegistration sr) {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            this.handleRegistration = sr;
            this.registrationLock[0] = sr != null;
            this.registrationLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistration getServiceRegistration() {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            if (this.handleRegistration == null && this.registrationLock[0]) {
                try {
                    this.registrationLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.handleRegistration;
        }
    }

    ServiceReference getServiceReference() {
        ServiceRegistration reg = this.getServiceRegistration();
        if (reg == null) {
            return null;
        }
        try {
            return reg.getReference();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    Dictionary<String, Object> getServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>(6);
        ((Dictionary)props).put("service.pid", this.getInstanceId());
        ((Dictionary)props).put("application.state", this.getState());
        ((Dictionary)props).put("application.descriptor", this.getApplicationDescriptor().getApplicationId());
        ((Dictionary)props).put("eclipse.application.type", ((EclipseAppDescriptor)this.getApplicationDescriptor()).getThreadTypeString());
        ((Dictionary)props).put("application.supports.exitvalue", Boolean.TRUE);
        if (this.defaultAppInstance.booleanValue()) {
            ((Dictionary)props).put("eclipse.application.default", this.defaultAppInstance);
        }
        return props;
    }

    private synchronized void setAppStatus(int status) {
        if (this.status == status) {
            return;
        }
        if ((status & 1) != 0) {
            throw new IllegalArgumentException("Cannot set app status to starting");
        }
        if ((status & 4) != 0 && (this.status & 0xC) != 0) {
            return;
        }
        this.status = status;
        ServiceRegistration handleReg = this.getServiceRegistration();
        if (handleReg == null) {
            return;
        }
        handleReg.setProperties(this.getServiceProperties());
        if ((this.status & 8) != 0) {
            ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().unlock(this);
            handleReg.unregister();
            this.setServiceRegistration(null);
        }
    }

    public Map getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run(Object context) throws Exception {
        if (context != null) {
            this.arguments.put("application.args", context);
        } else {
            context = this.arguments.get("application.args");
            if (context == null) {
                context = CommandLineArgs.getApplicationArgs();
                this.arguments.put("application.args", context);
            }
        }
        Object tempResult = null;
        try {
            Object app;
            EclipseAppHandle eclipseAppHandle = this;
            synchronized (eclipseAppHandle) {
                if ((this.status & 5) == 0) {
                    throw new ApplicationException(3, NLS.bind(Messages.application_instance_stopped, this.getInstanceId()));
                }
                app = this.application = this.getConfiguration().createExecutableExtension("run");
                this.notifyAll();
            }
            tempResult = app instanceof IApplication ? ((IApplication)app).start(this) : EclipseAppContainer.callMethodWithException(app, "run", new Class[]{Object.class}, new Object[]{context});
            if (tempResult == null) {
                tempResult = NULL_RESULT;
            }
        }
        catch (Throwable throwable) {
            tempResult = this.setInternalResult(tempResult, false, null);
            throw throwable;
        }
        tempResult = this.setInternalResult(tempResult, false, null);
        if (Activator.DEBUG) {
            System.out.println(NLS.bind(Messages.application_returned, new String[]{this.getApplicationDescriptor().getApplicationId(), tempResult == null ? "null" : tempResult.toString()}));
        }
        return tempResult;
    }

    private synchronized Object setInternalResult(Object result, boolean isAsync, IApplication tokenApp) {
        if (this.setResult) {
            throw new IllegalStateException("The result of the application is already set.");
        }
        if (isAsync) {
            if (!this.setAsyncResult) {
                throw new IllegalStateException("The application must return IApplicationContext.EXIT_ASYNC_RESULT to set asynchronous results.");
            }
            if (this.application != tokenApp) {
                throw new IllegalArgumentException("The application is not the correct instance for this application context.");
            }
        } else if (result == IApplicationContext.EXIT_ASYNC_RESULT) {
            this.setAsyncResult = true;
            return NULL_RESULT;
        }
        this.result = result;
        this.setResult = true;
        this.application = null;
        this.notifyAll();
        this.setAppStatus(4);
        this.setAppStatus(8);
        if (this.isDefault() && result != null) {
            int exitCode = result instanceof Integer ? (Integer)result : 0;
            Activator.setProperty("eclipse.exitcode", Integer.toString(exitCode));
        }
        return result;
    }

    @Override
    public void stop() {
        try {
            this.destroy();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private synchronized IApplication getApplication() {
        if (this.handleRegistration != null && this.application == null) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (IApplication)(this.application instanceof IApplication ? this.application : null);
    }

    private IConfigurationElement getConfiguration() {
        IExtension applicationExtension = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAppExtension(this.getApplicationDescriptor().getApplicationId());
        if (applicationExtension == null) {
            throw new RuntimeException(NLS.bind(Messages.application_notFound, this.getApplicationDescriptor().getApplicationId(), ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAvailableAppsMsg()));
        }
        IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
        if (configs.length == 0) {
            throw new RuntimeException(NLS.bind(Messages.application_invalidExtension, this.getApplicationDescriptor().getApplicationId()));
        }
        return configs[0];
    }

    boolean isDefault() {
        return this.defaultAppInstance;
    }

    public synchronized Object waitForResult(int timeout) {
        try {
            return this.getExitValue(timeout);
        }
        catch (InterruptedException | ApplicationException exception) {
            return null;
        }
    }

    @Override
    public synchronized Object getExitValue(long timeout) throws ApplicationException, InterruptedException {
        if (this.handleRegistration == null && this.application == null) {
            return this.result;
        }
        long startTime = System.currentTimeMillis();
        long delay = timeout;
        while (!(this.setResult || delay <= 0L && timeout != 0L)) {
            this.wait(delay);
            if (timeout <= 0L) continue;
            delay -= System.currentTimeMillis() - startTime;
        }
        if (this.result == null) {
            throw new ApplicationException(6);
        }
        if (this.result == NULL_RESULT) {
            return null;
        }
        return this.result;
    }
}

