/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ConsoleManager {
    private final BundleContext context;
    private final String consoleBundle;
    private final String consolePort;

    public ConsoleManager(BundleContext context, EquinoxConfiguration equinoxConfig) {
        String port = null;
        String consolePropValue = equinoxConfig.getConfiguration("osgi.console");
        if (consolePropValue != null) {
            int index = consolePropValue.lastIndexOf(":");
            port = consolePropValue.substring(index + 1);
        }
        this.consolePort = port != null ? port.trim() : port;
        String enabled = equinoxConfig.getConfiguration("osgi.console.enable.builtin", "org.eclipse.equinox.console");
        this.context = context;
        if (!"true".equals(enabled) || "none".equals(this.consolePort)) {
            this.consoleBundle = "false".equals(enabled) ? "org.eclipse.equinox.console" : enabled;
            return;
        }
        this.consoleBundle = "unknown";
    }

    public static ConsoleManager startConsole(BundleContext context, EquinoxConfiguration equinoxConfig) {
        ConsoleManager consoleManager = new ConsoleManager(context, equinoxConfig);
        return consoleManager;
    }

    public void checkForConsoleBundle() throws BundleException {
        if ("none".equals(this.consolePort)) {
            return;
        }
        ServiceReference<PackageAdmin> paRef = this.context.getServiceReference(PackageAdmin.class);
        PackageAdmin pa = paRef == null ? null : this.context.getService(paRef);
        Bundle[] consoles = pa.getBundles(this.consoleBundle, null);
        if (consoles == null || consoles.length == 0) {
            if (this.consolePort != null) {
                throw new BundleException("Could not find bundle: " + this.consoleBundle, 1);
            }
            return;
        }
        try {
            consoles[0].start(1);
        }
        catch (BundleException e) {
            throw new BundleException("Could not start bundle: " + this.consoleBundle, 1, e);
        }
    }

    public void stopConsole() {
    }
}

