/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PerformanceStatsProcessor
extends Job {
    private static final PerformanceStatsProcessor instance = new PerformanceStatsProcessor();
    private final ArrayList<PerformanceStats> changes = new ArrayList();
    private final HashMap<PerformanceStats, Long> failures = new HashMap();
    private final ListenerList<PerformanceStats.PerformanceListener> listeners = new ListenerList();
    private FrameworkLog log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changed(PerformanceStats stats) {
        PerformanceStatsProcessor performanceStatsProcessor = instance;
        synchronized (performanceStatsProcessor) {
            PerformanceStatsProcessor.instance.changes.add(stats);
        }
        instance.schedule(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failed(PerformanceStats stats, String pluginId, long elapsed) {
        PerformanceStatsProcessor performanceStatsProcessor = instance;
        synchronized (performanceStatsProcessor) {
            PerformanceStatsProcessor.instance.failures.put(stats, elapsed);
        }
        instance.schedule(2000L);
        instance.logFailure(stats, pluginId, elapsed);
    }

    private PerformanceStatsProcessor() {
        super("Performance Stats");
        this.setSystem(true);
        this.setPriority(50);
        BundleContext context = PlatformActivator.getContext();
        String filter = "(performance=" + Boolean.TRUE + ')';
        FrameworkLog perfLog = null;
        try {
            Collection<ServiceReference<FrameworkLog>> references = context.getServiceReferences(FrameworkLog.class, filter);
            if (references != null && !references.isEmpty()) {
                perfLog = context.getService(references.iterator().next());
                IPath logLocation = Platform.getLogFileLocation();
                logLocation = logLocation.removeLastSegments(1).append("performance.log");
                perfLog.setFile(logLocation.toFile(), false);
            }
        }
        catch (Exception e) {
            Status error = new Status(4, "org.eclipse.core.runtime", 1, "Error loading performance log", e);
            RuntimeLog.log(error);
        }
        if (perfLog == null) {
            perfLog = InternalPlatform.getDefault().getFrameworkLog();
        }
        this.log = perfLog;
    }

    private void logFailure(PerformanceStats stats, String pluginId, long elapsed) {
        if (this.log == null) {
            return;
        }
        if (pluginId == null) {
            pluginId = "org.eclipse.core.runtime";
        }
        String msg = "Performance failure: " + stats.getEvent() + " blame: " + stats.getBlameString() + " context: " + stats.getContext() + " duration: " + elapsed;
        Status status = new Status(2, pluginId, 1, msg, new RuntimeException());
        this.log.log(new FrameworkLogEntry(status, status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), 0, status.getException(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus run(IProgressMonitor monitor) {
        Long[] failedTimes;
        PerformanceStats[] failedEvents;
        PerformanceStats[] events;
        PerformanceStatsProcessor performanceStatsProcessor = this;
        synchronized (performanceStatsProcessor) {
            events = this.changes.toArray(new PerformanceStats[this.changes.size()]);
            this.changes.clear();
            failedEvents = this.failures.keySet().toArray(new PerformanceStats[this.failures.size()]);
            failedTimes = this.failures.values().toArray(new Long[this.failures.size()]);
            this.failures.clear();
        }
        for (PerformanceStats.PerformanceListener listener : this.listeners) {
            if (events.length > 0) {
                listener.eventsOccurred(events);
            }
            int j = 0;
            while (j < failedEvents.length) {
                listener.eventFailed(failedEvents[j], failedTimes[j]);
                ++j;
            }
        }
        this.schedule(2000L);
        return Status.OK_STATUS;
    }

    @Override
    public boolean shouldRun() {
        return !this.changes.isEmpty() || !this.failures.isEmpty();
    }
}

