/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class FindSupport {
    private static String[] NL_JAR_VARIANTS = FindSupport.buildNLVariants(Activator.getContext() == null ? System.getProperty("osgi.nl") : Activator.getContext().getProperty("osgi.nl"));

    private static String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        Path base = new Path("nl");
        IPath path = new Path(nl.replace('_', '/'));
        while (path.segmentCount() > 0) {
            result.add(base.append(path).toString());
            if (path.segmentCount() > 1) {
                result.add(base.append(path.toString().replace('/', '_')).toString());
            }
            path = path.removeLastSegments(1);
        }
        return result.toArray(new String[result.size()]);
    }

    public static URL find(Bundle b, IPath path, Map<String, String> override) {
        return FindSupport.find(b, path, override, null);
    }

    private static URL find(Bundle b, IPath path, Map<String, String> override, ArrayList<URL> multiple) {
        if (path == null) {
            return null;
        }
        URL result = null;
        if (path.isEmpty() || path.isRoot()) {
            result = FindSupport.findInPlugin(b, Path.EMPTY, multiple);
            if (result == null || multiple != null) {
                result = FindSupport.findInFragments(b, Path.EMPTY, multiple);
            }
            return result;
        }
        String first = path.segment(0);
        if (first.charAt(0) != '$') {
            result = FindSupport.findInPlugin(b, path, multiple);
            if (result == null || multiple != null) {
                result = FindSupport.findInFragments(b, path, multiple);
            }
            return result;
        }
        IPath rest = path.removeFirstSegments(1);
        if (first.equalsIgnoreCase("$nl$")) {
            return FindSupport.findNL(b, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$os$")) {
            return FindSupport.findOS(b, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$ws$")) {
            return FindSupport.findWS(b, rest, override, multiple);
        }
        if (first.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private static URL findOS(Bundle b, IPath path, Map<String, String> override, ArrayList<URL> multiple) {
        String os = null;
        if (override != null) {
            try {
                os = override.get("$os$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (os == null) {
            os = Activator.getContext().getProperty("osgi.os");
        }
        if (os.length() == 0) {
            return null;
        }
        String osArch = null;
        if (override != null) {
            try {
                osArch = override.get("$arch$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (osArch == null) {
            osArch = Activator.getContext().getProperty("osgi.arch");
        }
        if (osArch.length() == 0) {
            return null;
        }
        URL result = null;
        IPath base = new Path("os").append(os).append(osArch);
        while (base.segmentCount() != 1) {
            IPath filePath = base.append(path);
            result = FindSupport.findInPlugin(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            result = FindSupport.findInFragments(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            base = base.removeLastSegments(1);
        }
        result = FindSupport.findInPlugin(b, path, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        return FindSupport.findInFragments(b, path, multiple);
    }

    private static URL findWS(Bundle b, IPath path, Map<String, String> override, ArrayList<URL> multiple) {
        IPath filePath;
        URL result;
        String ws = null;
        if (override != null) {
            try {
                ws = override.get("$ws$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (ws == null) {
            ws = Activator.getContext().getProperty("osgi.ws");
        }
        if ((result = FindSupport.findInPlugin(b, filePath = new Path("ws").append(ws).append(path), multiple)) != null && multiple == null) {
            return result;
        }
        result = FindSupport.findInFragments(b, filePath, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        result = FindSupport.findInPlugin(b, path, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        return FindSupport.findInFragments(b, path, multiple);
    }

    private static URL findNL(Bundle b, IPath path, Map<String, String> override, ArrayList<URL> multiple) {
        String nl = null;
        String[] nlVariants = null;
        if (override != null) {
            try {
                nl = override.get("$nl$");
            }
            catch (ClassCastException classCastException) {}
        }
        String[] stringArray = nlVariants = nl == null ? NL_JAR_VARIANTS : FindSupport.buildNLVariants(nl);
        if (nl != null && nl.length() == 0) {
            return null;
        }
        URL result = null;
        String[] stringArray2 = nlVariants;
        int n = nlVariants.length;
        int n2 = 0;
        while (n2 < n) {
            String nlVariant = stringArray2[n2];
            IPath filePath = new Path(nlVariant).append(path);
            result = FindSupport.findInPlugin(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            result = FindSupport.findInFragments(b, filePath, multiple);
            if (result != null && multiple == null) {
                return result;
            }
            ++n2;
        }
        result = FindSupport.findInPlugin(b, path, multiple);
        if (result != null && multiple == null) {
            return result;
        }
        return FindSupport.findInFragments(b, path, multiple);
    }

    private static URL findInPlugin(Bundle b, IPath filePath, ArrayList<URL> multiple) {
        URL result = b.getEntry(filePath.toString());
        if (result != null && multiple != null) {
            multiple.add(result);
        }
        return result;
    }

    private static URL findInFragments(Bundle b, IPath filePath, ArrayList<URL> multiple) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        Bundle[] fragments = activator.getFragments(b);
        if (fragments == null) {
            return null;
        }
        if (multiple != null) {
            multiple.ensureCapacity(fragments.length + 1);
        }
        Bundle[] bundleArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            URL fileURL = fragment.getEntry(filePath.toString());
            if (fileURL != null) {
                if (multiple == null) {
                    return fileURL;
                }
                multiple.add(fileURL);
            }
            ++n2;
        }
        return null;
    }
}

