/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.BuildConfiguration;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspaceDescriptionReader;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LocalMetaArea
implements ICoreConstants {
    protected final IPath metaAreaLocation = ResourcesPlugin.getPlugin().getStateLocation();
    protected final IPath projectMetaLocation = this.metaAreaLocation.append(".projects");

    public void clearOldDescription(IProject target) {
        Workspace.clear(this.getOldDescriptionLocationFor(target).toFile());
    }

    public void clearRefresh(IProject target) {
        Workspace.clear(this.getRefreshLocationFor(target).toFile());
    }

    public void create(IProject target) {
        File file = this.locationFor(target).toFile();
        Workspace.clear(file);
        file.mkdirs();
    }

    public synchronized void createMetaArea() throws CoreException {
        File workspaceLocation = this.metaAreaLocation.toFile();
        Workspace.clear(workspaceLocation);
        if (!workspaceLocation.mkdirs()) {
            String message = NLS.bind(Messages.resources_writeWorkspaceMeta, workspaceLocation);
            throw new ResourceException(568, null, message, null);
        }
    }

    public void delete(IProject target) throws CoreException {
        IPath path = this.locationFor(target);
        if (!Workspace.clear(path.toFile()) && path.toFile().exists()) {
            String message = NLS.bind(Messages.resources_deleteMeta, target.getFullPath());
            throw new ResourceException(569, target.getFullPath(), message, null);
        }
    }

    public IPath getBackupLocationFor(IPath file) {
        return file.removeLastSegments(1).append(String.valueOf(file.lastSegment()) + ".bak");
    }

    public IPath getHistoryStoreLocation() {
        return this.metaAreaLocation.append(".history");
    }

    public IPath getLocation() {
        return this.metaAreaLocation;
    }

    public IPath getMarkersLocationFor(IResource resource) {
        Assert.isNotNull(resource);
        Assert.isLegal(resource.getType() == 8 || resource.getType() == 4);
        return this.locationFor(resource).append(".markers");
    }

    public IPath getMarkersSnapshotLocationFor(IResource resource) {
        return this.getMarkersLocationFor(resource).addFileExtension("snap");
    }

    public IPath getOldDescriptionLocationFor(IProject target) {
        return this.locationFor(target).append(".prj");
    }

    public IPath getOldWorkspaceDescriptionLocation() {
        return this.metaAreaLocation.append(".workspace");
    }

    public IPath getRefreshLocationFor(IProject project) {
        Assert.isNotNull(project);
        return this.locationFor(project).append(".refresh");
    }

    public IPath getSafeTableLocationFor(String pluginId) {
        IPath prefix = this.metaAreaLocation.append(".safetable");
        if (pluginId.equals("org.eclipse.core.resources")) {
            return prefix.append(pluginId);
        }
        int saveNumber = this.getWorkspace().getSaveManager().getSaveNumber(pluginId);
        return prefix.append(String.valueOf(pluginId) + "." + saveNumber);
    }

    public IPath getSnapshotLocationFor(IResource resource) {
        Assert.isNotNull(resource);
        Assert.isLegal(resource.getType() == 8);
        IPath key = resource.getFullPath().append(".tree");
        String sequenceNumber = this.getWorkspace().getSaveManager().getMasterTable().getProperty(key.toString());
        if (sequenceNumber == null) {
            sequenceNumber = "0";
        }
        return this.metaAreaLocation.append(String.valueOf(sequenceNumber) + ".snap");
    }

    public IPath getLegacySnapshotLocationFor(IResource resource) {
        Assert.isNotNull(resource);
        Assert.isLegal(resource.getType() == 8);
        return this.metaAreaLocation.append(".snap");
    }

    public IPath getSyncInfoLocationFor(IResource resource) {
        Assert.isNotNull(resource);
        Assert.isLegal(resource.getType() == 8 || resource.getType() == 4);
        return this.locationFor(resource).append(".syncinfo");
    }

    public IPath getSyncInfoSnapshotLocationFor(IResource resource) {
        return this.getSyncInfoLocationFor(resource).addFileExtension("snap");
    }

    public IPath getTreeLocationFor(IResource target, boolean updateSequenceNumber) {
        IPath key = target.getFullPath().append(".tree");
        String sequenceNumber = this.getWorkspace().getSaveManager().getMasterTable().getProperty(key.toString());
        if (sequenceNumber == null) {
            sequenceNumber = "0";
        }
        if (updateSequenceNumber) {
            int n = Integer.parseInt(sequenceNumber) + 1;
            n = n < 0 ? 1 : n;
            sequenceNumber = Integer.toString(n);
            this.getWorkspace().getSaveManager().getMasterTable().setProperty(key.toString(), sequenceNumber);
        }
        return this.locationFor(target).append(String.valueOf(sequenceNumber) + ".tree");
    }

    public IPath getWorkingLocation(IResource resource, String id) {
        return this.locationFor(resource).append(id);
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public boolean hasSavedProject(IProject project) {
        return this.getOldDescriptionLocationFor(project).toFile().exists() || this.locationFor(project).append(".location").toFile().exists();
    }

    public boolean hasSavedWorkspace() {
        return this.metaAreaLocation.toFile().exists() || this.getBackupLocationFor(this.metaAreaLocation).toFile().exists();
    }

    public IPath locationFor(IPath resourcePath) {
        if (Path.ROOT.equals(resourcePath)) {
            return this.metaAreaLocation.append(".root");
        }
        return this.projectMetaLocation.append(resourcePath.segment(0));
    }

    public IPath locationFor(IResource resource) {
        if (resource.getType() == 8) {
            return this.metaAreaLocation.append(".root");
        }
        return this.projectMetaLocation.append(resource.getProject().getName());
    }

    public ProjectDescription readOldDescription(IProject project) throws CoreException {
        IPath path = this.getOldDescriptionLocationFor(project);
        if (!path.toFile().exists()) {
            return null;
        }
        IPath tempPath = this.getBackupLocationFor(path);
        ProjectDescription description = null;
        try {
            description = new ProjectDescriptionReader(project).read(path, tempPath);
        }
        catch (IOException e) {
            String msg = NLS.bind(Messages.resources_readMeta, project.getName());
            throw new ResourceException(567, project.getFullPath(), msg, e);
        }
        if (description == null) {
            String msg = NLS.bind(Messages.resources_readMeta, project.getName());
            throw new ResourceException(567, project.getFullPath(), msg, null);
        }
        return description;
    }

    public WorkspaceDescription readOldWorkspace() {
        IPath path = this.getOldWorkspaceDescriptionLocation();
        IPath tempPath = this.getBackupLocationFor(path);
        try {
            WorkspaceDescription oldDescription = (WorkspaceDescription)new WorkspaceDescriptionReader().read(path, tempPath);
            Workspace.clear(path.toFile());
            Workspace.clear(tempPath.toFile());
            return oldDescription;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void readPrivateDescription(IProject target, ProjectDescription description) {
        IPath locationFile = this.locationFor(target).append(".location");
        File file = locationFile.toFile();
        if (!file.exists() && !(file = (locationFile = this.getBackupLocationFor(locationFile)).toFile()).exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DataInputStream dataIn = new DataInputStream(new SafeChunkyInputStream(file, 500));){
                try {
                    String location = dataIn.readUTF();
                    if (location.length() > 0) {
                        if (location.startsWith("URI//")) {
                            description.setLocationURI(URI.create(location.substring("URI//".length())));
                        } else {
                            description.setLocationURI(URIUtil.toURI(Path.fromOSString(location)));
                        }
                    }
                }
                catch (Exception e) {
                    String msg = NLS.bind(Messages.resources_exReadProjectLocation, target.getName());
                    Policy.log(new ResourceStatus(4, 567, target.getFullPath(), msg, (Throwable)e));
                }
                int numRefs = dataIn.readInt();
                IProject[] references = new IProject[numRefs];
                IWorkspaceRoot root = this.getWorkspace().getRoot();
                int i = 0;
                while (i < numRefs) {
                    references[i] = root.getProject(dataIn.readUTF());
                    ++i;
                }
                description.setDynamicReferences(references);
                String[] configs = new String[dataIn.readInt()];
                int i2 = 0;
                while (i2 < configs.length) {
                    configs[i2] = dataIn.readUTF();
                    ++i2;
                }
                if (configs.length > 0) {
                    description.setBuildConfigs(configs);
                }
                description.setActiveBuildConfig(dataIn.readUTF());
                int numBuildConifgsWithRefs = dataIn.readInt();
                HashMap<String, IBuildConfiguration[]> m = new HashMap<String, IBuildConfiguration[]>(numBuildConifgsWithRefs);
                int i3 = 0;
                while (i3 < numBuildConifgsWithRefs) {
                    String configName = dataIn.readUTF();
                    numRefs = dataIn.readInt();
                    IBuildConfiguration[] refs = new IBuildConfiguration[numRefs];
                    int j = 0;
                    while (j < numRefs) {
                        String projName = dataIn.readUTF();
                        refs[j] = dataIn.readBoolean() ? new BuildConfiguration(root.getProject(projName), dataIn.readUTF()) : new BuildConfiguration(root.getProject(projName), null);
                        ++j;
                    }
                    m.put(configName, refs);
                    ++i3;
                }
                description.setBuildConfigReferences(m);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePrivateDescription(IProject target) throws CoreException {
        IPath location = this.locationFor(target).append(".location");
        File file = location.toFile();
        Workspace.clear(file);
        ProjectDescription desc = ((Project)target).internalGetDescription();
        if (desc == null) {
            return;
        }
        URI projectLocation = desc.getLocationURI();
        IProject[] prjRefs = desc.getDynamicReferences(false);
        String[] buildConfigs = desc.configNames;
        Map<String, IBuildConfiguration[]> configRefs = desc.getBuildConfigReferences(false);
        if (projectLocation == null && prjRefs.length == 0 && buildConfigs.length == 0 && configRefs.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try {
                SafeChunkyOutputStream output = new SafeChunkyOutputStream(file);
                try {
                    try (DataOutputStream dataOut = new DataOutputStream(output);){
                        if (projectLocation == null) {
                            dataOut.writeUTF("");
                        } else {
                            dataOut.writeUTF("URI//" + projectLocation);
                        }
                        dataOut.writeInt(prjRefs.length);
                        Object[] objectArray = prjRefs;
                        int n = prjRefs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject prjRef = objectArray[n2];
                            dataOut.writeUTF(prjRef.getName());
                            ++n2;
                        }
                        dataOut.writeInt(buildConfigs.length);
                        objectArray = buildConfigs;
                        n = buildConfigs.length;
                        n2 = 0;
                        while (n2 < n) {
                            Object buildConfig = objectArray[n2];
                            dataOut.writeUTF((String)buildConfig);
                            ++n2;
                        }
                        dataOut.writeUTF(desc.getActiveBuildConfig());
                        dataOut.writeInt(configRefs.size());
                        for (Map.Entry<String, IBuildConfiguration[]> e : configRefs.entrySet()) {
                            String refdName = e.getKey();
                            IBuildConfiguration[] refs = e.getValue();
                            dataOut.writeUTF(refdName);
                            dataOut.writeInt(refs.length);
                            IBuildConfiguration[] iBuildConfigurationArray = refs;
                            int n3 = refs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IBuildConfiguration ref = iBuildConfigurationArray[n4];
                                dataOut.writeUTF(ref.getProject().getName());
                                if (ref.getName() == null) {
                                    dataOut.writeBoolean(false);
                                } else {
                                    dataOut.writeBoolean(true);
                                    dataOut.writeUTF(ref.getName());
                                }
                                ++n4;
                            }
                        }
                        output.succeed();
                    }
                    if (output == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (output == null) throw throwable;
                    output.close();
                    throw throwable;
                }
                output.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = NLS.bind(Messages.resources_exSaveProjectLocation, target.getName());
            throw new ResourceException(566, null, message, e);
        }
    }
}

