/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences.legacy;

import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

@Deprecated
public class PreferenceForwarder
extends Preferences
implements IEclipsePreferences.INodeChangeListener,
IEclipsePreferences.IPreferenceChangeListener {
    private static final byte[] BYTE_ARRAY_DEFAULT_DEFAULT = new byte[0];
    private IEclipsePreferences pluginRoot = (IEclipsePreferences)PreferencesService.getDefault().getRootNode().node("instance");
    private DefaultPreferences defaultsRoot = (DefaultPreferences)PreferencesService.getDefault().getRootNode().node("default");
    private String pluginID;
    private Object plugin;
    private boolean notify = true;

    public PreferenceForwarder(Object plugin, String pluginID) {
        this.plugin = plugin;
        this.pluginID = pluginID;
    }

    @Override
    public synchronized void added(IEclipsePreferences.NodeChangeEvent event) {
        if (this.listeners.size() > 0 && this.pluginID.equals(event.getChild().name())) {
            try {
                EclipsePreferences prefs = (EclipsePreferences)event.getChild();
                prefs.addPreferenceChangeListener(this);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + e.getMessage());
            }
        }
    }

    @Override
    public synchronized void removed(IEclipsePreferences.NodeChangeEvent event) {
    }

    @Override
    public synchronized void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.listeners.size() == 0) {
            EclipsePreferences prefs = this.getPluginPreferences(false);
            if (prefs != null) {
                prefs.addPreferenceChangeListener(this);
            }
            this.pluginRoot.addNodeChangeListener(this);
        }
        this.listeners.add(listener);
    }

    @Override
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        String key = event.getKey();
        if (newValue == null) {
            newValue = this.getDefault(key, oldValue);
        } else if (oldValue == null) {
            oldValue = this.getDefault(key, newValue);
        }
        this.firePropertyChangeEvent(key, oldValue, newValue);
    }

    private EclipsePreferences getPluginPreferences(boolean create) {
        try {
            if (!create && !this.pluginRoot.nodeExists(this.pluginID)) {
                return null;
            }
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
        try {
            return (EclipsePreferences)this.pluginRoot.node(this.pluginID);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + e.getMessage());
        }
    }

    private IEclipsePreferences getDefaultPreferences() {
        return this.defaultsRoot.node(this.pluginID, this.plugin);
    }

    @Override
    public synchronized void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            EclipsePreferences prefs = this.getPluginPreferences(false);
            if (prefs != null) {
                prefs.removePreferenceChangeListener(this);
            }
            this.pluginRoot.removeNodeChangeListener(this);
        }
    }

    private Object getDefault(String key, Object obj) {
        IEclipsePreferences defaults = this.getDefaultPreferences();
        if (obj instanceof String) {
            return defaults.get(key, "");
        }
        if (obj instanceof Integer) {
            return defaults.getInt(key, 0);
        }
        if (obj instanceof Double) {
            return defaults.getDouble(key, 0.0);
        }
        if (obj instanceof Float) {
            return Float.valueOf(defaults.getFloat(key, 0.0f));
        }
        if (obj instanceof Long) {
            return defaults.getLong(key, 0L);
        }
        if (obj instanceof byte[]) {
            return defaults.getByteArray(key, BYTE_ARRAY_DEFAULT_DEFAULT);
        }
        if (obj instanceof Boolean) {
            return defaults.getBoolean(key, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getPluginPreferences(true).getBoolean(name, this.getDefaultPreferences().getBoolean(name, false));
    }

    @Override
    public void setValue(String name, boolean value) {
        Boolean newValue;
        Boolean oldValue = this.getBoolean(name) ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl = newValue = value ? Boolean.TRUE : Boolean.FALSE;
        if (newValue == oldValue) {
            return;
        }
        try {
            this.notify = false;
            if (this.getDefaultBoolean(name) == value) {
                this.getPluginPreferences(true).remove(name);
            } else {
                this.getPluginPreferences(true).putBoolean(name, value);
            }
            this.firePropertyChangeEvent(name, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public boolean getDefaultBoolean(String name) {
        return this.getDefaultPreferences().getBoolean(name, false);
    }

    @Override
    public int getInt(String name) {
        return this.getPluginPreferences(true).getInt(name, this.getDefaultPreferences().getInt(name, 0));
    }

    @Override
    public void setValue(String name, int value) {
        int intValue = this.getInt(name);
        if (value == intValue) {
            return;
        }
        Integer oldValue = intValue;
        Integer newValue = value;
        try {
            this.notify = false;
            if (this.getDefaultInt(name) == value) {
                this.getPluginPreferences(true).remove(name);
            } else {
                this.getPluginPreferences(true).putInt(name, value);
            }
            this.firePropertyChangeEvent(name, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public int getDefaultInt(String name) {
        return this.getDefaultPreferences().getInt(name, 0);
    }

    @Override
    public long getLong(String name) {
        return this.getPluginPreferences(true).getLong(name, this.getDefaultPreferences().getLong(name, 0L));
    }

    @Override
    public void setValue(String name, long value) {
        long longValue = this.getLong(name);
        if (value == longValue) {
            return;
        }
        Long oldValue = longValue;
        Long newValue = value;
        try {
            this.notify = false;
            if (this.getDefaultLong(name) == value) {
                this.getPluginPreferences(true).remove(name);
            } else {
                this.getPluginPreferences(true).putLong(name, value);
            }
            this.firePropertyChangeEvent(name, oldValue, newValue);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public long getDefaultLong(String name) {
        return this.getDefaultPreferences().getLong(name, 0L);
    }

    @Override
    public String getString(String name) {
        return this.getPluginPreferences(true).get(name, this.getDefaultPreferences().get(name, ""));
    }

    @Override
    public void setValue(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        String oldValue = this.getString(name);
        if (value.equals(oldValue)) {
            return;
        }
        try {
            this.notify = false;
            if (this.getDefaultString(name).equals(value)) {
                this.getPluginPreferences(true).remove(name);
            } else {
                this.getPluginPreferences(true).put(name, value);
            }
            this.firePropertyChangeEvent(name, oldValue, value);
        }
        finally {
            this.notify = true;
        }
    }

    @Override
    public String getDefaultString(String name) {
        return this.getDefaultPreferences().get(name, "");
    }

    @Override
    public void setToDefault(String name) {
        EclipsePreferences preferences = this.getPluginPreferences(true);
        String oldValue = preferences.get(name, null);
        if (oldValue != null) {
            preferences.remove(name);
        }
    }

    @Override
    public String[] propertyNames() {
        return this.getPluginPreferences(true).keys();
    }

    public void flush() throws BackingStoreException {
        EclipsePreferences node = this.getPluginPreferences(false);
        if (node != null) {
            node.flush();
        }
    }

    public String toString() {
        return "PreferenceForwarder(" + this.pluginID + ")";
    }
}

